/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dsl;

import com.android.build.gradle.internal.VariantManager;
import com.android.build.gradle.internal.dsl.BaseFlavor;
import com.android.build.gradle.internal.errors.DeprecationReporter;
import com.android.builder.core.DefaultProductFlavor;
import com.android.builder.model.BaseConfig;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;

public class ProductFlavor
extends BaseFlavor {
    private final Property<Boolean> isDefault;
    private ImmutableList<String> matchingFallbacks;

    @Inject
    public ProductFlavor(String name, Project project, ObjectFactory objectFactory, DeprecationReporter deprecationReporter, Logger logger) {
        super(name, project, objectFactory, deprecationReporter, logger);
        this.isDefault = objectFactory.property(Boolean.class).convention((Object)false);
    }

    public void setMatchingFallbacks(String ... fallbacks) {
        this.matchingFallbacks = ImmutableList.copyOf((Object[])fallbacks);
    }

    public void setMatchingFallbacks(String fallback) {
        this.matchingFallbacks = ImmutableList.of((Object)fallback);
    }

    public void setMatchingFallbacks(List<String> fallbacks) {
        this.matchingFallbacks = ImmutableList.copyOf(fallbacks);
    }

    public List<String> getMatchingFallbacks() {
        if (this.matchingFallbacks == null) {
            return ImmutableList.of();
        }
        return this.matchingFallbacks;
    }

    public Property<Boolean> getIsDefault() {
        return this.isDefault;
    }

    protected DefaultProductFlavor.DimensionRequest computeRequestedAndFallBacks(List<String> requestedValues) {
        return new DefaultProductFlavor.DimensionRequest(VariantManager.getModifiedName(this.getName()), ImmutableList.copyOf(requestedValues));
    }

    protected void _initWith(BaseConfig that) {
        if (this == that) {
            return;
        }
        super._initWith(that);
        if (that instanceof ProductFlavor) {
            this.matchingFallbacks = ((ProductFlavor)that).matchingFallbacks;
        }
    }
}

