
package com.android.tools.build.bundletool.splitters;

import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.model.OptimizationDimension;
import com.android.tools.build.bundletool.model.ResourceId;
import com.google.common.collect.ImmutableSet;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
 final class AutoValue_ApkGenerationConfiguration extends ApkGenerationConfiguration {

  private final ImmutableSet<OptimizationDimension> optimizationDimensions;
  private final boolean forInstantAppVariants;
  private final boolean enableNativeLibraryCompressionSplitter;
  private final boolean enableDexCompressionSplitter;
  private final boolean include64BitLibs;
  private final ImmutableSet<Targeting.Abi> abisForPlaceholderLibs;
  private final ImmutableSet<ResourceId> masterPinnedResources;
  private final ImmutableSet<ResourceId> baseManifestReachableResources;

  private AutoValue_ApkGenerationConfiguration(
      ImmutableSet<OptimizationDimension> optimizationDimensions,
      boolean forInstantAppVariants,
      boolean enableNativeLibraryCompressionSplitter,
      boolean enableDexCompressionSplitter,
      boolean include64BitLibs,
      ImmutableSet<Targeting.Abi> abisForPlaceholderLibs,
      ImmutableSet<ResourceId> masterPinnedResources,
      ImmutableSet<ResourceId> baseManifestReachableResources) {
    this.optimizationDimensions = optimizationDimensions;
    this.forInstantAppVariants = forInstantAppVariants;
    this.enableNativeLibraryCompressionSplitter = enableNativeLibraryCompressionSplitter;
    this.enableDexCompressionSplitter = enableDexCompressionSplitter;
    this.include64BitLibs = include64BitLibs;
    this.abisForPlaceholderLibs = abisForPlaceholderLibs;
    this.masterPinnedResources = masterPinnedResources;
    this.baseManifestReachableResources = baseManifestReachableResources;
  }

  @Override
  public ImmutableSet<OptimizationDimension> getOptimizationDimensions() {
    return optimizationDimensions;
  }

  @Override
  public boolean isForInstantAppVariants() {
    return forInstantAppVariants;
  }

  @Override
  public boolean getEnableNativeLibraryCompressionSplitter() {
    return enableNativeLibraryCompressionSplitter;
  }

  @Override
  public boolean getEnableDexCompressionSplitter() {
    return enableDexCompressionSplitter;
  }

  @Override
  public boolean getInclude64BitLibs() {
    return include64BitLibs;
  }

  @Override
  public ImmutableSet<Targeting.Abi> getAbisForPlaceholderLibs() {
    return abisForPlaceholderLibs;
  }

  @Override
  public ImmutableSet<ResourceId> getMasterPinnedResources() {
    return masterPinnedResources;
  }

  @Override
  public ImmutableSet<ResourceId> getBaseManifestReachableResources() {
    return baseManifestReachableResources;
  }

  @Override
  public String toString() {
    return "ApkGenerationConfiguration{"
        + "optimizationDimensions=" + optimizationDimensions + ", "
        + "forInstantAppVariants=" + forInstantAppVariants + ", "
        + "enableNativeLibraryCompressionSplitter=" + enableNativeLibraryCompressionSplitter + ", "
        + "enableDexCompressionSplitter=" + enableDexCompressionSplitter + ", "
        + "include64BitLibs=" + include64BitLibs + ", "
        + "abisForPlaceholderLibs=" + abisForPlaceholderLibs + ", "
        + "masterPinnedResources=" + masterPinnedResources + ", "
        + "baseManifestReachableResources=" + baseManifestReachableResources
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ApkGenerationConfiguration) {
      ApkGenerationConfiguration that = (ApkGenerationConfiguration) o;
      return (this.optimizationDimensions.equals(that.getOptimizationDimensions()))
           && (this.forInstantAppVariants == that.isForInstantAppVariants())
           && (this.enableNativeLibraryCompressionSplitter == that.getEnableNativeLibraryCompressionSplitter())
           && (this.enableDexCompressionSplitter == that.getEnableDexCompressionSplitter())
           && (this.include64BitLibs == that.getInclude64BitLibs())
           && (this.abisForPlaceholderLibs.equals(that.getAbisForPlaceholderLibs()))
           && (this.masterPinnedResources.equals(that.getMasterPinnedResources()))
           && (this.baseManifestReachableResources.equals(that.getBaseManifestReachableResources()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h = 1;
    h *= 1000003;
    h ^= this.optimizationDimensions.hashCode();
    h *= 1000003;
    h ^= this.forInstantAppVariants ? 1231 : 1237;
    h *= 1000003;
    h ^= this.enableNativeLibraryCompressionSplitter ? 1231 : 1237;
    h *= 1000003;
    h ^= this.enableDexCompressionSplitter ? 1231 : 1237;
    h *= 1000003;
    h ^= this.include64BitLibs ? 1231 : 1237;
    h *= 1000003;
    h ^= this.abisForPlaceholderLibs.hashCode();
    h *= 1000003;
    h ^= this.masterPinnedResources.hashCode();
    h *= 1000003;
    h ^= this.baseManifestReachableResources.hashCode();
    return h;
  }

  @Override
  public ApkGenerationConfiguration.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends ApkGenerationConfiguration.Builder {
    private ImmutableSet<OptimizationDimension> optimizationDimensions;
    private Boolean forInstantAppVariants;
    private Boolean enableNativeLibraryCompressionSplitter;
    private Boolean enableDexCompressionSplitter;
    private Boolean include64BitLibs;
    private ImmutableSet<Targeting.Abi> abisForPlaceholderLibs;
    private ImmutableSet<ResourceId> masterPinnedResources;
    private ImmutableSet<ResourceId> baseManifestReachableResources;
    Builder() {
    }
    private Builder(ApkGenerationConfiguration source) {
      this.optimizationDimensions = source.getOptimizationDimensions();
      this.forInstantAppVariants = source.isForInstantAppVariants();
      this.enableNativeLibraryCompressionSplitter = source.getEnableNativeLibraryCompressionSplitter();
      this.enableDexCompressionSplitter = source.getEnableDexCompressionSplitter();
      this.include64BitLibs = source.getInclude64BitLibs();
      this.abisForPlaceholderLibs = source.getAbisForPlaceholderLibs();
      this.masterPinnedResources = source.getMasterPinnedResources();
      this.baseManifestReachableResources = source.getBaseManifestReachableResources();
    }
    @Override
    public ApkGenerationConfiguration.Builder setOptimizationDimensions(ImmutableSet<OptimizationDimension> optimizationDimensions) {
      if (optimizationDimensions == null) {
        throw new NullPointerException("Null optimizationDimensions");
      }
      this.optimizationDimensions = optimizationDimensions;
      return this;
    }
    @Override
    public ApkGenerationConfiguration.Builder setForInstantAppVariants(boolean forInstantAppVariants) {
      this.forInstantAppVariants = forInstantAppVariants;
      return this;
    }
    @Override
    public ApkGenerationConfiguration.Builder setEnableNativeLibraryCompressionSplitter(boolean enableNativeLibraryCompressionSplitter) {
      this.enableNativeLibraryCompressionSplitter = enableNativeLibraryCompressionSplitter;
      return this;
    }
    @Override
    public ApkGenerationConfiguration.Builder setEnableDexCompressionSplitter(boolean enableDexCompressionSplitter) {
      this.enableDexCompressionSplitter = enableDexCompressionSplitter;
      return this;
    }
    @Override
    public ApkGenerationConfiguration.Builder setInclude64BitLibs(boolean include64BitLibs) {
      this.include64BitLibs = include64BitLibs;
      return this;
    }
    @Override
    public ApkGenerationConfiguration.Builder setAbisForPlaceholderLibs(ImmutableSet<Targeting.Abi> abisForPlaceholderLibs) {
      if (abisForPlaceholderLibs == null) {
        throw new NullPointerException("Null abisForPlaceholderLibs");
      }
      this.abisForPlaceholderLibs = abisForPlaceholderLibs;
      return this;
    }
    @Override
    public ApkGenerationConfiguration.Builder setMasterPinnedResources(ImmutableSet<ResourceId> masterPinnedResources) {
      if (masterPinnedResources == null) {
        throw new NullPointerException("Null masterPinnedResources");
      }
      this.masterPinnedResources = masterPinnedResources;
      return this;
    }
    @Override
    public ApkGenerationConfiguration.Builder setBaseManifestReachableResources(ImmutableSet<ResourceId> baseManifestReachableResources) {
      if (baseManifestReachableResources == null) {
        throw new NullPointerException("Null baseManifestReachableResources");
      }
      this.baseManifestReachableResources = baseManifestReachableResources;
      return this;
    }
    @Override
    public ApkGenerationConfiguration build() {
      String missing = "";
      if (this.optimizationDimensions == null) {
        missing += " optimizationDimensions";
      }
      if (this.forInstantAppVariants == null) {
        missing += " forInstantAppVariants";
      }
      if (this.enableNativeLibraryCompressionSplitter == null) {
        missing += " enableNativeLibraryCompressionSplitter";
      }
      if (this.enableDexCompressionSplitter == null) {
        missing += " enableDexCompressionSplitter";
      }
      if (this.include64BitLibs == null) {
        missing += " include64BitLibs";
      }
      if (this.abisForPlaceholderLibs == null) {
        missing += " abisForPlaceholderLibs";
      }
      if (this.masterPinnedResources == null) {
        missing += " masterPinnedResources";
      }
      if (this.baseManifestReachableResources == null) {
        missing += " baseManifestReachableResources";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_ApkGenerationConfiguration(
          this.optimizationDimensions,
          this.forInstantAppVariants,
          this.enableNativeLibraryCompressionSplitter,
          this.enableDexCompressionSplitter,
          this.include64BitLibs,
          this.abisForPlaceholderLibs,
          this.masterPinnedResources,
          this.baseManifestReachableResources);
    }
  }

}
