/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.core;

import com.android.builder.model.ApiVersion;
import com.android.sdklib.SdkVersionInfo;

public final class DefaultApiVersion
implements ApiVersion {
    private final int mApiLevel;
    private final String mCodename;

    public DefaultApiVersion(int apiLevel) {
        this.mApiLevel = apiLevel;
        this.mCodename = null;
    }

    public DefaultApiVersion(String codename) {
        this.mApiLevel = SdkVersionInfo.getApiByBuildCode((String)codename, (boolean)true) - 1;
        this.mCodename = codename;
    }

    public static ApiVersion create(Object value) {
        if (value instanceof Integer) {
            return new DefaultApiVersion((Integer)value);
        }
        if (value instanceof String) {
            return new DefaultApiVersion((String)value);
        }
        return new DefaultApiVersion(1);
    }

    public int getApiLevel() {
        return this.mApiLevel;
    }

    public String getCodename() {
        return this.mCodename;
    }

    public String getApiString() {
        return this.mCodename != null ? this.mCodename : Integer.toString(this.mApiLevel);
    }

    public boolean equals(Object o3) {
        if (this == o3) {
            return true;
        }
        if (o3 == null || this.getClass() != o3.getClass()) {
            return false;
        }
        DefaultApiVersion that = (DefaultApiVersion)o3;
        if (this.mApiLevel != that.mApiLevel) {
            return false;
        }
        return !(this.mCodename != null ? !this.mCodename.equals(that.mCodename) : that.mCodename != null);
    }

    public int hashCode() {
        int result = this.mApiLevel;
        result = 31 * result + (this.mCodename != null ? this.mCodename.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "DefaultApiVersion{mApiLevel=" + this.mApiLevel + ", mCodename='" + this.mCodename + '\'' + '}';
    }
}

