
package com.android.tools.build.bundletool.commands;

import com.android.tools.build.bundletool.device.AdbServer;
import java.nio.file.Path;
import java.util.Optional;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
 final class AutoValue_GetDeviceSpecCommand extends GetDeviceSpecCommand {

  private final Path adbPath;
  private final Optional<String> deviceId;
  private final Path outputPath;
  private final boolean overwriteOutput;
  private final AdbServer adbServer;

  private AutoValue_GetDeviceSpecCommand(
      Path adbPath,
      Optional<String> deviceId,
      Path outputPath,
      boolean overwriteOutput,
      AdbServer adbServer) {
    this.adbPath = adbPath;
    this.deviceId = deviceId;
    this.outputPath = outputPath;
    this.overwriteOutput = overwriteOutput;
    this.adbServer = adbServer;
  }

  @Override
  public Path getAdbPath() {
    return adbPath;
  }

  @Override
  public Optional<String> getDeviceId() {
    return deviceId;
  }

  @Override
  public Path getOutputPath() {
    return outputPath;
  }

  @Override
  public boolean getOverwriteOutput() {
    return overwriteOutput;
  }

  @Override
  AdbServer getAdbServer() {
    return adbServer;
  }

  @Override
  public String toString() {
    return "GetDeviceSpecCommand{"
        + "adbPath=" + adbPath + ", "
        + "deviceId=" + deviceId + ", "
        + "outputPath=" + outputPath + ", "
        + "overwriteOutput=" + overwriteOutput + ", "
        + "adbServer=" + adbServer
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof GetDeviceSpecCommand) {
      GetDeviceSpecCommand that = (GetDeviceSpecCommand) o;
      return (this.adbPath.equals(that.getAdbPath()))
           && (this.deviceId.equals(that.getDeviceId()))
           && (this.outputPath.equals(that.getOutputPath()))
           && (this.overwriteOutput == that.getOverwriteOutput())
           && (this.adbServer.equals(that.getAdbServer()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h = 1;
    h *= 1000003;
    h ^= this.adbPath.hashCode();
    h *= 1000003;
    h ^= this.deviceId.hashCode();
    h *= 1000003;
    h ^= this.outputPath.hashCode();
    h *= 1000003;
    h ^= this.overwriteOutput ? 1231 : 1237;
    h *= 1000003;
    h ^= this.adbServer.hashCode();
    return h;
  }

  static final class Builder extends GetDeviceSpecCommand.Builder {
    private Path adbPath;
    private Optional<String> deviceId = Optional.empty();
    private Path outputPath;
    private Boolean overwriteOutput;
    private AdbServer adbServer;
    Builder() {
    }
    @Override
    public GetDeviceSpecCommand.Builder setAdbPath(Path adbPath) {
      if (adbPath == null) {
        throw new NullPointerException("Null adbPath");
      }
      this.adbPath = adbPath;
      return this;
    }
    @Override
    public GetDeviceSpecCommand.Builder setDeviceId(String deviceId) {
      if (deviceId == null) {
        throw new NullPointerException("Null deviceId");
      }
      this.deviceId = Optional.of(deviceId);
      return this;
    }
    @Override
    public GetDeviceSpecCommand.Builder setOutputPath(Path outputPath) {
      if (outputPath == null) {
        throw new NullPointerException("Null outputPath");
      }
      this.outputPath = outputPath;
      return this;
    }
    @Override
    public GetDeviceSpecCommand.Builder setOverwriteOutput(boolean overwriteOutput) {
      this.overwriteOutput = overwriteOutput;
      return this;
    }
    @Override
    public GetDeviceSpecCommand.Builder setAdbServer(AdbServer adbServer) {
      if (adbServer == null) {
        throw new NullPointerException("Null adbServer");
      }
      this.adbServer = adbServer;
      return this;
    }
    @Override
    GetDeviceSpecCommand autoBuild() {
      String missing = "";
      if (this.adbPath == null) {
        missing += " adbPath";
      }
      if (this.outputPath == null) {
        missing += " outputPath";
      }
      if (this.overwriteOutput == null) {
        missing += " overwriteOutput";
      }
      if (this.adbServer == null) {
        missing += " adbServer";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_GetDeviceSpecCommand(
          this.adbPath,
          this.deviceId,
          this.outputPath,
          this.overwriteOutput,
          this.adbServer);
    }
  }

}
