
package com.android.tools.build.bundletool.model.version;

import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
 final class AutoValue_Version extends Version {

  private final String fullVersion;
  private final int majorVersion;
  private final int minorVersion;
  private final int revisionVersion;
  private final String qualifier;

  private AutoValue_Version(
      String fullVersion,
      int majorVersion,
      int minorVersion,
      int revisionVersion,
      @Nullable String qualifier) {
    this.fullVersion = fullVersion;
    this.majorVersion = majorVersion;
    this.minorVersion = minorVersion;
    this.revisionVersion = revisionVersion;
    this.qualifier = qualifier;
  }

  @Override
  String getFullVersion() {
    return fullVersion;
  }

  @Override
  int getMajorVersion() {
    return majorVersion;
  }

  @Override
  int getMinorVersion() {
    return minorVersion;
  }

  @Override
  int getRevisionVersion() {
    return revisionVersion;
  }

  @Nullable
  @Override
  String getQualifier() {
    return qualifier;
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof Version) {
      Version that = (Version) o;
      return (this.fullVersion.equals(that.getFullVersion()))
           && (this.majorVersion == that.getMajorVersion())
           && (this.minorVersion == that.getMinorVersion())
           && (this.revisionVersion == that.getRevisionVersion())
           && ((this.qualifier == null) ? (that.getQualifier() == null) : this.qualifier.equals(that.getQualifier()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h = 1;
    h *= 1000003;
    h ^= this.fullVersion.hashCode();
    h *= 1000003;
    h ^= this.majorVersion;
    h *= 1000003;
    h ^= this.minorVersion;
    h *= 1000003;
    h ^= this.revisionVersion;
    h *= 1000003;
    h ^= (qualifier == null) ? 0 : this.qualifier.hashCode();
    return h;
  }

  static final class Builder extends Version.Builder {
    private String fullVersion;
    private Integer majorVersion;
    private Integer minorVersion;
    private Integer revisionVersion;
    private String qualifier;
    Builder() {
    }
    @Override
    Version.Builder setFullVersion(String fullVersion) {
      if (fullVersion == null) {
        throw new NullPointerException("Null fullVersion");
      }
      this.fullVersion = fullVersion;
      return this;
    }
    @Override
    Version.Builder setMajorVersion(int majorVersion) {
      this.majorVersion = majorVersion;
      return this;
    }
    @Override
    Version.Builder setMinorVersion(int minorVersion) {
      this.minorVersion = minorVersion;
      return this;
    }
    @Override
    Version.Builder setRevisionVersion(int revisionVersion) {
      this.revisionVersion = revisionVersion;
      return this;
    }
    @Override
    Version.Builder setQualifier(@Nullable String qualifier) {
      this.qualifier = qualifier;
      return this;
    }
    @Override
    Version build() {
      String missing = "";
      if (this.fullVersion == null) {
        missing += " fullVersion";
      }
      if (this.majorVersion == null) {
        missing += " majorVersion";
      }
      if (this.minorVersion == null) {
        missing += " minorVersion";
      }
      if (this.revisionVersion == null) {
        missing += " revisionVersion";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_Version(
          this.fullVersion,
          this.majorVersion,
          this.minorVersion,
          this.revisionVersion,
          this.qualifier);
    }
  }

}
