/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle;

import com.android.build.gradle.BasePlugin;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.dsl.LintOptions;
import com.android.build.gradle.internal.tasks.LintStandaloneTask;
import java.io.File;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.plugins.Convention;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.TaskContainer;

public class LintPlugin
implements Plugin<Project> {
    private Project project;
    private LintOptions lintOptions;

    public void apply(Project project) {
        System.setProperty("java.awt.headless", "true");
        this.project = project;
        this.createExtension(project);
        BasePlugin.createLintClasspathConfiguration(project);
        this.withJavaPlugin((Action<Plugin>)((Action)plugin -> {
            JavaPluginConvention javaConvention = this.getJavaPluginConvention();
            if (javaConvention != null) {
                Configuration customLintChecksConfig = TaskManager.createCustomLintChecksConfig(project);
                String projectName = project.getName();
                LintStandaloneTask task = this.createTask("lint", "Run Android Lint analysis on project '" + projectName + "'", project, javaConvention, customLintChecksConfig);
                project.getTasks().named("check").configure(t -> t.dependsOn(new Object[]{task}));
                LintStandaloneTask lintVital = this.createTask("lintVital", "Runs lint on just the fatal issues in the project '" + projectName + "'", project, javaConvention, customLintChecksConfig);
                lintVital.setFatalOnly(true);
                LintStandaloneTask lintFix = this.createTask("lintFix", "Runs lint on `" + projectName + "` and applies any safe suggestions to the source code.", project, javaConvention, customLintChecksConfig);
                lintFix.setAutoFix(true);
                lintFix.setGroup("cleanup");
            }
        }));
    }

    private void createExtension(Project project) {
        this.lintOptions = (LintOptions)project.getExtensions().create("lintOptions", LintOptions.class, new Object[0]);
    }

    private void withJavaPlugin(Action<Plugin> action) {
        this.project.getPlugins().withType(JavaBasePlugin.class, action);
    }

    private LintStandaloneTask createTask(String taskName, String description, Project project, JavaPluginConvention javaConvention, Configuration customLintChecksConfig) {
        File testResultsDir = javaConvention.getTestResultsDir();
        TaskContainer tasks = project.getTasks();
        LintStandaloneTask task = (LintStandaloneTask)tasks.create(taskName, LintStandaloneTask.class);
        task.setGroup("verification");
        task.setDescription(description);
        task.setReportDir(testResultsDir);
        task.setLintOptions(this.lintOptions);
        task.setLintChecks(customLintChecksConfig);
        task.getOutputs().upToDateWhen(task1 -> false);
        return task;
    }

    private JavaPluginConvention getJavaPluginConvention() {
        Convention convention = this.project.getConvention();
        JavaPluginConvention javaConvention = (JavaPluginConvention)convention.getPlugin(JavaPluginConvention.class);
        if (javaConvention == null) {
            this.project.getLogger().warn("Cannot apply lint if the java or kotlin Gradle plugins have also been applied");
            return null;
        }
        return javaConvention;
    }
}

