/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dependency;

import com.android.build.api.attributes.BuildTypeAttr;
import com.android.build.api.attributes.ProductFlavorAttr;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.gradle.api.Named;
import org.gradle.api.attributes.AttributeCompatibilityRule;
import org.gradle.api.attributes.CompatibilityCheckDetails;

public class AlternateCompatibilityRule<T extends Named>
implements AttributeCompatibilityRule<T> {
    private final Map<String, List<String>> alternates;

    protected AlternateCompatibilityRule(Map<String, List<String>> alternates) {
        this.alternates = alternates;
    }

    public void execute(CompatibilityCheckDetails<T> details) {
        Named consumerValue;
        Named producerValue = (Named)details.getProducerValue();
        if (producerValue.equals(consumerValue = (Named)details.getConsumerValue())) {
            details.compatible();
        } else {
            List<String> alternatesForValue = this.alternates.get(consumerValue.getName());
            if (alternatesForValue != null && alternatesForValue.contains(producerValue.getName())) {
                details.compatible();
            }
        }
    }

    public static class ProductFlavorRule
    extends AlternateCompatibilityRule<ProductFlavorAttr> {
        @Inject
        public ProductFlavorRule(Map<String, List<String>> alternates) {
            super(alternates);
        }
    }

    public static class BuildTypeRule
    extends AlternateCompatibilityRule<BuildTypeAttr> {
        @Inject
        public BuildTypeRule(Map<String, List<String>> alternates) {
            super(alternates);
        }
    }
}

