/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dependency;

import com.android.build.gradle.internal.dependency.AndroidTypeAttr;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.Named;
import org.gradle.api.attributes.AttributeDisambiguationRule;
import org.gradle.api.attributes.MultipleCandidatesDetails;

public final class AndroidTypeAttrDisambRule
implements AttributeDisambiguationRule<AndroidTypeAttr> {
    public static final Set<String> FEATURE_AND_AAR = ImmutableSet.of((Object)"Feature", (Object)"Aar");

    @Inject
    public AndroidTypeAttrDisambRule() {
    }

    public void execute(MultipleCandidatesDetails<AndroidTypeAttr> details) {
        Map<String, AndroidTypeAttr> valueMap;
        Set values = details.getCandidateValues();
        if (values.size() == 2 && (valueMap = values.stream().filter(Objects::nonNull).collect(Collectors.toMap(Named::getName, value -> value))).keySet().equals(FEATURE_AND_AAR)) {
            details.closestMatch((Object)valueMap.get("Feature"));
        }
    }
}

