/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.scope;

import com.android.build.FilterData;
import com.android.build.VariantOutput;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.ide.FilterDataImpl;
import com.android.build.gradle.internal.scope.ApkData;
import com.android.build.gradle.internal.scope.OutputScope;
import com.android.utils.Pair;
import com.android.utils.StringHelper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class OutputFactory {
    static final String UNIVERSAL = "universal";
    private final String projectBaseName;
    private final GradleVariantConfiguration variantConfiguration;
    private final OutputScope.Builder outputScopeBuilder;
    private final Supplier<OutputScope> outputSupplier;

    public OutputFactory(String projectBaseName, GradleVariantConfiguration variantConfiguration) {
        this.projectBaseName = projectBaseName;
        this.variantConfiguration = variantConfiguration;
        this.outputScopeBuilder = new OutputScope.Builder();
        this.outputSupplier = Suppliers.memoize(this.outputScopeBuilder::build);
    }

    private String getOutputFileName(String baseName) {
        String suffix = this.variantConfiguration.isSigningReady() || !this.variantConfiguration.getType().isBaseModule() ? ".apk" : "-unsigned.apk";
        return this.projectBaseName + "-" + baseName + suffix;
    }

    public ApkData addMainOutput(String defaultFilename) {
        Main mainOutput = new Main(this.variantConfiguration.getBaseName(), this.variantConfiguration.getFullName(), defaultFilename);
        this.outputScopeBuilder.addMainSplit(mainOutput);
        return mainOutput;
    }

    public ApkData addMainApk() {
        return this.addMainOutput(this.getOutputFileName(this.variantConfiguration.getBaseName()));
    }

    public ApkData addUniversalApk() {
        String baseName = this.variantConfiguration.computeBaseNameWithSplits(UNIVERSAL);
        Universal mainApk = new Universal(baseName, this.variantConfiguration.computeFullNameWithSplits(UNIVERSAL), this.getOutputFileName(baseName));
        this.outputScopeBuilder.addMainSplit(mainApk);
        return mainApk;
    }

    public ApkData addFullSplit(ImmutableList<Pair<VariantOutput.FilterType, String>> filters) {
        ImmutableList filtersList = ImmutableList.copyOf((Collection)filters.stream().map(filter -> new FilterDataImpl((VariantOutput.FilterType)filter.getFirst(), (String)filter.getSecond())).collect(Collectors.toList()));
        String filterName = FullSplit._getFilterName((ImmutableList<FilterData>)filtersList);
        String baseName = this.variantConfiguration.computeBaseNameWithSplits(filterName);
        FullSplit apkData = new FullSplit(filterName, baseName, this.variantConfiguration.computeFullNameWithSplits(filterName), this.getOutputFileName(baseName), filtersList);
        this.outputScopeBuilder.addSplit(apkData);
        return apkData;
    }

    public ApkData addConfigurationSplit(VariantOutput.FilterType filterType, String filterValue) {
        String baseName = this.variantConfiguration.computeBaseNameWithSplits(filterValue);
        return this.addConfigurationSplit(filterType, filterValue, this.getOutputFileName(baseName));
    }

    @VisibleForTesting
    public ApkData addConfigurationSplit(VariantOutput.FilterType filterType, String filterValue, String fileName) {
        ConfigurationSplitApkData apkData = new ConfigurationSplitApkData(filterType, filterValue, this.variantConfiguration.computeBaseNameWithSplits(filterValue), this.variantConfiguration.getFullName(), this.variantConfiguration.getDirName(), fileName);
        this.outputScopeBuilder.addSplit(apkData);
        return apkData;
    }

    public OutputScope getOutput() {
        return this.outputSupplier.get();
    }

    public static class ConfigurationSplitApkData
    extends ApkData {
        private final String filterName;
        private final String baseName;
        private final String fullName;
        private final String dirName;
        private final ImmutableList<FilterData> filters;

        public ConfigurationSplitApkData(VariantOutput.FilterType filterType, String filterName, String baseName, String fullName, String dirName, String fileName) {
            this.filters = ImmutableList.of((Object)new FilterDataImpl(filterType, filterName));
            this.filterName = filterName;
            this.baseName = baseName;
            this.fullName = fullName;
            this.dirName = dirName;
            this.setOutputFileName(fileName);
        }

        @Override
        public VariantOutput.OutputType getType() {
            return VariantOutput.OutputType.SPLIT;
        }

        @Override
        public boolean requiresAapt() {
            return false;
        }

        @Override
        public String getFilterName() {
            return this.filterName;
        }

        public ImmutableList<FilterData> getFilters() {
            return this.filters;
        }

        @Override
        public String getBaseName() {
            return this.baseName;
        }

        @Override
        public String getFullName() {
            return this.fullName;
        }

        @Override
        public String getDirName() {
            return this.dirName;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ConfigurationSplitApkData that = (ConfigurationSplitApkData)o;
            return Objects.equals(this.baseName, that.baseName) && Objects.equals(this.fullName, that.fullName) && Objects.equals(this.dirName, that.dirName) && Objects.equals(this.filterName, that.filterName);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.baseName, this.fullName, this.dirName, this.filterName);
        }
    }

    static class FullSplit
    extends Universal {
        private final ImmutableList<FilterData> filters;
        private final String filterName;

        private FullSplit(String filterName, String baseName, String fullName, String fileName, ImmutableList<FilterData> filters) {
            super(baseName, fullName, fileName);
            this.filterName = filterName;
            this.filters = filters;
        }

        private static String _getFilterName(ImmutableList<FilterData> filters) {
            String abiFilter;
            StringBuilder sb = new StringBuilder();
            String densityFilter = ApkData.getFilter(filters, VariantOutput.FilterType.DENSITY);
            if (densityFilter != null) {
                sb.append(densityFilter);
            }
            if ((abiFilter = FullSplit.getFilter(filters, VariantOutput.FilterType.ABI)) != null) {
                StringHelper.appendCamelCase((StringBuilder)sb, (String)abiFilter);
            }
            return sb.toString();
        }

        @Override
        public VariantOutput.OutputType getType() {
            return VariantOutput.OutputType.FULL_SPLIT;
        }

        public ImmutableList<FilterData> getFilters() {
            return this.filters;
        }

        @Override
        public String getFilterName() {
            return this.filterName;
        }

        @Override
        public String getDirName() {
            StringBuilder sb = new StringBuilder();
            for (FilterData filter : this.getFilters()) {
                sb.append(filter.getIdentifier()).append(File.separatorChar);
            }
            return sb.toString();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FullSplit that = (FullSplit)o;
            return Objects.equals(this.filterName, that.filterName) && Objects.equals(this.filters, that.filters);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.filterName, this.filters);
        }
    }

    private static class Universal
    extends ApkData {
        private final String baseName;
        private final String fullName;

        private Universal(String baseName, String fullName, String fileName) {
            this.baseName = baseName;
            this.fullName = fullName;
            this.setOutputFileName(fileName);
        }

        @Override
        public VariantOutput.OutputType getType() {
            return VariantOutput.OutputType.FULL_SPLIT;
        }

        @Override
        public String getFilterName() {
            return OutputFactory.UNIVERSAL;
        }

        @Override
        public String getBaseName() {
            return this.baseName;
        }

        @Override
        public String getFullName() {
            return this.fullName;
        }

        @Override
        public String getDirName() {
            Preconditions.checkState((boolean)this.getFilters().isEmpty(), (Object)"Universal APKs shouldn't have any filters set.");
            return OutputFactory.UNIVERSAL;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Universal that = (Universal)o;
            return Objects.equals(this.baseName, that.baseName) && Objects.equals(this.fullName, that.fullName);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.baseName, this.fullName);
        }
    }

    private static final class Main
    extends ApkData {
        private final String baseName;
        private final String fullName;

        private Main(String baseName, String fullName, String fileName) {
            this.baseName = baseName;
            this.fullName = fullName;
            this.setOutputFileName(fileName);
        }

        @Override
        public VariantOutput.OutputType getType() {
            return VariantOutput.OutputType.MAIN;
        }

        @Override
        public String getFilterName() {
            return null;
        }

        @Override
        public String getBaseName() {
            return this.baseName;
        }

        @Override
        public String getFullName() {
            return this.fullName;
        }

        @Override
        public String getDirName() {
            return "";
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.baseName, this.fullName);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Main that = (Main)o;
            return Objects.equals(this.baseName, that.baseName) && Objects.equals(this.fullName, that.fullName);
        }
    }
}

