/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.internal.cxx.model.CxxAbiModel;
import com.android.build.gradle.internal.cxx.model.CxxModuleModel;
import com.android.build.gradle.internal.cxx.model.CxxVariantModel;
import com.android.build.gradle.internal.cxx.services.CxxProcessServiceKt;
import com.android.build.gradle.tasks.CmakeExternalNativeJsonGenerator;
import com.android.ide.common.process.ProcessInfoBuilder;
import com.google.wireless.android.sdk.stats.GradleBuildVariant;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0006H\u0016J\u001b\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00052\u0006\u0010\f\u001a\u00020\u0006H\u0010\u00a2\u0006\u0002\b\u000e\u00a8\u0006\u000f"}, d2={"Lcom/android/build/gradle/tasks/CmakeAndroidNinjaExternalNativeJsonGenerator;", "Lcom/android/build/gradle/tasks/CmakeExternalNativeJsonGenerator;", "variant", "Lcom/android/build/gradle/internal/cxx/model/CxxVariantModel;", "abis", "", "Lcom/android/build/gradle/internal/cxx/model/CxxAbiModel;", "stats", "Lcom/google/wireless/android/sdk/stats/GradleBuildVariant$Builder;", "(Lcom/android/build/gradle/internal/cxx/model/CxxVariantModel;Ljava/util/List;Lcom/google/wireless/android/sdk/stats/GradleBuildVariant$Builder;)V", "executeProcessAndGetOutput", "", "abi", "getCacheArguments", "getCacheArguments$gradle", "gradle"})
public final class CmakeAndroidNinjaExternalNativeJsonGenerator
extends CmakeExternalNativeJsonGenerator {
    @NotNull
    public List<String> getCacheArguments$gradle(@NotNull CxxAbiModel abi) {
        Intrinsics.checkParameterIsNotNull((Object)abi, (String)"abi");
        List<String> cacheArguments = this.getCommonCacheArguments(abi);
        cacheArguments.add("-DCMAKE_TOOLCHAIN_FILE=" + abi.getVariant().getModule().getCmakeToolchainFile().getAbsolutePath());
        cacheArguments.add("-DCMAKE_MAKE_PROGRAM=" + this.cmake.getNinjaExe().getAbsolutePath());
        cacheArguments.add("-GAndroid Gradle - Ninja");
        List<String> list = cacheArguments;
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"cacheArguments");
        return list;
    }

    @Override
    @NotNull
    public String executeProcessAndGetOutput(@NotNull CxxAbiModel abi) {
        Intrinsics.checkParameterIsNotNull((Object)abi, (String)"abi");
        String logPrefix = this.variant.getVariantName() + '|' + abi.getAbi().getTag() + " :";
        CxxModuleModel cxxModuleModel = abi.getVariant().getModule();
        File file = abi.getCxxBuildFolder();
        String string = "android_gradle_generate_cmake_ninja_json_" + abi.getAbi().getTag();
        ProcessInfoBuilder processInfoBuilder = this.getProcessBuilder(abi);
        Intrinsics.checkExpressionValueIsNotNull((Object)processInfoBuilder, (String)"getProcessBuilder(abi)");
        return CxxProcessServiceKt.createProcessOutputJunction(cxxModuleModel, file, string, processInfoBuilder, logPrefix).logStderrToInfo().logStdoutToInfo().executeAndReturnStdoutString();
    }

    public CmakeAndroidNinjaExternalNativeJsonGenerator(@NotNull CxxVariantModel variant, @NotNull List<? extends CxxAbiModel> abis, @NotNull GradleBuildVariant.Builder stats) {
        Intrinsics.checkParameterIsNotNull((Object)variant, (String)"variant");
        Intrinsics.checkParameterIsNotNull(abis, (String)"abis");
        Intrinsics.checkParameterIsNotNull((Object)stats, (String)"stats");
        super(variant, abis, stats);
    }
}

