/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Status;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.transforms.TransformInputUtil;
import com.android.builder.desugaring.DesugaringClassAnalyzer;
import com.android.builder.desugaring.DesugaringData;
import com.android.builder.desugaring.DesugaringGraph;
import com.android.builder.desugaring.DesugaringGraphs;
import com.android.ide.common.internal.WaitableExecutor;
import com.google.common.base.Stopwatch;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

class DesugarIncrementalTransformHelper {
    private static final LoggerWrapper logger = LoggerWrapper.getLogger(DesugarIncrementalTransformHelper.class);
    private final String projectVariant;
    private final TransformInvocation invocation;
    private final WaitableExecutor executor;
    private final Supplier<Set<Path>> changedPaths = Suppliers.memoize(this::findChangedPaths);
    private final Supplier<DesugaringGraph> desugaringGraph;

    DesugarIncrementalTransformHelper(String projectVariant, TransformInvocation invocation, WaitableExecutor executor) {
        DesugaringGraph graph;
        this.projectVariant = projectVariant;
        this.invocation = invocation;
        this.executor = executor;
        if (!invocation.isIncremental()) {
            DesugaringGraphs.invalidate((String)projectVariant);
            graph = null;
        } else {
            graph = DesugaringGraphs.updateVariant((String)projectVariant, () -> DesugarIncrementalTransformHelper.getIncrementalData(this.changedPaths, executor));
        }
        this.desugaringGraph = graph != null ? () -> graph : Suppliers.memoize(this::makeDesugaringGraph);
    }

    Set<Path> getAdditionalPaths() throws InterruptedException {
        if (!this.invocation.isIncremental()) {
            return ImmutableSet.of();
        }
        Stopwatch stopwatch = Stopwatch.createStarted();
        logger.verbose("Desugaring dependencies incrementally.", new Object[0]);
        HashSet<Path> additionalPaths = new HashSet<Path>();
        for (Path changed : this.changedPaths.get()) {
            for (Path path : this.desugaringGraph.get().getDependentPaths(changed)) {
                if (this.changedPaths.get().contains(path)) continue;
                additionalPaths.add(path);
            }
        }
        logger.verbose("Time to calculate desugaring dependencies: %d", stopwatch.elapsed(TimeUnit.MILLISECONDS));
        logger.verbose("Additional paths to desugar: %s", ((Object)additionalPaths).toString());
        return additionalPaths;
    }

    private DesugaringGraph makeDesugaringGraph() {
        if (!this.invocation.isIncremental()) {
            return DesugaringGraphs.forVariant((String)this.projectVariant, DesugarIncrementalTransformHelper.getInitalGraphData(this.invocation, this.executor));
        }
        return DesugaringGraphs.forVariant((String)this.projectVariant, () -> DesugarIncrementalTransformHelper.getInitalGraphData(this.invocation, this.executor), () -> DesugarIncrementalTransformHelper.getIncrementalData(this.changedPaths, this.executor));
    }

    private static Collection<DesugaringData> getInitalGraphData(TransformInvocation invocation, WaitableExecutor executor) {
        Set data = Sets.newConcurrentHashSet();
        for (TransformInput input : DesugarIncrementalTransformHelper.getAllInputs(invocation)) {
            for (QualifiedContent qualifiedContent : Iterables.concat((Iterable)input.getDirectoryInputs(), (Iterable)input.getJarInputs())) {
                executor.execute(() -> {
                    Path toProcess = qualifiedContent.getFile().toPath();
                    try {
                        if (Files.exists(toProcess, new LinkOption[0])) {
                            data.addAll(DesugaringClassAnalyzer.analyze((Path)toProcess));
                        }
                        return null;
                    }
                    catch (Throwable t) {
                        logger.error(t, "error processing %s", toProcess);
                        throw t;
                    }
                });
            }
        }
        try {
            executor.waitForTasksWithQuickFail(true);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Unable to get desugaring graph", e);
        }
        return data;
    }

    private static Set<DesugaringData> getIncrementalData(Supplier<Set<Path>> changedPaths, WaitableExecutor executor) {
        Set data = Sets.newConcurrentHashSet();
        for (Path input : changedPaths.get()) {
            if (Files.notExists(input, new LinkOption[0])) {
                data.add(DesugaringClassAnalyzer.forRemoved((Path)input));
                continue;
            }
            executor.execute(() -> {
                try {
                    data.addAll(DesugaringClassAnalyzer.analyze((Path)input));
                    return null;
                }
                catch (Throwable t) {
                    logger.error(t, "error processing %s", input);
                    throw t;
                }
            });
        }
        try {
            executor.waitForTasksWithQuickFail(true);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Unable to get desugaring graph", e);
        }
        return data;
    }

    private Set<Path> findChangedPaths() {
        HashSet changedPaths = Sets.newHashSet();
        for (TransformInput input : DesugarIncrementalTransformHelper.getAllInputs(this.invocation)) {
            for (DirectoryInput dirInput : input.getDirectoryInputs()) {
                Map<Status, Set<File>> byStatus = TransformInputUtil.getByStatus(dirInput);
                for (File modifiedFile : Iterables.concat((Iterable)byStatus.get(Status.CHANGED), (Iterable)byStatus.get(Status.REMOVED), (Iterable)byStatus.get(Status.ADDED))) {
                    if (!modifiedFile.toString().endsWith(".class")) continue;
                    changedPaths.add(modifiedFile.toPath());
                }
            }
            for (JarInput jarInput : input.getJarInputs()) {
                if (jarInput.getStatus() == Status.NOTCHANGED) continue;
                changedPaths.add(jarInput.getFile().toPath());
            }
        }
        return changedPaths;
    }

    private static Iterable<TransformInput> getAllInputs(TransformInvocation invocation) {
        return Iterables.concat((Iterable)invocation.getInputs(), (Iterable)invocation.getReferencedInputs());
    }

    public Set<Path> getDependenciesPaths(Path path) {
        return this.desugaringGraph.get().getDependenciesPaths(path);
    }
}

