/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.VariantOutput;
import com.android.build.api.artifact.ArtifactType;
import com.android.build.api.artifact.BuildableArtifact;
import com.android.build.gradle.internal.scope.BuildArtifactsHolder;
import com.android.build.gradle.internal.scope.BuildElements;
import com.android.build.gradle.internal.scope.BuildOutput;
import com.android.build.gradle.internal.scope.ExistingBuildElements;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.utils.FileUtils;
import com.android.utils.PathUtils;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import org.gradle.api.file.Directory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;

@CacheableTask
public class PackageForUnitTest
extends NonIncrementalTask {
    BuildableArtifact resApk;
    ListProperty<Directory> mergedAssets;
    File apkForUnitTest;

    @Override
    protected void doTaskAction() throws IOException {
        FileUtils.copyFile((File)PackageForUnitTest.apkFrom(this.resApk), (File)this.apkForUnitTest);
        URI uri = URI.create("jar:" + this.apkForUnitTest.toURI());
        try (FileSystem apkFs = FileSystems.newFileSystem(uri, Collections.emptyMap());){
            final Path apkAssetsPath = apkFs.getPath("/assets", new String[0]);
            for (Directory mergedAsset : (List)this.mergedAssets.get()) {
                final Path mergedAssetsPath = mergedAsset.getAsFile().toPath();
                Files.walkFileTree(mergedAssetsPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                        String relativePath = PathUtils.toSystemIndependentPath((Path)mergedAssetsPath.relativize(path));
                        Path destPath = apkAssetsPath.resolve(relativePath);
                        Files.createDirectories(destPath.getParent(), new FileAttribute[0]);
                        Files.copy(path, destPath, new CopyOption[0]);
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
        }
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.NONE)
    public BuildableArtifact getResApk() {
        return this.resApk;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.NONE)
    public ListProperty<Directory> getMergedAssets() {
        return this.mergedAssets;
    }

    @OutputFile
    public File getApkForUnitTest() {
        return this.apkForUnitTest;
    }

    static File apkFrom(BuildableArtifact compiledResourcesZip) {
        BuildElements builtElements = ExistingBuildElements.from((ArtifactType)InternalArtifactType.PROCESSED_RES, compiledResourcesZip);
        if (builtElements.size() == 1) {
            return ((BuildOutput)Iterables.getOnlyElement((Iterable)builtElements)).getOutputFile();
        }
        for (BuildOutput buildOutput : builtElements.getElements()) {
            if (buildOutput.getFilters().isEmpty()) {
                return buildOutput.getOutputFile();
            }
            if (buildOutput.getFilters().size() != 1 || buildOutput.getFilter(VariantOutput.FilterType.ABI.name()) == null) continue;
            return buildOutput.getOutputFile();
        }
        if (builtElements.isEmpty()) {
            throw new RuntimeException("No resources build output, please file a bug.");
        }
        StringBuilder sb = new StringBuilder("Found following build outputs : \n");
        builtElements.forEach(it -> sb.append("BuildOutput: ${Joiner.on(',').join(it.filters)}\n"));
        sb.append("Cannot find a build output with all resources, please file a bug.");
        throw new RuntimeException(sb.toString());
    }

    public static class CreationAction
    extends VariantTaskCreationAction<PackageForUnitTest> {
        private File apkForUnitTest;

        public CreationAction(VariantScope scope) {
            super(scope);
        }

        @Override
        public String getName() {
            return this.getVariantScope().getTaskName("package", "ForUnitTest");
        }

        @Override
        public Class<PackageForUnitTest> getType() {
            return PackageForUnitTest.class;
        }

        @Override
        public void preConfigure(String taskName) {
            super.preConfigure(taskName);
            this.apkForUnitTest = this.getVariantScope().getArtifacts().appendArtifact((ArtifactType)InternalArtifactType.APK_FOR_LOCAL_TEST, taskName, "apk-for-local-test.ap_");
        }

        @Override
        public void configure(PackageForUnitTest task) {
            super.configure(task);
            BuildArtifactsHolder artifacts = this.getVariantScope().getArtifacts();
            task.resApk = artifacts.getArtifactFiles(InternalArtifactType.PROCESSED_RES);
            task.mergedAssets = artifacts.getFinalProducts(InternalArtifactType.MERGED_ASSETS);
            task.apkForUnitTest = this.apkForUnitTest;
        }
    }
}

