/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.scheduling;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.scheduling.GlobalQueue;
import kotlinx.coroutines.scheduling.Task;
import kotlinx.coroutines.scheduling.TasksKt;
import kotlinx.coroutines.scheduling.WorkQueue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0013J\u0016\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0013J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u0005H\u0002J\u0015\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b\u0018J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u001a\u001a\u0004\u0018\u00010\u0005J!\u0010\u001b\u001a\u0004\u0018\u00010\u00052\u0014\b\u0002\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00100\u001dH\u0082\bJ\r\u0010\u001e\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\u001fJ\u0010\u0010 \u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0005H\u0002J\u0016\u0010!\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0013J \u0010#\u001a\u00020\u00102\u0006\u0010$\u001a\u00020%2\u0006\u0010\"\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u0016\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lkotlinx/coroutines/scheduling/WorkQueue;", "", "()V", "buffer", "Ljava/util/concurrent/atomic/AtomicReferenceArray;", "Lkotlinx/coroutines/scheduling/Task;", "bufferSize", "", "getBufferSize$kotlinx_coroutines_core", "()I", "consumerIndex", "Lkotlinx/atomicfu/AtomicInt;", "lastScheduledTask", "Lkotlinx/atomicfu/AtomicRef;", "producerIndex", "add", "", "task", "globalQueue", "Lkotlinx/coroutines/scheduling/GlobalQueue;", "addLast", "addToGlobalQueue", "", "offloadAllWork", "offloadAllWork$kotlinx_coroutines_core", "offloadWork", "poll", "pollExternal", "predicate", "Lkotlin/Function1;", "size", "size$kotlinx_coroutines_core", "tryAddLast", "trySteal", "victim", "tryStealLastScheduled", "time", "", "kotlinx-coroutines-core"})
public final class WorkQueue {
    private final AtomicReferenceArray<Task> buffer = new AtomicReferenceArray(128);
    private volatile Object lastScheduledTask = null;
    private static final AtomicReferenceFieldUpdater lastScheduledTask$FU = AtomicReferenceFieldUpdater.newUpdater(WorkQueue.class, Object.class, "lastScheduledTask");
    volatile int producerIndex = 0;
    static final AtomicIntegerFieldUpdater producerIndex$FU = AtomicIntegerFieldUpdater.newUpdater(WorkQueue.class, "producerIndex");
    volatile int consumerIndex = 0;
    static final AtomicIntegerFieldUpdater consumerIndex$FU = AtomicIntegerFieldUpdater.newUpdater(WorkQueue.class, "consumerIndex");

    public final int getBufferSize$kotlinx_coroutines_core() {
        return this.producerIndex - this.consumerIndex;
    }

    @Nullable
    public final Task poll() {
        Task task;
        block4: {
            int index$iv;
            task = lastScheduledTask$FU.getAndSet(this, null);
            if (task != null) break block4;
            WorkQueue this_$iv = this;
            boolean $i$f$pollExternal = false;
            while (true) {
                Task element$iv;
                int tailLocal$iv;
                if ((tailLocal$iv = this_$iv.consumerIndex) - this_$iv.producerIndex == 0) {
                    task = null;
                    break block4;
                }
                index$iv = tailLocal$iv & 0x7F;
                if ((Task)this_$iv.buffer.get(index$iv) == null) {
                    continue;
                }
                Task it = element$iv;
                if (!true) {
                    task = null;
                    break block4;
                }
                if (consumerIndex$FU.compareAndSet(this_$iv, tailLocal$iv, tailLocal$iv + 1)) break;
            }
            task = this_$iv.buffer.getAndSet(index$iv, null);
        }
        return task;
    }

    public final boolean add(@NotNull Task task, @NotNull GlobalQueue globalQueue) {
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        Intrinsics.checkParameterIsNotNull((Object)globalQueue, (String)"globalQueue");
        Task task2 = lastScheduledTask$FU.getAndSet(this, task);
        if (task2 == null) {
            return true;
        }
        Task previous = task2;
        return this.addLast(previous, globalQueue);
    }

    public final boolean addLast(@NotNull Task task, @NotNull GlobalQueue globalQueue) {
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        Intrinsics.checkParameterIsNotNull((Object)globalQueue, (String)"globalQueue");
        boolean noOffloadingHappened = true;
        while (!this.tryAddLast(task)) {
            this.offloadWork(globalQueue);
            noOffloadingHappened = false;
        }
        return noOffloadingHappened;
    }

    public final boolean trySteal(@NotNull WorkQueue victim, @NotNull GlobalQueue globalQueue) {
        Intrinsics.checkParameterIsNotNull((Object)victim, (String)"victim");
        Intrinsics.checkParameterIsNotNull((Object)globalQueue, (String)"globalQueue");
        long time = TasksKt.schedulerTimeSource.nanoTime();
        int bufferSize = victim.getBufferSize$kotlinx_coroutines_core();
        if (bufferSize == 0) {
            return this.tryStealLastScheduled(time, victim, globalQueue);
        }
        boolean wasStolen = false;
        int n = RangesKt.coerceAtLeast((int)(bufferSize / 2), (int)1);
        int n2 = n;
        for (int i = 0; i < n2; ++i) {
            Task task;
            block7: {
                int index$iv;
                int it = i;
                boolean bl = false;
                WorkQueue this_$iv = victim;
                boolean $i$f$pollExternal = false;
                while (true) {
                    Task element$iv;
                    int tailLocal$iv;
                    if ((tailLocal$iv = this_$iv.consumerIndex) - this_$iv.producerIndex == 0) {
                        task = null;
                        break block7;
                    }
                    index$iv = tailLocal$iv & 0x7F;
                    if ((Task)this_$iv.buffer.get(index$iv) == null) {
                        continue;
                    }
                    Task task2 = element$iv;
                    boolean bl2 = false;
                    if (!(time - task2.submissionTime >= TasksKt.WORK_STEALING_TIME_RESOLUTION_NS || victim.getBufferSize$kotlinx_coroutines_core() > TasksKt.QUEUE_SIZE_OFFLOAD_THRESHOLD)) {
                        task = null;
                        break block7;
                    }
                    if (consumerIndex$FU.compareAndSet(this_$iv, tailLocal$iv, tailLocal$iv + 1)) break;
                }
                task = this_$iv.buffer.getAndSet(index$iv, null);
            }
            if (task == null) {
                return wasStolen;
            }
            Task task3 = task;
            wasStolen = true;
            this.add(task3, globalQueue);
        }
        return wasStolen;
    }

    private final boolean tryStealLastScheduled(long time, WorkQueue victim, GlobalQueue globalQueue) {
        Task task = (Task)victim.lastScheduledTask;
        if (task == null) {
            return false;
        }
        Task lastScheduled = task;
        if (time - lastScheduled.submissionTime < TasksKt.WORK_STEALING_TIME_RESOLUTION_NS) {
            return false;
        }
        if (lastScheduledTask$FU.compareAndSet(victim, lastScheduled, null)) {
            this.add(lastScheduled, globalQueue);
            return true;
        }
        return false;
    }

    public final int size$kotlinx_coroutines_core() {
        return this.lastScheduledTask != null ? this.getBufferSize$kotlinx_coroutines_core() + 1 : this.getBufferSize$kotlinx_coroutines_core();
    }

    private final void offloadWork(GlobalQueue globalQueue) {
        int n = RangesKt.coerceAtLeast((int)(this.getBufferSize$kotlinx_coroutines_core() / 2), (int)1);
        int n2 = n;
        for (int i = 0; i < n2; ++i) {
            Task task;
            block6: {
                int index$iv;
                int it = i;
                boolean bl = false;
                WorkQueue this_$iv = this;
                boolean $i$f$pollExternal = false;
                while (true) {
                    Task element$iv;
                    int tailLocal$iv;
                    if ((tailLocal$iv = this_$iv.consumerIndex) - this_$iv.producerIndex == 0) {
                        task = null;
                        break block6;
                    }
                    index$iv = tailLocal$iv & 0x7F;
                    if ((Task)this_$iv.buffer.get(index$iv) == null) {
                        continue;
                    }
                    Task it2 = element$iv;
                    if (!true) {
                        task = null;
                        break block6;
                    }
                    if (consumerIndex$FU.compareAndSet(this_$iv, tailLocal$iv, tailLocal$iv + 1)) break;
                }
                task = this_$iv.buffer.getAndSet(index$iv, null);
            }
            if (task == null) {
                return;
            }
            Task task2 = task;
            this.addToGlobalQueue(globalQueue, task2);
        }
    }

    private final void addToGlobalQueue(GlobalQueue globalQueue, Task task) {
        boolean bl = globalQueue.addLast(task);
        if (!bl) {
            boolean bl2 = false;
            String string = "GlobalQueue could not be closed yet";
            throw (Throwable)new IllegalStateException(string.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void offloadAllWork$kotlinx_coroutines_core(@NotNull GlobalQueue globalQueue) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)globalQueue, (String)"globalQueue");
        Task task = lastScheduledTask$FU.getAndSet(this, null);
        if (task != null) {
            object = task;
            Task it = object;
            boolean bl = false;
            this.addToGlobalQueue(globalQueue, it);
        }
        while (true) {
            Task task2;
            Task task3;
            WorkQueue workQueue;
            GlobalQueue globalQueue2;
            block7: {
                int index$iv;
                void this_$iv;
                object = this;
                globalQueue2 = globalQueue;
                workQueue = this;
                boolean $i$f$pollExternal = false;
                while (true) {
                    Task element$iv;
                    int tailLocal$iv;
                    if ((tailLocal$iv = this_$iv.consumerIndex) - this_$iv.producerIndex == 0) {
                        task3 = null;
                        break block7;
                    }
                    index$iv = tailLocal$iv & 0x7F;
                    if ((Task)((WorkQueue)this_$iv).buffer.get(index$iv) == null) {
                        continue;
                    }
                    Task it = element$iv;
                    if (!true) {
                        task3 = null;
                        break block7;
                    }
                    if (consumerIndex$FU.compareAndSet(this_$iv, tailLocal$iv, tailLocal$iv + 1)) break;
                }
                task3 = ((WorkQueue)this_$iv).buffer.getAndSet(index$iv, null);
            }
            Task task4 = task2 = task3;
            if (task4 == null) {
                return;
            }
            workQueue.addToGlobalQueue(globalQueue2, task4);
        }
    }

    private final Task pollExternal(Function1<? super Task, Boolean> predicate) {
        int index2;
        int $i$f$pollExternal = 0;
        while (true) {
            Task element;
            int tailLocal;
            if ((tailLocal = this.consumerIndex) - this.producerIndex == 0) {
                return null;
            }
            index2 = tailLocal & 0x7F;
            if ((Task)this.buffer.get(index2) == null) {
                continue;
            }
            if (!((Boolean)predicate.invoke((Object)element)).booleanValue()) {
                return null;
            }
            if (consumerIndex$FU.compareAndSet(this, tailLocal, tailLocal + 1)) break;
        }
        return this.buffer.getAndSet(index2, null);
    }

    static /* synthetic */ Task pollExternal$default(WorkQueue this_, Function1 predicate, int n, Object object) {
        int index2;
        if ((n & 1) != 0) {
            predicate = pollExternal.1.INSTANCE;
        }
        boolean $i$f$pollExternal = false;
        while (true) {
            Task element;
            int tailLocal;
            if ((tailLocal = this_.consumerIndex) - this_.producerIndex == 0) {
                return null;
            }
            index2 = tailLocal & 0x7F;
            if ((Task)this_.buffer.get(index2) == null) {
                continue;
            }
            if (!((Boolean)predicate.invoke((Object)element)).booleanValue()) {
                return null;
            }
            if (consumerIndex$FU.compareAndSet(this_, tailLocal, tailLocal + 1)) break;
        }
        return this_.buffer.getAndSet(index2, null);
    }

    private final boolean tryAddLast(Task task) {
        if (this.getBufferSize$kotlinx_coroutines_core() == 127) {
            return false;
        }
        int headLocal = this.producerIndex;
        int nextIndex = headLocal & 0x7F;
        if (this.buffer.get(nextIndex) != null) {
            return false;
        }
        this.buffer.lazySet(nextIndex, task);
        producerIndex$FU.incrementAndGet(this);
        return true;
    }
}

