/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.binding;

import com.intellij.openapi.util.Pair;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.codegen.binding.CalculatedClosure;
import org.jetbrains.kotlin.codegen.context.EnclosedValueDescriptor;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.org.objectweb.asm.Type;

public final class MutableClosure
implements CalculatedClosure {
    private final ClassDescriptor closureClass;
    private final ClassDescriptor enclosingClass;
    private final CallableDescriptor enclosingFunWithReceiverDescriptor;
    private boolean captureThis;
    private boolean captureEnclosingReceiver;
    private Map<DeclarationDescriptor, EnclosedValueDescriptor> captureVariables;
    private Map<DeclarationDescriptor, Integer> parameterOffsetInConstructor;
    private List<Pair<String, Type>> recordedFields;
    private KotlinType captureReceiverType;
    private boolean isSuspend;
    private boolean isSuspendLambda;

    MutableClosure(@NotNull ClassDescriptor classDescriptor2, @Nullable ClassDescriptor enclosingClass) {
        if (classDescriptor2 == null) {
            MutableClosure.$$$reportNull$$$0(0);
        }
        this.closureClass = classDescriptor2;
        this.enclosingClass = enclosingClass;
        this.enclosingFunWithReceiverDescriptor = MutableClosure.enclosingExtensionMemberForClass(classDescriptor2);
    }

    @Nullable
    private static CallableDescriptor enclosingExtensionMemberForClass(@NotNull ClassDescriptor classDescriptor2) {
        CallableMemberDescriptor member;
        DeclarationDescriptor classContainer;
        if (classDescriptor2 == null) {
            MutableClosure.$$$reportNull$$$0(1);
        }
        if ((classContainer = classDescriptor2.getContainingDeclaration()) instanceof CallableMemberDescriptor && (member = JvmCodegenUtil.getDirectMember((CallableMemberDescriptor)classContainer)).getExtensionReceiverParameter() != null) {
            return member;
        }
        return null;
    }

    @Override
    @NotNull
    public ClassDescriptor getClosureClass() {
        ClassDescriptor classDescriptor2 = this.closureClass;
        if (classDescriptor2 == null) {
            MutableClosure.$$$reportNull$$$0(2);
        }
        return classDescriptor2;
    }

    @Nullable
    public ClassDescriptor getEnclosingClass() {
        return this.enclosingClass;
    }

    @Override
    public ClassDescriptor getCapturedOuterClassDescriptor() {
        return this.captureThis ? this.enclosingClass : null;
    }

    public void setNeedsCaptureOuterClass() {
        this.captureThis = true;
    }

    @Override
    public KotlinType getCapturedReceiverFromOuterContext() {
        if (this.captureReceiverType != null) {
            return this.captureReceiverType;
        }
        if (this.captureEnclosingReceiver) {
            CallableDescriptor descriptor2 = this.getEnclosingCallableDescriptorWithReceiver();
            assert (descriptor2 != null) : "Receiver callable descriptor should exist";
            ReceiverParameterDescriptor parameter = descriptor2.getExtensionReceiverParameter();
            assert (parameter != null) : "Receiver parameter should exist in " + this.enclosingFunWithReceiverDescriptor;
            return parameter.getType();
        }
        return null;
    }

    @Override
    @NotNull
    public String getCapturedReceiverFieldName(BindingContext bindingContext, LanguageVersionSettings languageVersionSettings) {
        if (this.captureReceiverType != null) {
            return "receiver$0";
        }
        if (this.enclosingFunWithReceiverDescriptor != null) {
            if (!languageVersionSettings.supportsFeature(LanguageFeature.NewCapturedReceiverFieldNamingConvention)) {
                return "receiver$0";
            }
            String labeledThis = AsmUtil.getNameForCapturedReceiverField(this.enclosingFunWithReceiverDescriptor, bindingContext, languageVersionSettings);
            String string = AsmUtil.getCapturedFieldName(labeledThis);
            if (string == null) {
                MutableClosure.$$$reportNull$$$0(3);
            }
            return string;
        }
        throw new IllegalStateException("Closure does not capture an outer receiver");
    }

    public void setNeedsCaptureReceiverFromOuterContext() {
        if (this.enclosingFunWithReceiverDescriptor == null) {
            throw new IllegalStateException("Extension receiver parameter should exist");
        }
        this.captureEnclosingReceiver = true;
    }

    public void setCustomCapturedReceiverType(@NotNull KotlinType type2) {
        if (type2 == null) {
            MutableClosure.$$$reportNull$$$0(4);
        }
        this.captureReceiverType = type2;
    }

    @Override
    @NotNull
    public Map<DeclarationDescriptor, EnclosedValueDescriptor> getCaptureVariables() {
        Map<DeclarationDescriptor, EnclosedValueDescriptor> map2 = this.captureVariables != null ? this.captureVariables : Collections.emptyMap();
        if (map2 == null) {
            MutableClosure.$$$reportNull$$$0(5);
        }
        return map2;
    }

    @Override
    @NotNull
    public List<Pair<String, Type>> getRecordedFields() {
        List<Object> list2 = this.recordedFields != null ? this.recordedFields : Collections.emptyList();
        if (list2 == null) {
            MutableClosure.$$$reportNull$$$0(6);
        }
        return list2;
    }

    @Override
    public boolean isSuspend() {
        return this.isSuspend;
    }

    public void setSuspend(boolean suspend) {
        this.isSuspend = suspend;
    }

    @Override
    public boolean isSuspendLambda() {
        return this.isSuspendLambda;
    }

    public void setSuspendLambda() {
        this.isSuspendLambda = true;
    }

    private void recordField(String name2, Type type2) {
        if (this.recordedFields == null) {
            this.recordedFields = new LinkedList<Pair<String, Type>>();
        }
        this.recordedFields.add((Pair<String, Type>)new Pair((Object)name2, (Object)type2));
    }

    public void captureVariable(EnclosedValueDescriptor value) {
        this.recordField(value.getFieldName(), value.getType());
        if (this.captureVariables == null) {
            this.captureVariables = new LinkedHashMap<DeclarationDescriptor, EnclosedValueDescriptor>();
        }
        this.captureVariables.put(value.getDescriptor(), value);
    }

    public void setCapturedParameterOffsetInConstructor(DeclarationDescriptor descriptor2, int offset2) {
        if (this.parameterOffsetInConstructor == null) {
            this.parameterOffsetInConstructor = new LinkedHashMap<DeclarationDescriptor, Integer>();
        }
        this.parameterOffsetInConstructor.put(descriptor2, offset2);
    }

    public int getCapturedParameterOffsetInConstructor(DeclarationDescriptor descriptor2) {
        Integer result2 = this.parameterOffsetInConstructor != null ? this.parameterOffsetInConstructor.get(descriptor2) : null;
        return result2 != null ? result2 : -1;
    }

    @Override
    @Nullable
    public CallableDescriptor getEnclosingCallableDescriptorWithReceiver() {
        return this.enclosingFunWithReceiverDescriptor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classDescriptor";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/codegen/binding/MutableClosure";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/codegen/binding/MutableClosure";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getClosureClass";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCapturedReceiverFieldName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaptureVariables";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRecordedFields";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "enclosingExtensionMemberForClass";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setCustomCapturedReceiverType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

