/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.scopes.impl;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirResolvedImport;
import org.jetbrains.kotlin.fir.declarations.impl.FirResolvedImportImpl;
import org.jetbrains.kotlin.fir.resolve.FirSymbolProvider;
import org.jetbrains.kotlin.fir.resolve.calls.TowerScopeLevel;
import org.jetbrains.kotlin.fir.scopes.FirPosition;
import org.jetbrains.kotlin.fir.scopes.ProcessorAction;
import org.jetbrains.kotlin.fir.scopes.impl.FirAbstractImportingScope;
import org.jetbrains.kotlin.fir.symbols.ConeClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004JD\u0010\f\u001a\u00020\r\"\f\b\u0000\u0010\u000e*\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\u0010\u001a\u00020\u00072\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u00122\u0016\u0010\u0013\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f\u0012\u0004\u0012\u00020\r0\u0014H\u0016J,\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00182\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00160\u0014H\u0016R$\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0006X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/fir/scopes/impl/FirAbstractSimpleImportingScope;", "Lorg/jetbrains/kotlin/fir/scopes/impl/FirAbstractImportingScope;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "(Lorg/jetbrains/kotlin/fir/FirSession;)V", "simpleImports", "", "Lorg/jetbrains/kotlin/name/Name;", "", "Lorg/jetbrains/kotlin/fir/declarations/impl/FirResolvedImportImpl;", "getSimpleImports", "()Ljava/util/Map;", "processCallables", "Lorg/jetbrains/kotlin/fir/scopes/ProcessorAction;", "T", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "name", "token", "Lorg/jetbrains/kotlin/fir/resolve/calls/TowerScopeLevel$Token;", "processor", "Lkotlin/Function1;", "processClassifiersByName", "", "position", "Lorg/jetbrains/kotlin/fir/scopes/FirPosition;", "Lorg/jetbrains/kotlin/fir/symbols/ConeClassifierSymbol;", "resolve"})
public abstract class FirAbstractSimpleImportingScope
extends FirAbstractImportingScope {
    @NotNull
    protected abstract Map<Name, List<FirResolvedImportImpl>> getSimpleImports();

    @Override
    public boolean processClassifiersByName(@NotNull Name name2, @NotNull FirPosition position, @NotNull Function1<? super ConeClassifierSymbol, Boolean> processor2) {
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)((Object)position), (String)"position");
        Intrinsics.checkParameterIsNotNull(processor2, (String)"processor");
        List<FirResolvedImportImpl> list2 = this.getSimpleImports().get(name2);
        if (list2 == null) {
            return true;
        }
        List<FirResolvedImportImpl> imports = list2;
        if (imports.isEmpty()) {
            return true;
        }
        FirSymbolProvider provider = FirSymbolProvider.Companion.getInstance(this.getSession());
        for (FirResolvedImportImpl firResolvedImportImpl : imports) {
            FirClassLikeSymbol<?> symbol2;
            Name importedName;
            if (firResolvedImportImpl.getImportedName() == null) {
                continue;
            }
            ClassId classId = firResolvedImportImpl.getResolvedClassId();
            if (classId == null || (classId = classId.createNestedClassId(importedName)) == null) {
                classId = ClassId.topLevel(firResolvedImportImpl.getPackageFqName().child(importedName));
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)classId, (String)"import.resolvedClassId?.\u2026Name.child(importedName))");
            ClassId classId2 = classId;
            if (provider.getClassLikeSymbolByFqName(classId2) == null) {
                continue;
            }
            if (((Boolean)processor2.invoke(symbol2)).booleanValue()) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public <T extends FirCallableSymbol<?>> ProcessorAction processCallables(@NotNull Name name2, @NotNull TowerScopeLevel.Token<? extends T> token, @NotNull Function1<? super FirCallableSymbol<?>, ? extends ProcessorAction> processor2) {
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        Intrinsics.checkParameterIsNotNull(token, (String)"token");
        Intrinsics.checkParameterIsNotNull(processor2, (String)"processor");
        List<FirResolvedImportImpl> list2 = this.getSimpleImports().get(name2);
        if (list2 == null) {
            return ProcessorAction.NEXT;
        }
        List<FirResolvedImportImpl> imports = list2;
        if (imports.isEmpty()) {
            return ProcessorAction.NEXT;
        }
        for (FirResolvedImportImpl firResolvedImportImpl : imports) {
            FirResolvedImport firResolvedImport = firResolvedImportImpl;
            Name name3 = firResolvedImportImpl.getImportedName();
            if (name3 == null) {
                Intrinsics.throwNpe();
            }
            if (!this.processCallables(firResolvedImport, name3, token, processor2).stop()) continue;
            return ProcessorAction.STOP;
        }
        return ProcessorAction.NEXT;
    }

    public FirAbstractSimpleImportingScope(@NotNull FirSession session) {
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        super(session, true);
    }
}

