/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.rendering.api;

import com.android.resources.ResourceType;
import com.google.common.base.Splitter;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;

public enum AttributeFormat {
    BOOLEAN("boolean", EnumSet.of(ResourceType.BOOL)),
    COLOR("color", EnumSet.of(ResourceType.COLOR, ResourceType.DRAWABLE, ResourceType.MIPMAP)),
    DIMENSION("dimension", EnumSet.of(ResourceType.DIMEN)),
    ENUM("enum", Collections.emptySet()),
    FLAGS("flags", Collections.emptySet()),
    FLOAT("float", EnumSet.of(ResourceType.INTEGER)),
    FRACTION("fraction", EnumSet.of(ResourceType.FRACTION)),
    INTEGER("integer", EnumSet.of(ResourceType.INTEGER)),
    REFERENCE("reference", (Set<ResourceType>)ResourceType.REFERENCEABLE_TYPES),
    STRING("string", EnumSet.of(ResourceType.STRING));

    private static final Splitter PIPE_SPLITTER;
    private final String name;
    private final Set<ResourceType> matchingTypes;

    private AttributeFormat(String name, Set<ResourceType> matchingTypes) {
        this.name = name;
        this.matchingTypes = matchingTypes;
    }

    private AttributeFormat(String name, EnumSet<ResourceType> matchingTypes) {
        this(name, Collections.unmodifiableSet(matchingTypes));
    }

    public String getName() {
        return this.name;
    }

    public Set<ResourceType> getMatchingTypes() {
        return this.matchingTypes;
    }

    public static AttributeFormat fromXmlName(String name) {
        switch (name) {
            case "boolean": {
                return BOOLEAN;
            }
            case "color": {
                return COLOR;
            }
            case "dimension": {
                return DIMENSION;
            }
            case "enum": {
                return ENUM;
            }
            case "flags": {
                return FLAGS;
            }
            case "float": {
                return FLOAT;
            }
            case "fraction": {
                return FRACTION;
            }
            case "integer": {
                return INTEGER;
            }
            case "reference": {
                return REFERENCE;
            }
            case "string": {
                return STRING;
            }
        }
        return null;
    }

    public static Set<AttributeFormat> parse(String formatString) {
        EnumSet<AttributeFormat> result = EnumSet.noneOf(AttributeFormat.class);
        for (String formatName : PIPE_SPLITTER.split((CharSequence)formatString)) {
            AttributeFormat format = AttributeFormat.fromXmlName(formatName);
            if (format == null) continue;
            result.add(format);
        }
        return result;
    }

    static {
        PIPE_SPLITTER = Splitter.on((char)'|').trimResults();
    }
}

