/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.ide.common.blame.SourcePosition;
import com.android.ide.common.resources.ResourceItem;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.DefaultPosition;
import com.android.tools.lint.detector.api.Position;
import com.android.utils.CharSequences;
import com.google.common.annotations.Beta;
import java.io.File;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0017\u0018\u0000 32\u00020\u0001:\u0006345678B#\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0007J!\u0010 \u001a\u0004\u0018\u0001H(\"\u0004\b\u0000\u0010(2\f\u0010)\u001a\b\u0012\u0004\u0012\u0002H(0*\u00a2\u0006\u0002\u0010+J\u0006\u0010,\u001a\u00020\u001eJ\u0006\u0010-\u001a\u00020\u001eJ\u0012\u0010.\u001a\u00020\u00002\b\u0010\b\u001a\u0004\u0018\u00010\u0001H\u0016J\u0018\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010/\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010!\u001a\u00020\u00002\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001J\b\u00100\u001a\u00020\u0012H\u0016J\"\u00101\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u00122\b\b\u0002\u0010\u001d\u001a\u00020\u001eH\u0007J\u000e\u00102\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\u0001R\u001c\u0010\b\u001a\u0004\u0018\u00010\u0001X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R(\u0010\u0013\u001a\u0004\u0018\u00010\u00122\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0000X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001f\u001a\u0004\u0018\u00010\u0001X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\n\"\u0004\b!\u0010\fR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u000eR\u001a\u0010#\u001a\u00020\u001eX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'\u00a8\u00069"}, d2={"Lcom/android/tools/lint/detector/api/Location;", "", "file", "Ljava/io/File;", "start", "Lcom/android/tools/lint/detector/api/Position;", "end", "(Ljava/io/File;Lcom/android/tools/lint/detector/api/Position;Lcom/android/tools/lint/detector/api/Position;)V", "clientData", "getClientData", "()Ljava/lang/Object;", "setClientData", "(Ljava/lang/Object;)V", "getEnd", "()Lcom/android/tools/lint/detector/api/Position;", "getFile", "()Ljava/io/File;", "value", "", "message", "getMessage", "()Ljava/lang/String;", "setMessage", "(Ljava/lang/String;)V", "secondary", "getSecondary", "()Lcom/android/tools/lint/detector/api/Location;", "setSecondary", "(Lcom/android/tools/lint/detector/api/Location;)V", "selfExplanatory", "", "source", "getSource", "setSource", "getStart", "visible", "getVisible", "()Z", "setVisible", "(Z)V", "T", "clz", "Ljava/lang/Class;", "(Ljava/lang/Class;)Ljava/lang/Object;", "isSelfExplanatory", "isSingleLine", "setData", "setSelfExplanatory", "toString", "withSecondary", "withSource", "Companion", "DefaultLocationHandle", "Handle", "ResourceItemHandle", "SearchDirection", "SearchHints", "lint-api"})
@Beta
public class Location {
    @Nullable
    private String message;
    @Nullable
    private Object clientData;
    private boolean visible;
    private boolean selfExplanatory;
    @Nullable
    private Location secondary;
    @Nullable
    private Object source;
    @NotNull
    private final File file;
    @Nullable
    private final Position start;
    @Nullable
    private final Position end;
    private static final String SUPER_KEYWORD = "super";
    @JvmField
    @NotNull
    public static final Location NONE;
    public static final Companion Companion;

    @Nullable
    public final String getMessage() {
        return this.message;
    }

    public final void setMessage(@Nullable String value) {
        this.message = value;
        this.setSelfExplanatory(false);
    }

    @Nullable
    public final Object getClientData() {
        return this.clientData;
    }

    public final void setClientData(@Nullable Object object) {
        this.clientData = object;
    }

    public boolean getVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    @Nullable
    public Location getSecondary() {
        return this.secondary;
    }

    public void setSecondary(@Nullable Location location) {
        this.secondary = location;
    }

    @Nullable
    public final Object getSource() {
        return this.source;
    }

    public final void setSource(@Nullable Object object) {
        this.source = object;
    }

    @JvmOverloads
    @NotNull
    public final Location withSecondary(@NotNull Location secondary, @NotNull String message, boolean selfExplanatory) {
        Intrinsics.checkParameterIsNotNull((Object)secondary, (String)"secondary");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        this.setSecondary(secondary);
        secondary.setMessage(message);
        secondary.selfExplanatory = selfExplanatory;
        return this;
    }

    public static /* synthetic */ Location withSecondary$default(Location location, Location location2, String string, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: withSecondary");
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        return location.withSecondary(location2, string, bl);
    }

    @JvmOverloads
    @NotNull
    public final Location withSecondary(@NotNull Location secondary, @NotNull String message) {
        return Location.withSecondary$default(this, secondary, message, false, 4, null);
    }

    @NotNull
    public final Location withSource(@NotNull Object source) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        this.source = source;
        return this;
    }

    @Nullable
    public final <T> T getSource(@NotNull Class<T> clz) {
        Intrinsics.checkParameterIsNotNull(clz, (String)"clz");
        Object object = this.source;
        if (object == null) {
            return null;
        }
        Object source = object;
        if (clz.isAssignableFrom(source.getClass())) {
            return (T)source;
        }
        return null;
    }

    @NotNull
    public final Location setSource(@Nullable Object source) {
        this.source = source;
        return this;
    }

    @NotNull
    public Location setMessage(@NotNull String message, boolean selfExplanatory) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        this.setMessage(message);
        this.setSelfExplanatory(selfExplanatory);
        return this;
    }

    public final boolean isSelfExplanatory() {
        return this.selfExplanatory;
    }

    @NotNull
    public Location setSelfExplanatory(boolean selfExplanatory) {
        this.selfExplanatory = selfExplanatory;
        return this;
    }

    @NotNull
    public Location setData(@Nullable Object clientData) {
        this.clientData = clientData;
        return this;
    }

    public final boolean isSingleLine() {
        return this.start == null || this.end == null || this.start.sameLine(this.end);
    }

    @NotNull
    public String toString() {
        return "Location [file=" + this.file + ", start=" + this.start + ", end=" + this.end + ", message=" + this.message + ']';
    }

    @NotNull
    public final File getFile() {
        return this.file;
    }

    @Nullable
    public final Position getStart() {
        return this.start;
    }

    @Nullable
    public final Position getEnd() {
        return this.end;
    }

    protected Location(@NotNull File file, @Nullable Position start, @Nullable Position end) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        this.file = file;
        this.start = start;
        this.end = end;
        this.visible = true;
        this.selfExplanatory = true;
    }

    static {
        Companion = new Companion(null);
        NONE = new Location(new File("NONE"), null, null){
            private boolean visible;
            @Nullable
            private Location secondary;

            @NotNull
            public Location setMessage(@NotNull String message, boolean selfExplanatory) {
                Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                return this;
            }

            @NotNull
            public Location setData(@Nullable Object clientData) {
                return this;
            }

            @NotNull
            public Location setSelfExplanatory(boolean selfExplanatory) {
                return this;
            }

            public boolean getVisible() {
                return this.visible;
            }

            public void setVisible(boolean value) {
            }

            @Nullable
            public Location getSecondary() {
                return this.secondary;
            }

            public void setSecondary(@Nullable Location value) {
            }
        };
    }

    @JvmStatic
    @NotNull
    public static final Location create(@NotNull File file) {
        return Companion.create(file);
    }

    @JvmStatic
    @NotNull
    public static final Location create(@NotNull File file, @NotNull SourcePosition position) {
        return Companion.create(file, position);
    }

    @JvmStatic
    @NotNull
    public static final Location create(@NotNull File file, @NotNull Position start, @Nullable Position end) {
        return Companion.create(file, start, end);
    }

    @JvmStatic
    @NotNull
    public static final Location create(@NotNull File file, @Nullable CharSequence contents, int startOffset, int endOffset) {
        return Companion.create(file, contents, startOffset, endOffset);
    }

    @JvmStatic
    @NotNull
    public static final Location create(@NotNull File file, @NotNull String contents, int line) {
        return Companion.create(file, contents, line);
    }

    @JvmStatic
    @NotNull
    public static final Location create(@NotNull File file, @NotNull CharSequence contents, int line, @Nullable String patternStart, @Nullable String patternEnd, @Nullable SearchHints hints) {
        return Companion.create(file, contents, line, patternStart, patternEnd, hints);
    }

    @JvmStatic
    private static final int findPreviousMatch(CharSequence contents, int offset, String pattern, SearchHints hints) {
        return Location.Companion.findPreviousMatch(contents, offset, pattern, hints);
    }

    @JvmStatic
    private static final int findNextMatch(CharSequence contents, int offset, String pattern, SearchHints hints) {
        return Location.Companion.findNextMatch(contents, offset, pattern, hints);
    }

    @JvmStatic
    private static final boolean isMatch(CharSequence contents, int offset, String pattern, SearchHints hints) {
        return Location.Companion.isMatch(contents, offset, pattern, hints);
    }

    @JvmStatic
    private static final int adjustLine(CharSequence doc, int line, int offset, int newOffset) {
        return Location.Companion.adjustLine(doc, line, offset, newOffset);
    }

    @JvmStatic
    private static final int countLines(CharSequence doc, int start, int end) {
        return Location.Companion.countLines(doc, start, end);
    }

    @JvmStatic
    @NotNull
    public static final Location reverse(@NotNull Location location) {
        return Companion.reverse(location);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0007\u001a\u00020\bH&R\u001a\u0010\u0002\u001a\u0004\u0018\u00010\u0001X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0003\u0010\u0004\"\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lcom/android/tools/lint/detector/api/Location$Handle;", "", "clientData", "getClientData", "()Ljava/lang/Object;", "setClientData", "(Ljava/lang/Object;)V", "resolve", "Lcom/android/tools/lint/detector/api/Location;", "lint-api"})
    public static interface Handle {
        @NotNull
        public Location resolve();

        @Nullable
        public Object getClientData();

        public void setClientData(@Nullable Object var1);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/lint/detector/api/Location$DefaultLocationHandle;", "Lcom/android/tools/lint/detector/api/Location$Handle;", "context", "Lcom/android/tools/lint/detector/api/Context;", "startOffset", "", "endOffset", "(Lcom/android/tools/lint/detector/api/Context;II)V", "clientData", "", "getClientData", "()Ljava/lang/Object;", "setClientData", "(Ljava/lang/Object;)V", "contents", "", "file", "Ljava/io/File;", "resolve", "Lcom/android/tools/lint/detector/api/Location;", "lint-api"})
    public static final class DefaultLocationHandle
    implements Handle {
        private final File file;
        private final CharSequence contents;
        @Nullable
        private Object clientData;
        private final int startOffset;
        private final int endOffset;

        @Override
        @Nullable
        public Object getClientData() {
            return this.clientData;
        }

        @Override
        public void setClientData(@Nullable Object object) {
            this.clientData = object;
        }

        @Override
        @NotNull
        public Location resolve() {
            return Companion.create(this.file, this.contents, this.startOffset, this.endOffset);
        }

        public DefaultLocationHandle(@NotNull Context context2, int startOffset, int endOffset) {
            Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.file = context2.file;
            CharSequence charSequence = context2.getContents();
            if (charSequence == null) {
                charSequence = "";
            }
            this.contents = charSequence;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000b\u001a\u00020\fH\u0016R(\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u00068V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/android/tools/lint/detector/api/Location$ResourceItemHandle;", "Lcom/android/tools/lint/detector/api/Location$Handle;", "item", "Lcom/android/ide/common/resources/ResourceItem;", "(Lcom/android/ide/common/resources/ResourceItem;)V", "clientData", "", "getClientData", "()Ljava/lang/Object;", "setClientData", "(Ljava/lang/Object;)V", "resolve", "Lcom/android/tools/lint/detector/api/Location;", "lint-api"})
    public static final class ResourceItemHandle
    implements Handle {
        private final ResourceItem item;

        @Override
        @NotNull
        public Location resolve() {
            Object object = this.item.getSource();
            if (object == null || (object = object.toFile()) == null) {
                ResourceItem resourceItem = this.item;
                boolean bl = false;
                throw (Throwable)new IllegalStateException(resourceItem.toString());
            }
            Object source = object;
            return Companion.create((File)source);
        }

        @Override
        @Nullable
        public Object getClientData() {
            return null;
        }

        @Override
        public void setClientData(@Nullable Object clientData) {
        }

        public ResourceItemHandle(@NotNull ResourceItem item) {
            Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
            this.item = item;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/android/tools/lint/detector/api/Location$SearchDirection;", "", "(Ljava/lang/String;I)V", "FORWARD", "BACKWARD", "EOL_BACKWARD", "NEAREST", "EOL_NEAREST", "lint-api"})
    public static final class SearchDirection
    extends Enum<SearchDirection> {
        public static final /* enum */ SearchDirection FORWARD;
        public static final /* enum */ SearchDirection BACKWARD;
        public static final /* enum */ SearchDirection EOL_BACKWARD;
        public static final /* enum */ SearchDirection NEAREST;
        public static final /* enum */ SearchDirection EOL_NEAREST;
        private static final /* synthetic */ SearchDirection[] $VALUES;

        static {
            SearchDirection[] searchDirectionArray = new SearchDirection[5];
            SearchDirection[] searchDirectionArray2 = searchDirectionArray;
            searchDirectionArray[0] = FORWARD = new SearchDirection();
            searchDirectionArray[1] = BACKWARD = new SearchDirection();
            searchDirectionArray[2] = EOL_BACKWARD = new SearchDirection();
            searchDirectionArray[3] = NEAREST = new SearchDirection();
            searchDirectionArray[4] = EOL_NEAREST = new SearchDirection();
            $VALUES = searchDirectionArray;
        }

        public static SearchDirection[] values() {
            return (SearchDirection[])$VALUES.clone();
        }

        public static SearchDirection valueOf(String string) {
            return Enum.valueOf(SearchDirection.class, string);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\t\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\r\u001a\u00020\u0000J\u0006\u0010\u000e\u001a\u00020\u0000J\u0006\u0010\u000f\u001a\u00020\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001e\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u001e\u0010\f\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\n\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/lint/detector/api/Location$SearchHints;", "", "direction", "Lcom/android/tools/lint/detector/api/Location$SearchDirection;", "(Lcom/android/tools/lint/detector/api/Location$SearchDirection;)V", "getDirection", "()Lcom/android/tools/lint/detector/api/Location$SearchDirection;", "<set-?>", "", "isConstructor", "()Z", "isJavaSymbol", "isWholeWord", "matchConstructor", "matchJavaSymbol", "matchWholeWord", "Companion", "lint-api"})
    public static final class SearchHints {
        private boolean isWholeWord;
        private boolean isJavaSymbol;
        private boolean isConstructor;
        @NotNull
        private final SearchDirection direction;
        public static final Companion Companion = new Companion(null);

        public final boolean isWholeWord() {
            return this.isWholeWord;
        }

        public final boolean isJavaSymbol() {
            return this.isJavaSymbol;
        }

        public final boolean isConstructor() {
            return this.isConstructor;
        }

        @NotNull
        public final SearchHints matchWholeWord() {
            this.isWholeWord = true;
            return this;
        }

        @NotNull
        public final SearchHints matchJavaSymbol() {
            this.isJavaSymbol = true;
            this.isWholeWord = true;
            return this;
        }

        @NotNull
        public final SearchHints matchConstructor() {
            this.isConstructor = true;
            this.isWholeWord = true;
            this.isJavaSymbol = true;
            return this;
        }

        @NotNull
        public final SearchDirection getDirection() {
            return this.direction;
        }

        private SearchHints(SearchDirection direction) {
            this.direction = direction;
        }

        public /* synthetic */ SearchHints(SearchDirection direction, DefaultConstructorMarker $constructor_marker) {
            this(direction);
        }

        @JvmStatic
        @NotNull
        public static final SearchHints create(@NotNull SearchDirection direction) {
            return Companion.create(direction);
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/lint/detector/api/Location$SearchHints$Companion;", "", "()V", "create", "Lcom/android/tools/lint/detector/api/Location$SearchHints;", "direction", "Lcom/android/tools/lint/detector/api/Location$SearchDirection;", "lint-api"})
        public static final class Companion {
            @JvmStatic
            @NotNull
            public final SearchHints create(@NotNull SearchDirection direction) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)direction), (String)"direction");
                return new SearchHints(direction, null);
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\r\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\bH\u0003J \u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\bH\u0003J\u0010\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u0018\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\"\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u00162\b\u0010\u0010\u001a\u0004\u0018\u00010\u0016H\u0007J>\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00062\b\u0010\u0019\u001a\u0004\u0018\u00010\u00062\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0007J*\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0017\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\bH\u0007J \u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\bH\u0007J*\u0010\u001e\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\u00062\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0003J*\u0010 \u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\u00062\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0003J*\u0010!\u001a\u00020\"2\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\u00062\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0003J\u0010\u0010#\u001a\u00020\u00042\u0006\u0010$\u001a\u00020\u0004H\u0007R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/android/tools/lint/detector/api/Location$Companion;", "", "()V", "NONE", "Lcom/android/tools/lint/detector/api/Location;", "SUPER_KEYWORD", "", "adjustLine", "", "doc", "", "line", "offset", "newOffset", "countLines", "start", "end", "create", "file", "Ljava/io/File;", "position", "Lcom/android/ide/common/blame/SourcePosition;", "Lcom/android/tools/lint/detector/api/Position;", "contents", "patternStart", "patternEnd", "hints", "Lcom/android/tools/lint/detector/api/Location$SearchHints;", "startOffset", "endOffset", "findNextMatch", "pattern", "findPreviousMatch", "isMatch", "", "reverse", "location", "lint-api"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final Location create(@NotNull File file) {
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            return new Location(file, null, null);
        }

        @JvmStatic
        @NotNull
        public final Location create(@NotNull File file, @NotNull SourcePosition position) {
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            Intrinsics.checkParameterIsNotNull((Object)position, (String)"position");
            if (Intrinsics.areEqual((Object)position, (Object)SourcePosition.UNKNOWN)) {
                return new Location(file, null, null);
            }
            return new Location(file, new DefaultPosition(position.getStartLine(), position.getStartColumn(), position.getStartOffset()), new DefaultPosition(position.getEndLine(), position.getEndColumn(), position.getEndOffset()));
        }

        @JvmStatic
        @NotNull
        public final Location create(@NotNull File file, @NotNull Position start, @Nullable Position end) {
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            Intrinsics.checkParameterIsNotNull((Object)start, (String)"start");
            return new Location(file, start, end);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final Location create(@NotNull File file, @Nullable CharSequence contents, int startOffset, int endOffset) {
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            if (startOffset < 0 || endOffset < startOffset) {
                throw (Throwable)new IllegalArgumentException("Invalid offsets");
            }
            if (contents == null) {
                return new Location(file, new DefaultPosition(-1, -1, startOffset), new DefaultPosition(-1, -1, endOffset));
            }
            int size = contents.length();
            int startOffset2 = startOffset;
            int endOffset2 = endOffset;
            endOffset2 = Math.min(endOffset2, size);
            startOffset2 = Math.min(startOffset2, endOffset2);
            Position start = null;
            int line = 0;
            boolean lineOffset = false;
            char prev = (char)0;
            int n = 0;
            int n2 = size;
            if (n <= n2) {
                while (true) {
                    void offset;
                    if (offset == startOffset2) {
                        start = new DefaultPosition(line, (int)(offset - lineOffset), (int)offset);
                    }
                    if (offset == endOffset2) {
                        DefaultPosition end = new DefaultPosition(line, (int)(offset - lineOffset), (int)offset);
                        return new Location(file, start, end);
                    }
                    char c = contents.charAt((int)offset);
                    if (c == '\n') {
                        lineOffset = offset + true;
                        if (prev != '\r') {
                            ++line;
                        }
                    } else if (c == '\r') {
                        ++line;
                        lineOffset = offset + true;
                    }
                    prev = c;
                    if (offset == n2) break;
                    ++offset;
                }
            }
            return this.create(file);
        }

        @JvmStatic
        @NotNull
        public final Location create(@NotNull File file, @NotNull String contents, int line) {
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            Intrinsics.checkParameterIsNotNull((Object)contents, (String)"contents");
            return this.create(file, contents, line, null, null, null);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final Location create(@NotNull File file, @NotNull CharSequence contents, int line, @Nullable String patternStart, @Nullable String patternEnd, @Nullable SearchHints hints) {
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            Intrinsics.checkParameterIsNotNull((Object)contents, (String)"contents");
            int targetLine = line;
            String targetPattern = patternStart;
            int currentLine = 0;
            int offset = 0;
            while (currentLine < targetLine) {
                if ((offset = CharSequences.indexOf((CharSequence)contents, (char)'\n', (int)offset)) == -1) {
                    return this.create(file);
                }
                ++currentLine;
                ++offset;
            }
            if (targetLine == currentLine) {
                if (targetPattern != null) {
                    int lineEnd;
                    SearchDirection direction = SearchDirection.NEAREST;
                    if (hints != null) {
                        direction = hints.getDirection();
                    }
                    int index = 0;
                    if (direction == SearchDirection.BACKWARD) {
                        index = this.findPreviousMatch(contents, offset, targetPattern, hints);
                        targetLine = this.adjustLine(contents, targetLine, offset, index);
                    } else if (direction == SearchDirection.EOL_BACKWARD) {
                        lineEnd = CharSequences.indexOf((CharSequence)contents, (char)'\n', (int)offset);
                        if (lineEnd == -1) {
                            lineEnd = contents.length();
                        }
                        index = this.findPreviousMatch(contents, lineEnd, targetPattern, hints);
                        targetLine = this.adjustLine(contents, targetLine, offset, index);
                    } else if (direction == SearchDirection.FORWARD) {
                        index = this.findNextMatch(contents, offset, targetPattern, hints);
                        targetLine = this.adjustLine(contents, targetLine, offset, index);
                    } else {
                        lineEnd = direction == SearchDirection.NEAREST || direction == SearchDirection.EOL_NEAREST ? 1 : 0;
                        boolean bl = false;
                        boolean bl2 = false;
                        if (_Assertions.ENABLED && lineEnd == 0) {
                            boolean bl3 = false;
                            String string = "Assertion failed";
                            throw (Throwable)((Object)new AssertionError((Object)string));
                        }
                        lineEnd = CharSequences.indexOf((CharSequence)contents, (char)'\n', (int)offset);
                        if (lineEnd == -1) {
                            lineEnd = contents.length();
                        }
                        offset = lineEnd;
                        int before = this.findPreviousMatch(contents, offset, targetPattern, hints);
                        int after = this.findNextMatch(contents, offset, targetPattern, hints);
                        if (before == -1) {
                            index = after;
                            targetLine = this.adjustLine(contents, targetLine, offset, index);
                        } else if (after == -1) {
                            index = before;
                            targetLine = this.adjustLine(contents, targetLine, offset, index);
                        } else {
                            int newLinesBefore = 0;
                            int n = before;
                            int n2 = offset;
                            while (n < n2) {
                                void i;
                                if (contents.charAt((int)i) == '\n') {
                                    ++newLinesBefore;
                                }
                                ++i;
                            }
                            int newLinesAfter = 0;
                            n2 = offset;
                            int n3 = after;
                            while (n2 < n3) {
                                void i;
                                if (contents.charAt((int)i) == '\n') {
                                    ++newLinesAfter;
                                }
                                ++i;
                            }
                            if (newLinesBefore < newLinesAfter || newLinesBefore == newLinesAfter && offset - before < after - offset) {
                                index = before;
                                targetLine = this.adjustLine(contents, targetLine, offset, index);
                            } else {
                                index = after;
                                targetLine = this.adjustLine(contents, targetLine, offset, index);
                            }
                        }
                    }
                    if (index != -1) {
                        int lineStart = StringsKt.lastIndexOf$default((CharSequence)contents, (char)'\n', (int)index, (boolean)false, (int)4, null);
                        lineStart = lineStart == -1 ? 0 : ++lineStart;
                        int column = index - lineStart;
                        if (patternEnd != null) {
                            int end = CharSequences.indexOf((CharSequence)contents, (CharSequence)patternEnd, (int)(offset + targetPattern.length()));
                            if (end != -1) {
                                return new Location(file, new DefaultPosition(targetLine, column, index), new DefaultPosition(targetLine, -1, end + patternEnd.length()));
                            }
                        } else if (hints != null && (hints.isJavaSymbol() || hints.isWholeWord())) {
                            if (hints.isConstructor() && CharSequences.startsWith((CharSequence)contents, (CharSequence)Location.SUPER_KEYWORD, (int)index)) {
                                targetPattern = Location.SUPER_KEYWORD;
                            }
                            return new Location(file, new DefaultPosition(targetLine, column, index), new DefaultPosition(targetLine, column + targetPattern.length(), index + targetPattern.length()));
                        }
                        return new Location(file, new DefaultPosition(targetLine, column, index), new DefaultPosition(targetLine, column, index + targetPattern.length()));
                    }
                }
                DefaultPosition position = new DefaultPosition(targetLine, -1, offset);
                return new Location(file, position, position);
            }
            return this.create(file);
        }

        @JvmStatic
        private final int findPreviousMatch(CharSequence contents, int offset, String pattern, SearchHints hints) {
            int currentOffset = offset;
            int loopDecrement = Math.max(1, pattern.length());
            int index;
            while ((index = CharSequences.lastIndexOf((CharSequence)contents, (String)pattern, (int)currentOffset)) != -1) {
                if (this.isMatch(contents, index, pattern, hints)) {
                    return index;
                }
                currentOffset = index - loopDecrement;
            }
            return -1;
        }

        @JvmStatic
        private final int findNextMatch(CharSequence contents, int offset, String pattern, SearchHints hints) {
            int currentOffset = offset;
            int constructorIndex = -1;
            if (hints != null && hints.isConstructor()) {
                boolean bl = hints.isWholeWord();
                boolean bl2 = false;
                boolean bl3 = false;
                if (_Assertions.ENABLED && !bl) {
                    boolean bl4 = false;
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                int index = CharSequences.indexOf((CharSequence)contents, (CharSequence)Location.SUPER_KEYWORD, (int)currentOffset);
                if (index != -1 && this.isMatch(contents, index, Location.SUPER_KEYWORD, hints)) {
                    constructorIndex = index;
                }
            }
            int loopIncrement = Math.max(1, pattern.length());
            int index;
            while ((index = CharSequences.indexOf((CharSequence)contents, (CharSequence)pattern, (int)currentOffset)) != -1 && index != contents.length()) {
                if (this.isMatch(contents, index, pattern, hints)) {
                    if (constructorIndex != -1) {
                        return Math.min(constructorIndex, index);
                    }
                    return index;
                }
                currentOffset = index + loopIncrement;
            }
            return constructorIndex;
        }

        @JvmStatic
        private final boolean isMatch(CharSequence contents, int offset, String pattern, SearchHints hints) {
            if (!CharSequences.startsWith((CharSequence)contents, (CharSequence)pattern, (int)offset)) {
                return false;
            }
            if (hints != null) {
                char nextChar;
                char prevChar = offset > 0 ? (char)contents.charAt(offset - 1) : (char)'\n';
                int lastIndex = offset + pattern.length() - 1;
                char c = nextChar = lastIndex < contents.length() - 1 ? (char)contents.charAt(lastIndex + 1) : (char)'\n';
                if (hints.isWholeWord() && (Character.isLetter(prevChar) || Character.isLetter(nextChar))) {
                    return false;
                }
                if (hints.isJavaSymbol()) {
                    if (Character.isJavaIdentifierPart(prevChar) || Character.isJavaIdentifierPart(nextChar)) {
                        return false;
                    }
                    if (prevChar == '\"') {
                        return false;
                    }
                }
                if (hints.isConstructor() && Intrinsics.areEqual((Object)Location.SUPER_KEYWORD, (Object)pattern)) {
                    char c2;
                    for (int index = lastIndex + 1; index < contents.length() - 1 && (c2 = contents.charAt(index)) != '('; ++index) {
                        if (Character.isWhitespace(c2)) continue;
                        return false;
                    }
                }
            }
            return true;
        }

        @JvmStatic
        private final int adjustLine(CharSequence doc, int line, int offset, int newOffset) {
            if (newOffset == -1) {
                return line;
            }
            return newOffset < offset ? line - this.countLines(doc, newOffset, offset) : line + this.countLines(doc, offset, newOffset);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        private final int countLines(CharSequence doc, int start, int end) {
            int lines = 0;
            int n = start;
            int n2 = end;
            while (n < n2) {
                void offset;
                char c = doc.charAt((int)offset);
                if (c == '\n') {
                    ++lines;
                }
                ++offset;
            }
            return lines;
        }

        @JvmStatic
        @NotNull
        public final Location reverse(@NotNull Location location) {
            Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
            Location currentLocation = location;
            Location next = currentLocation.getSecondary();
            currentLocation.setSecondary(null);
            while (next != null) {
                Location nextNext = next.getSecondary();
                next.setSecondary(currentLocation);
                currentLocation = next;
                next = nextNext;
            }
            return currentLocation;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

