/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.SdkConstants;
import com.android.tools.lint.checks.AbstractAnnotationDetector;
import com.android.tools.lint.checks.AnnotationDetector;
import com.android.tools.lint.checks.FloatRangeConstraint;
import com.android.tools.lint.checks.IntRangeConstraint;
import com.android.tools.lint.checks.RangeConstraint;
import com.android.tools.lint.checks.SizeConstraint;
import com.android.tools.lint.checks.TypedefDetector;
import com.android.tools.lint.detector.api.AnnotationUsageType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.UResolvable;
import org.jetbrains.uast.util.UastExpressionUtils;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u001f2\u00020\u00012\u00020\u0002:\u0001\u001fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J.\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u0005H\u0002J \u0010\u0011\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J|\u0010\u0012\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00062\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\f0\u00052\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\f0\u00052\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\f0\u00052\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\f0\u0005H\u0016\u00a8\u0006 "}, d2={"Lcom/android/tools/lint/checks/RangeDetector;", "Lcom/android/tools/lint/checks/AbstractAnnotationDetector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "applicableAnnotations", "", "", "checkFloatRange", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "annotation", "Lorg/jetbrains/uast/UAnnotation;", "argument", "Lorg/jetbrains/uast/UElement;", "checkIntRange", "allAnnotations", "checkSize", "visitAnnotationUsage", "usage", "type", "Lcom/android/tools/lint/detector/api/AnnotationUsageType;", "qualifiedName", "method", "Lcom/intellij/psi/PsiMethod;", "referenced", "Lcom/intellij/psi/PsiElement;", "annotations", "allMemberAnnotations", "allClassAnnotations", "allPackageAnnotations", "Companion", "lint-checks"})
public final class RangeDetector
extends AbstractAnnotationDetector
implements SourceCodeScanner {
    private static final Implementation IMPLEMENTATION;
    @JvmField
    @NotNull
    public static final Issue RANGE;
    public static final Companion Companion;

    @NotNull
    public List<String> applicableAnnotations() {
        return CollectionsKt.listOf((Object[])new String[]{AnnotationDetector.INT_RANGE_ANNOTATION.oldName(), AnnotationDetector.INT_RANGE_ANNOTATION.newName(), AnnotationDetector.FLOAT_RANGE_ANNOTATION.oldName(), AnnotationDetector.FLOAT_RANGE_ANNOTATION.newName(), AnnotationDetector.SIZE_ANNOTATION.oldName(), AnnotationDetector.SIZE_ANNOTATION.newName(), SdkConstants.INT_DEF_ANNOTATION.oldName(), SdkConstants.INT_DEF_ANNOTATION.newName(), SdkConstants.LONG_DEF_ANNOTATION.oldName(), SdkConstants.LONG_DEF_ANNOTATION.newName()});
    }

    public void visitAnnotationUsage(@NotNull JavaContext context, @NotNull UElement usage, @NotNull AnnotationUsageType type, @NotNull UAnnotation annotation, @NotNull String qualifiedName, @Nullable PsiMethod method, @Nullable PsiElement referenced, @NotNull List<? extends UAnnotation> annotations, @NotNull List<? extends UAnnotation> allMemberAnnotations, @NotNull List<? extends UAnnotation> allClassAnnotations, @NotNull List<? extends UAnnotation> allPackageAnnotations) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)usage, (String)"usage");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)annotation, (String)"annotation");
        Intrinsics.checkParameterIsNotNull((Object)qualifiedName, (String)"qualifiedName");
        Intrinsics.checkParameterIsNotNull(annotations, (String)"annotations");
        Intrinsics.checkParameterIsNotNull(allMemberAnnotations, (String)"allMemberAnnotations");
        Intrinsics.checkParameterIsNotNull(allClassAnnotations, (String)"allClassAnnotations");
        Intrinsics.checkParameterIsNotNull(allPackageAnnotations, (String)"allPackageAnnotations");
        String string = qualifiedName;
        if (Intrinsics.areEqual((Object)string, (Object)AnnotationDetector.INT_RANGE_ANNOTATION.oldName()) || Intrinsics.areEqual((Object)string, (Object)AnnotationDetector.INT_RANGE_ANNOTATION.newName())) {
            this.checkIntRange(context, annotation, usage, annotations);
        } else if (Intrinsics.areEqual((Object)string, (Object)AnnotationDetector.FLOAT_RANGE_ANNOTATION.oldName()) || Intrinsics.areEqual((Object)string, (Object)AnnotationDetector.FLOAT_RANGE_ANNOTATION.newName())) {
            this.checkFloatRange(context, annotation, usage);
        } else if (Intrinsics.areEqual((Object)string, (Object)AnnotationDetector.SIZE_ANNOTATION.oldName()) || Intrinsics.areEqual((Object)string, (Object)AnnotationDetector.SIZE_ANNOTATION.newName())) {
            this.checkSize(context, annotation, usage);
        } else if (Intrinsics.areEqual((Object)string, (Object)SdkConstants.INT_DEF_ANNOTATION.oldName()) || Intrinsics.areEqual((Object)string, (Object)SdkConstants.INT_DEF_ANNOTATION.newName()) || Intrinsics.areEqual((Object)string, (Object)SdkConstants.LONG_DEF_ANNOTATION.oldName()) || Intrinsics.areEqual((Object)string, (Object)SdkConstants.LONG_DEF_ANNOTATION.newName())) {
            // empty if block
        }
    }

    private final void checkIntRange(JavaContext context, UAnnotation annotation, UElement argument, List<? extends UAnnotation> allAnnotations) {
        if (argument instanceof UIfExpression) {
            if (((UIfExpression)argument).getThenExpression() != null) {
                UExpression uExpression = ((UIfExpression)argument).getThenExpression();
                if (uExpression == null) {
                    Intrinsics.throwNpe();
                }
                this.checkIntRange(context, annotation, (UElement)uExpression, allAnnotations);
            }
            if (((UIfExpression)argument).getElseExpression() != null) {
                UExpression uExpression = ((UIfExpression)argument).getElseExpression();
                if (uExpression == null) {
                    Intrinsics.throwNpe();
                }
                this.checkIntRange(context, annotation, (UElement)uExpression, allAnnotations);
            }
            return;
        }
        String message2 = Companion.getIntRangeError(context, annotation, argument);
        if (message2 != null) {
            if (TypedefDetector.Companion.findIntDef(allAnnotations) != null) {
                return;
            }
            this.report(context, RANGE, argument, context.getLocation(argument), message2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkFloatRange(JavaContext context, UAnnotation annotation, UElement argument) {
        if (argument instanceof UIfExpression) {
            if (((UIfExpression)argument).getThenExpression() != null) {
                UExpression uExpression = ((UIfExpression)argument).getThenExpression();
                if (uExpression == null) {
                    Intrinsics.throwNpe();
                }
                this.checkFloatRange(context, annotation, (UElement)uExpression);
            }
            if (((UIfExpression)argument).getElseExpression() != null) {
                UExpression uExpression = ((UIfExpression)argument).getElseExpression();
                if (uExpression == null) {
                    Intrinsics.throwNpe();
                }
                this.checkFloatRange(context, annotation, (UElement)uExpression);
            }
            return;
        }
        FloatRangeConstraint floatRangeConstraint = FloatRangeConstraint.create(annotation);
        Intrinsics.checkExpressionValueIsNotNull((Object)floatRangeConstraint, (String)"FloatRangeConstraint.create(annotation)");
        FloatRangeConstraint constraint = floatRangeConstraint;
        Object constant = ConstantEvaluator.evaluate((JavaContext)context, (UElement)argument);
        if (!(constant instanceof Number)) {
            PsiElement resolved;
            if (constant instanceof float[] || constant instanceof double[] || constant instanceof int[] || constant instanceof long[]) {
                if (constant instanceof float[]) {
                    for (float value : (float[])constant) {
                        if (constraint.isValid(value)) continue;
                        String string = constraint.describe(value);
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"constraint.describe(value.toDouble())");
                        String message2 = string;
                        this.report(context, RANGE, argument, context.getLocation(argument), message2);
                        return;
                    }
                }
                if (constant instanceof double[]) {
                    void var8_8;
                    double[] dArray = (double[])constant;
                    int message2 = dArray.length;
                    boolean bl = false;
                    while (var8_8 < message2) {
                        double value = dArray[var8_8];
                        if (!constraint.isValid(value)) {
                            String string = constraint.describe(value);
                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"constraint.describe(value)");
                            String message3 = string;
                            this.report(context, RANGE, argument, context.getLocation(argument), message3);
                            return;
                        }
                        ++var8_8;
                    }
                }
                if (constant instanceof int[]) {
                    for (int value : (int[])constant) {
                        if (constraint.isValid(value)) continue;
                        String string = constraint.describe(value);
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"constraint.describe(value.toDouble())");
                        String message4 = string;
                        this.report(context, RANGE, argument, context.getLocation(argument), message4);
                        return;
                    }
                }
                if (constant instanceof long[]) {
                    void var8_12;
                    long[] lArray = (long[])constant;
                    int message4 = lArray.length;
                    boolean bl = false;
                    while (var8_12 < message4) {
                        long value = lArray[var8_12];
                        if (!constraint.isValid(value)) {
                            String string = constraint.describe(value);
                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"constraint.describe(value.toDouble())");
                            String message5 = string;
                            this.report(context, RANGE, argument, context.getLocation(argument), message5);
                            return;
                        }
                        ++var8_12;
                    }
                }
            }
            if (argument instanceof UResolvable && (resolved = ((UResolvable)argument).resolve()) instanceof PsiModifierListOwner) {
                Boolean contains;
                RangeConstraint referenceConstraint = RangeConstraint.create((PsiModifierListOwner)resolved);
                RangeConstraint rangeConstraint = RangeConstraint.create(annotation);
                if (rangeConstraint != null && referenceConstraint != null && (contains = rangeConstraint.contains(referenceConstraint)) != null && !contains.booleanValue()) {
                    String message6 = rangeConstraint.toString();
                    this.report(context, RANGE, argument, context.getLocation(argument), message6);
                }
            }
            return;
        }
        double value = ((Number)constant).doubleValue();
        if (!constraint.isValid(value)) {
            UElement uElement = argument;
            if (!(uElement instanceof UExpression)) {
                uElement = null;
            }
            String string = constraint.describe((UExpression)uElement, value);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"constraint.describe(\n   \u2026sion, value\n            )");
            String string2 = string;
            this.report(context, RANGE, argument, context.getLocation(argument), string2);
        }
    }

    private final void checkSize(JavaContext context, UAnnotation annotation, UElement argument) {
        long actual = 0L;
        boolean isString = false;
        if (UastExpressionUtils.isNewArrayWithInitializer((UElement)argument)) {
            UElement uElement = argument;
            if (uElement == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.uast.UCallExpression");
            }
            actual = ((UCallExpression)uElement).getValueArgumentCount();
        } else {
            if (argument instanceof UIfExpression) {
                if (((UIfExpression)argument).getThenExpression() != null) {
                    UExpression uExpression = ((UIfExpression)argument).getThenExpression();
                    if (uExpression == null) {
                        Intrinsics.throwNpe();
                    }
                    this.checkSize(context, annotation, (UElement)uExpression);
                }
                if (((UIfExpression)argument).getElseExpression() != null) {
                    UExpression uExpression = ((UIfExpression)argument).getElseExpression();
                    if (uExpression == null) {
                        Intrinsics.throwNpe();
                    }
                    this.checkSize(context, annotation, (UElement)uExpression);
                }
                return;
            }
            Object object = ConstantEvaluator.evaluate((JavaContext)context, (UElement)argument);
            if (object instanceof String) {
                actual = ((String)object).length();
                isString = true;
            } else {
                actual = ConstantEvaluator.getArraySize((Object)object);
                if (actual == -1L) {
                    PsiElement resolved;
                    if (argument instanceof UResolvable && (resolved = ((UResolvable)argument).resolve()) instanceof PsiModifierListOwner) {
                        Boolean contains;
                        RangeConstraint constraint = RangeConstraint.create((PsiModifierListOwner)resolved);
                        RangeConstraint here = RangeConstraint.create(annotation);
                        if (here != null && constraint != null && (contains = here.contains(constraint)) != null && !contains.booleanValue()) {
                            String message2 = here.toString();
                            this.report(context, RANGE, argument, context.getLocation(argument), message2);
                        }
                    }
                    return;
                }
            }
        }
        SizeConstraint sizeConstraint = SizeConstraint.create(annotation);
        Intrinsics.checkExpressionValueIsNotNull((Object)sizeConstraint, (String)"SizeConstraint.create(annotation)");
        SizeConstraint constraint = sizeConstraint;
        if (!constraint.isValid(actual)) {
            String unit = isString ? "length" : "size";
            UElement uElement = argument;
            if (!(uElement instanceof UExpression)) {
                uElement = null;
            }
            String string = constraint.describe((UExpression)uElement, unit, actual);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"constraint.describe(\n   \u2026nit, actual\n            )");
            String message3 = string;
            this.report(context, RANGE, argument, context.getLocation(argument), message3);
        }
    }

    static {
        Companion = new Companion(null);
        IMPLEMENTATION = new Implementation(RangeDetector.class, Scope.JAVA_FILE_SCOPE);
        RANGE = Issue.Companion.create("Range", "Outside Range", "\n                Some parameters are required to in a particular numerical range; this check \\\n                makes sure that arguments passed fall within the range. For arrays, Strings \\\n                and collections this refers to the size or length.", Category.CORRECTNESS, 6, Severity.ERROR, IMPLEMENTATION);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0007\u001a\u0004\u0018\u00010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nJ \u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/lint/checks/RangeDetector$Companion;", "", "()V", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "RANGE", "Lcom/android/tools/lint/detector/api/Issue;", "findIntRange", "Lorg/jetbrains/uast/UAnnotation;", "annotations", "", "getIntRangeError", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "annotation", "argument", "Lorg/jetbrains/uast/UElement;", "lint-checks"})
    public static final class Companion {
        @Nullable
        public final UAnnotation findIntRange(@NotNull List<? extends UAnnotation> annotations) {
            Intrinsics.checkParameterIsNotNull(annotations, (String)"annotations");
            for (UAnnotation uAnnotation : annotations) {
                if (!AnnotationDetector.INT_RANGE_ANNOTATION.isEquals(uAnnotation.getQualifiedName())) continue;
                return uAnnotation;
            }
            return null;
        }

        @Nullable
        public final String getIntRangeError(@NotNull JavaContext context, @NotNull UAnnotation annotation, @NotNull UElement argument) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)annotation, (String)"annotation");
            Intrinsics.checkParameterIsNotNull((Object)argument, (String)"argument");
            if (UastExpressionUtils.isNewArrayWithInitializer((UElement)argument)) {
                UCallExpression newExpression = (UCallExpression)argument;
                for (UExpression expression : newExpression.getValueArguments()) {
                    String error = this.getIntRangeError(context, annotation, (UElement)expression);
                    if (error == null) continue;
                    return error;
                }
            }
            IntRangeConstraint intRangeConstraint = IntRangeConstraint.create(annotation);
            Intrinsics.checkExpressionValueIsNotNull((Object)intRangeConstraint, (String)"IntRangeConstraint.create(annotation)");
            IntRangeConstraint constraint = intRangeConstraint;
            Object o = ConstantEvaluator.evaluate((JavaContext)context, (UElement)argument);
            if (!(o instanceof Number)) {
                PsiElement resolved;
                if (o instanceof int[] || o instanceof long[]) {
                    if (o instanceof int[]) {
                        for (int value : (int[])o) {
                            if (constraint.isValid(value)) continue;
                            return constraint.describe(value);
                        }
                    }
                    if (o instanceof long[]) {
                        for (long value : (long[])o) {
                            if (constraint.isValid(value)) continue;
                            return constraint.describe(value);
                        }
                    }
                }
                if (argument instanceof UResolvable && (resolved = ((UResolvable)argument).resolve()) instanceof PsiModifierListOwner) {
                    Boolean contains;
                    RangeConstraint referenceConstraint = RangeConstraint.create((PsiModifierListOwner)resolved);
                    RangeConstraint here = RangeConstraint.create(annotation);
                    if (here != null && referenceConstraint != null && (contains = here.contains(referenceConstraint)) != null && !contains.booleanValue()) {
                        return here.toString();
                    }
                }
                return null;
            }
            long value = ((Number)o).longValue();
            return !constraint.isValid(value) ? constraint.describe(value) : null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

