/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import java.util.Collections;
import java.util.List;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;

public class SQLiteDetector
extends Detector
implements SourceCodeScanner {
    private static final Implementation IMPLEMENTATION = new Implementation(SQLiteDetector.class, Scope.JAVA_FILE_SCOPE);
    public static final Issue ISSUE = Issue.create((String)"SQLiteString", (String)"Using STRING instead of TEXT", (String)"In SQLite, any column can store any data type; the declared type for a column is more of a hint as to what the data should be cast to when stored.\n\nThere are many ways to store a string. `TEXT`, `VARCHAR`, `CHARACTER` and `CLOB` are string types, **but `STRING` is not**. Columns defined as STRING are actually numeric.\n\nIf you try to store a value in a numeric column, SQLite will try to cast it to a float or an integer before storing. If it can't, it will just store it as a string.\n\nThis can lead to some subtle bugs. For example, when SQLite encounters a string like `1234567e1234`, it will parse it as a float, but the result will be out of range for floating point numbers, so `Inf` will be stored! Similarly, strings that look like integers will lose leading zeroes.\n\nTo fix this, you can change your schema to use a `TEXT` type instead.", (Category)Category.CORRECTNESS, (int)5, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION).addMoreInfo("https://www.sqlite.org/datatype3.html");

    public List<String> getApplicableMethodNames() {
        return Collections.singletonList("execSQL");
    }

    public void visitMethodCall(JavaContext context, UCallExpression call, PsiMethod method) {
        JavaEvaluator evaluator = context.getEvaluator();
        if (!evaluator.isMemberInClass((PsiMember)method, "android.database.sqlite.SQLiteDatabase")) {
            return;
        }
        int parameterCount = evaluator.getParameterCount(method);
        if (parameterCount == 0) {
            return;
        }
        if (!evaluator.parameterHasType(method, 0, "java.lang.String")) {
            return;
        }
        UExpression argument = (UExpression)call.getValueArguments().get(0);
        String sql = ConstantEvaluator.evaluateString((JavaContext)context, (UElement)argument, (boolean)true);
        if (sql != null && (sql.startsWith("CREATE TABLE") || sql.startsWith("ALTER TABLE")) && sql.matches(".*\\bSTRING\\b.*")) {
            String message2 = "Using column type STRING; did you mean to use TEXT? (STRING is a numeric type and its value can be adjusted; for example, strings that look like integers can drop leading zeroes. See issue explanation for details.)";
            context.report(ISSUE, (UElement)call, context.getLocation((UElement)call), message2);
        }
    }
}

