/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint;

import com.android.ide.common.repository.ResourceVisibilityLookup;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Desugaring;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Severity;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\f\b\u0002\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0000J\u0016\u0010\u0011\u001a\u00020\u000f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u0013H\u0002J\u0013\u0010\u0014\u001a\u00020\t2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0096\u0002J\b\u0010\u0017\u001a\u00020\rH\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\tH\u0016J\b\u0010\u001b\u001a\u00020\tH\u0016J\u001c\u0010\u001c\u001a\u00020\u000f2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00050\u00132\u0006\u0010\u001e\u001a\u00020\tJ\u000e\u0010\u001f\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020\u0007J\u0016\u0010!\u001a\u00020\u000f2\u000e\u0010\"\u001a\n\u0012\u0004\u0012\u00020$\u0018\u00010#J\"\u0010%\u001a\u00020\u000f2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00050\u00132\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u0013J\u0014\u0010'\u001a\u00020\u000f2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00050\u0013J\u0010\u0010)\u001a\u00020\u000f2\b\u0010\f\u001a\u0004\u0018\u00010\rJ\"\u0010*\u001a\u00020\u000f2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00050\u00132\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00050\u0013J\"\u0010-\u001a\u00020\u000f2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00050\u00132\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u0013J\"\u0010.\u001a\u00020\u000f2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00050\u00132\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u0013J\b\u0010/\u001a\u00020\u0007H\u0016R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/android/tools/lint/ManualProject;", "Lcom/android/tools/lint/detector/api/Project;", "client", "Lcom/android/tools/lint/client/api/LintClient;", "dir", "Ljava/io/File;", "name", "", "library", "", "android", "(Lcom/android/tools/lint/client/api/LintClient;Ljava/io/File;Ljava/lang/String;ZZ)V", "resourceVisibility", "Lcom/android/ide/common/repository/ResourceVisibilityLookup;", "addDirectDependency", "", "project", "addFilteredFiles", "sources", "", "equals", "other", "", "getResourceVisibility", "hashCode", "", "isAndroidProject", "isGradleProject", "setClasspath", "allClasses", "useForAnalysis", "setCompileSdkVersion", "buildApi", "setDesugaring", "desugaring", "", "Lcom/android/tools/lint/detector/api/Desugaring;", "setGeneratedSources", "sourceRoots", "setManifests", "manifests", "setResourceVisibility", "setResources", "resourceRoots", "resources", "setSources", "setTestSources", "toString", "lint"})
final class ManualProject
extends Project {
    private ResourceVisibilityLookup resourceVisibility;
    private boolean android;

    public final void addDirectDependency(@NotNull ManualProject project) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)project), (String)"project");
        this.directLibraries.add(project);
    }

    public boolean isAndroidProject() {
        return this.android;
    }

    public boolean isGradleProject() {
        return false;
    }

    @NotNull
    public String toString() {
        return "Project [name=" + this.name + ']';
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (Intrinsics.areEqual(((Object)((Object)this)).getClass(), other.getClass()) ^ true) {
            return false;
        }
        Project project = (Project)other;
        return Intrinsics.areEqual((Object)this.name, (Object)project.getName());
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public final void setManifests(@NotNull List<? extends File> manifests) {
        Intrinsics.checkParameterIsNotNull(manifests, (String)"manifests");
        this.manifestFiles = manifests;
        this.addFilteredFiles(manifests);
    }

    public final void setResources(@NotNull List<? extends File> resourceRoots, @NotNull List<? extends File> resources) {
        Intrinsics.checkParameterIsNotNull(resourceRoots, (String)"resourceRoots");
        Intrinsics.checkParameterIsNotNull(resources, (String)"resources");
        this.resourceFolders = resourceRoots;
        this.addFilteredFiles(resources);
    }

    public final void setSources(@NotNull List<? extends File> sourceRoots, @NotNull List<? extends File> sources) {
        Intrinsics.checkParameterIsNotNull(sourceRoots, (String)"sourceRoots");
        Intrinsics.checkParameterIsNotNull(sources, (String)"sources");
        this.javaSourceFolders = sourceRoots;
        this.addFilteredFiles(sources);
    }

    public final void setTestSources(@NotNull List<? extends File> sourceRoots, @NotNull List<? extends File> sources) {
        Intrinsics.checkParameterIsNotNull(sourceRoots, (String)"sourceRoots");
        Intrinsics.checkParameterIsNotNull(sources, (String)"sources");
        this.testSourceFolders = sourceRoots;
        this.addFilteredFiles(sources);
    }

    public final void setGeneratedSources(@NotNull List<? extends File> sourceRoots, @NotNull List<? extends File> sources) {
        Intrinsics.checkParameterIsNotNull(sourceRoots, (String)"sourceRoots");
        Intrinsics.checkParameterIsNotNull(sources, (String)"sources");
        this.generatedSourceFolders = sourceRoots;
        this.addFilteredFiles(sources);
    }

    private final void addFilteredFiles(List<? extends File> sources) {
        if (!sources.isEmpty()) {
            if (this.files == null) {
                List list;
                ManualProject manualProject = this;
                boolean bl = false;
                manualProject.files = list = (List)new ArrayList();
            }
            this.files.addAll((Collection)sources);
        }
    }

    public final void setClasspath(@NotNull List<? extends File> allClasses, boolean useForAnalysis) {
        Intrinsics.checkParameterIsNotNull(allClasses, (String)"allClasses");
        if (useForAnalysis) {
            this.javaClassFolders = allClasses;
        } else {
            this.javaLibraries = allClasses;
        }
    }

    public final void setCompileSdkVersion(@NotNull String buildApi) {
        Intrinsics.checkParameterIsNotNull((Object)buildApi, (String)"buildApi");
        CharSequence charSequence = buildApi;
        boolean bl = false;
        if (!(charSequence.length() == 0)) {
            this.buildTargetHash = Character.isDigit(buildApi.charAt(0)) ? "android-" + buildApi : buildApi;
            AndroidVersion version = AndroidTargetHash.getPlatformVersion((String)buildApi);
            if (version != null) {
                this.buildSdk = version.getFeatureLevel();
            } else {
                this.client.log(Severity.WARNING, null, "Unexpected build target format: %1$s", new Object[]{buildApi});
            }
        }
    }

    public final void setDesugaring(@Nullable Set<? extends Desugaring> desugaring) {
        this.desugaring = desugaring;
    }

    public final void setResourceVisibility(@Nullable ResourceVisibilityLookup resourceVisibility) {
        this.resourceVisibility = resourceVisibility;
    }

    @NotNull
    public ResourceVisibilityLookup getResourceVisibility() {
        ResourceVisibilityLookup resourceVisibilityLookup = this.resourceVisibility;
        if (resourceVisibilityLookup == null) {
            ResourceVisibilityLookup resourceVisibilityLookup2 = super.getResourceVisibility();
            resourceVisibilityLookup = resourceVisibilityLookup2;
            Intrinsics.checkExpressionValueIsNotNull((Object)resourceVisibilityLookup2, (String)"super.getResourceVisibility()");
        }
        return resourceVisibilityLookup;
    }

    public ManualProject(@NotNull LintClient client, @NotNull File dir, @NotNull String name, boolean library, boolean android) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        super(client, dir, dir);
        this.android = android;
        this.setName(name);
        ManualProject manualProject = this;
        boolean bl = false;
        manualProject.directLibraries = list = (List)new ArrayList();
        this.library = library;
        this.buildSdk = 28;
        this.mergeManifests = true;
    }
}

