/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint;

import com.android.tools.lint.LintCliClient;
import com.android.tools.lint.LintCliFlags;
import com.android.tools.lint.LintFixPerformer;
import com.android.tools.lint.LintStats;
import com.android.tools.lint.Reporter;
import com.android.tools.lint.Warning;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Position;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.TextFormat;
import com.android.utils.SdkUtils;
import com.android.utils.XmlUtils;
import com.google.common.annotations.Beta;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.io.Files;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0016\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\tJ\u0018\u0010 \u001a\u00020\u00152\u0006\u0010\u0002\u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010\tJ\u001e\u0010#\u001a\u00020\u00152\u0006\u0010$\u001a\u00020%2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00170'H\u0016J(\u0010(\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\tH\u0002J\u0010\u0010)\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0016\u0010*\u001a\u00020\u00152\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00170'H\u0002R\u001c\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\r\"\u0004\b\u0011\u0010\u000fR\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/android/tools/lint/XmlReporter;", "Lcom/android/tools/lint/Reporter;", "client", "Lcom/android/tools/lint/LintCliClient;", "output", "Ljava/io/File;", "(Lcom/android/tools/lint/LintCliClient;Ljava/io/File;)V", "attributes", "", "", "includeFixes", "", "getIncludeFixes", "()Z", "setIncludeFixes", "(Z)V", "isIntendedForBaseline", "setIntendedForBaseline", "writer", "Ljava/io/Writer;", "emitFix", "", "warning", "Lcom/android/tools/lint/Warning;", "lintFix", "Lcom/android/tools/lint/detector/api/LintFix;", "emitFixes", "indent", "", "setAttribute", "name", "value", "setBaselineAttributes", "Lcom/android/tools/lint/client/api/LintClient;", "variant", "write", "stats", "Lcom/android/tools/lint/LintStats;", "issues", "", "writeAttribute", "writeIssue", "writeIssues", "lint"})
@Beta
public final class XmlReporter
extends Reporter {
    private final Writer writer;
    private boolean isIntendedForBaseline;
    private boolean includeFixes;
    private Map<String, String> attributes;

    public final boolean isIntendedForBaseline() {
        return this.isIntendedForBaseline;
    }

    public final void setIntendedForBaseline(boolean bl) {
        this.isIntendedForBaseline = bl;
    }

    public final boolean getIncludeFixes() {
        return this.includeFixes;
    }

    public final void setIncludeFixes(boolean bl) {
        this.includeFixes = bl;
    }

    public final void setAttribute(@NotNull String name, @NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Map map = this.attributes;
        if (map == null) {
            Map newMap;
            XmlReporter xmlReporter = this;
            boolean bl = false;
            boolean bl2 = false;
            XmlReporter $this$run = xmlReporter;
            boolean bl3 = false;
            boolean bl4 = false;
            $this$run.attributes = newMap = (Map)new LinkedHashMap();
            map = newMap;
        }
        Map attributes = map;
        attributes.put((String)name, (String)value);
    }

    public final void setBaselineAttributes(@NotNull LintClient client, @Nullable String variant) {
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        this.setAttribute("client", LintClient.Companion.getClientName());
        String revision = client.getClientDisplayRevision();
        if (revision != null) {
            this.setAttribute("version", revision);
        }
        if (variant != null) {
            this.setAttribute("variant", variant);
        }
    }

    public void write(@NotNull LintStats stats, @NotNull List<? extends Warning> issues) throws IOException {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)stats, (String)"stats");
        Intrinsics.checkParameterIsNotNull(issues, (String)"issues");
        this.writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        this.writer.write("<issues format=\"5\"");
        String revision = this.client.getClientDisplayRevision();
        if (revision != null) {
            object = StringCompanionObject.INSTANCE;
            String string = " by=\"lint %1$s\"";
            Object[] objectArray = new Object[]{revision};
            Writer writer = this.writer;
            boolean bl = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
            String string3 = string2;
            writer.write(string3);
        }
        Map<String, String> map = this.attributes;
        if (map != null) {
            object = map;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object;
            boolean bl3 = false;
            Sequence $this$sortedBy$iv = MapsKt.asSequence((Map)it);
            boolean $i$f$sortedBy = false;
            Sequence sequence = $this$sortedBy$iv;
            boolean bl4 = false;
            Comparator comparator = new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    Map.Entry it = (Map.Entry)a;
                    boolean bl2 = false;
                    Comparable comparable = (Comparable)((Object)((String)it.getKey()));
                    it = (Map.Entry)b;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    String string = (String)it.getKey();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
                }
            };
            Sequence $this$forEach$iv = SequencesKt.sortedWith((Sequence)sequence, (Comparator)comparator);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Map.Entry it2 = (Map.Entry)element$iv;
                boolean bl5 = false;
                this.writer.write(' ' + (String)it2.getKey() + "=\"" + XmlUtils.toXmlAttributeValue((String)((String)it2.getValue())) + '\"');
            }
        }
        this.writer.write(">\n");
        if (!issues.isEmpty()) {
            this.writeIssues(issues);
        }
        this.writer.write("\n</issues>\n");
        this.writer.close();
        LintCliFlags lintCliFlags = this.client.getFlags();
        Intrinsics.checkExpressionValueIsNotNull((Object)lintCliFlags, (String)"client.getFlags()");
        if (!(lintCliFlags.isQuiet() || stats.getErrorCount() <= 0 && stats.getWarningCount() <= 0)) {
            File file = this.output;
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"output");
            String url = SdkUtils.fileToUrlString((File)file.getAbsoluteFile());
            Object object2 = StringCompanionObject.INSTANCE;
            String string = "Wrote XML report to %1$s";
            Object[] objectArray = new Object[]{url};
            boolean bl = false;
            String string4 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"java.lang.String.format(format, *args)");
            object2 = string4;
            boolean bl6 = false;
            System.out.println(object2);
        }
    }

    private final void writeIssues(List<? extends Warning> issues) {
        for (Warning warning : issues) {
            this.writeIssue(warning);
        }
    }

    private final void writeIssue(Warning warning) {
        Location location;
        int index2;
        int index1;
        Object moreInfo;
        this.writer.write(10);
        this.indent(1);
        this.writer.write("<issue");
        Issue issue = warning.issue;
        this.writeAttribute(this.writer, 2, "id", issue.getId());
        if (!this.isIntendedForBaseline) {
            this.writeAttribute(this.writer, 2, "severity", warning.severity.getDescription());
        }
        String string = warning.message;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"warning.message");
        this.writeAttribute(this.writer, 2, "message", string);
        if (!this.isIntendedForBaseline) {
            this.writeAttribute(this.writer, 2, "category", issue.getCategory().getFullName());
            String string2 = Integer.toString(issue.getPriority());
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"Integer.toString(issue.priority)");
            this.writeAttribute(this.writer, 2, "priority", string2);
            this.writeAttribute(this.writer, 2, "summary", issue.getBriefDescription(TextFormat.RAW));
            this.writeAttribute(this.writer, 2, "explanation", issue.getExplanation(TextFormat.RAW));
            moreInfo = issue.getMoreInfo();
            if (!moreInfo.isEmpty()) {
                this.writeAttribute(this.writer, 2, "url", (String)moreInfo.get(0));
                String string3 = Joiner.on((char)',').join((Iterable)issue.getMoreInfo());
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"Joiner.on(',').join(issue.moreInfo)");
                this.writeAttribute(this.writer, 2, "urls", string3);
            }
        }
        if (warning.errorLine != null) {
            String string4 = warning.errorLine;
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"warning.errorLine");
            moreInfo = string4;
            boolean bl = false;
            if (!(moreInfo.length() == 0)) {
                String line;
                String string5 = line = warning.errorLine;
                Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"line");
                index1 = StringsKt.indexOf$default((CharSequence)string5, (char)'\n', (int)0, (boolean)false, (int)6, null);
                if (index1 != -1 && (index2 = StringsKt.indexOf$default((CharSequence)line, (char)'\n', (int)(index1 + 1), (boolean)false, (int)4, null)) != -1) {
                    String string6 = line;
                    int n = 0;
                    int n2 = 0;
                    String string7 = string6.substring(n, index1);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    String line422 = string7;
                    String string8 = line;
                    n2 = index1 + 1;
                    boolean bl2 = false;
                    String string9 = string8.substring(n2, index2);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    String line2 = string9;
                    this.writeAttribute(this.writer, 2, "errorLine1", line422);
                    this.writeAttribute(this.writer, 2, "errorLine2", line2);
                }
            }
        }
        if (warning.isVariantSpecific()) {
            String string10 = Joiner.on((char)',').join((Iterable)warning.getIncludedVariantNames());
            Intrinsics.checkExpressionValueIsNotNull((Object)string10, (String)"Joiner.on(',').join(warning.includedVariantNames)");
            this.writeAttribute(this.writer, 2, "includedVariants", string10);
            String string11 = Joiner.on((char)',').join((Iterable)warning.getExcludedVariantNames());
            Intrinsics.checkExpressionValueIsNotNull((Object)string11, (String)"Joiner.on(',').join(warning.excludedVariantNames)");
            this.writeAttribute(this.writer, 2, "excludedVariants", string11);
        }
        if (!this.isIntendedForBaseline && this.includeFixes && (warning.quickfixData != null || Reporter.hasAutoFix(issue))) {
            this.writeAttribute(this.writer, 2, "quickfix", "studio");
        }
        boolean line = warning.file != null == (warning.location != null);
        index1 = 0;
        index2 = 0;
        if (_Assertions.ENABLED && !line) {
            boolean line422 = false;
            String line422 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)line422));
        }
        if (warning.file != null) {
            line = warning.location.getFile() == warning.file;
            index1 = 0;
            index2 = 0;
            if (_Assertions.ENABLED && !line) {
                boolean line422 = false;
                String line422 = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)line422));
            }
        }
        boolean hasChildren = false;
        LintFix fixData = warning.quickfixData;
        if (this.includeFixes && fixData != null) {
            this.writer.write(">\n");
            this.emitFixes(warning, fixData);
            hasChildren = true;
        }
        if ((location = warning.location) != null) {
            if (!hasChildren) {
                this.writer.write(">\n");
            }
            while (location != null) {
                String path;
                this.indent(2);
                this.writer.write("<location");
                Project project = warning.project;
                File file = location.getFile();
                LintCliFlags lintCliFlags = this.client.flags;
                Intrinsics.checkExpressionValueIsNotNull((Object)lintCliFlags, (String)"client.flags");
                Intrinsics.checkExpressionValueIsNotNull((Object)this.client.getDisplayPath(project, file, lintCliFlags.isFullPath() && !this.isIntendedForBaseline), (String)"client.getDisplayPath(\n \u2026aseline\n                )");
                this.writeAttribute(this.writer, 3, "file", path);
                Position start = location.getStart();
                if (start != null) {
                    int line2 = start.getLine();
                    int column = start.getColumn();
                    if (line2 >= 0) {
                        String string12 = Integer.toString(line2 + 1);
                        Intrinsics.checkExpressionValueIsNotNull((Object)string12, (String)"Integer.toString(line + 1)");
                        this.writeAttribute(this.writer, 3, "line", string12);
                        if (column >= 0) {
                            String string13 = Integer.toString(column + 1);
                            Intrinsics.checkExpressionValueIsNotNull((Object)string13, (String)"Integer.toString(column + 1)");
                            this.writeAttribute(this.writer, 3, "column", string13);
                        }
                    }
                }
                this.writer.write("/>\n");
                location = location.getSecondary();
            }
            hasChildren = true;
        }
        if (hasChildren) {
            this.indent(1);
            this.writer.write("</issue>\n");
        } else {
            this.writer.write(10);
            this.indent(1);
            this.writer.write("/>\n");
        }
    }

    private final void emitFixes(Warning warning, LintFix lintFix) {
        List fixes = lintFix instanceof LintFix.LintFixGroup && ((LintFix.LintFixGroup)lintFix).type == LintFix.GroupType.ALTERNATIVES ? ((LintFix.LintFixGroup)lintFix).fixes : CollectionsKt.listOf((Object)lintFix);
        Iterator iterator = fixes.iterator();
        while (iterator.hasNext()) {
            LintFix fix;
            LintFix lintFix2 = fix = (LintFix)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)lintFix2, (String)"fix");
            this.emitFix(warning, lintFix2);
        }
    }

    private final void emitFix(Warning warning, LintFix lintFix) {
        Object it;
        this.indent(2);
        this.writer.write("<fix");
        String string = lintFix.getDisplayName();
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            it = string2;
            boolean bl3 = false;
            this.writeAttribute(this.writer, 3, "description", (String)it);
        }
        this.writeAttribute(this.writer, 3, "auto", String.valueOf(LintFixPerformer.Companion.canAutoFix(lintFix)));
        boolean haveChildren = false;
        LintCliClient lintCliClient = this.client;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)lintCliClient), (String)"client");
        LintFixPerformer performer = new LintFixPerformer(lintCliClient, false);
        List<LintFixPerformer.PendingEditFile> files = performer.computeEdits(warning, lintFix);
        if (files != null) {
            it = files;
            boolean bl = false;
            if (!it.isEmpty()) {
                haveChildren = true;
                this.writer.write(">\n");
                for (LintFixPerformer.PendingEditFile file : files) {
                    for (LintFixPerformer.PendingEdit edit : file.getEdits()) {
                        String before;
                        String after;
                        String path;
                        this.indent(3);
                        this.writer.write("<edit");
                        Project project = warning.project;
                        File file2 = file.getFile();
                        LintCliFlags lintCliFlags = this.client.flags;
                        Intrinsics.checkExpressionValueIsNotNull((Object)lintCliFlags, (String)"client.flags");
                        Intrinsics.checkExpressionValueIsNotNull((Object)this.client.getDisplayPath(project, file2, lintCliFlags.isFullPath() && !this.isIntendedForBaseline), (String)"client.getDisplayPath(\n \u2026ine\n                    )");
                        this.writeAttribute(this.writer, 4, "file", path);
                        boolean bl4 = false;
                        boolean bl5 = false;
                        LintFixPerformer.PendingEdit $this$with = edit;
                        boolean bl6 = false;
                        String string3 = $this$with.getSource();
                        int n = Math.max($this$with.getStartOffset() - 12, 0);
                        int n2 = $this$with.getStartOffset();
                        int n3 = 0;
                        String string4 = string3;
                        if (string4 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                        }
                        Intrinsics.checkExpressionValueIsNotNull((Object)string4.substring(n, n2), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        CharSequence charSequence = $this$with.getSource();
                        n2 = $this$with.getStartOffset();
                        n3 = Math.min(Math.max($this$with.getStartOffset() + 12, $this$with.getEndOffset()), $this$with.getSource().length());
                        boolean bl7 = false;
                        String string5 = charSequence;
                        if (string5 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                        }
                        Intrinsics.checkExpressionValueIsNotNull((Object)string5.substring(n2, n3), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        this.writeAttribute(this.writer, 4, "offset", String.valueOf($this$with.getStartOffset()));
                        String string6 = XmlUtils.toXmlAttributeValue((String)after);
                        Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"toXmlAttributeValue(after)");
                        this.writeAttribute(this.writer, 4, "after", string6);
                        String string7 = XmlUtils.toXmlAttributeValue((String)before);
                        Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"toXmlAttributeValue(before)");
                        this.writeAttribute(this.writer, 4, "before", string7);
                        if ($this$with.getEndOffset() > $this$with.getStartOffset()) {
                            String string8;
                            charSequence = $this$with.getSource();
                            n2 = $this$with.getStartOffset();
                            n3 = $this$with.getEndOffset();
                            String string9 = "delete";
                            int n4 = 4;
                            Writer writer = this.writer;
                            XmlReporter xmlReporter = this;
                            bl7 = false;
                            CharSequence charSequence2 = charSequence;
                            if (charSequence2 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                            }
                            Intrinsics.checkExpressionValueIsNotNull((Object)((String)charSequence2).substring(n2, n3), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                            String string10 = XmlUtils.toXmlAttributeValue((String)string8);
                            Intrinsics.checkExpressionValueIsNotNull((Object)string10, (String)"toXmlAttributeValue(\n   \u2026                        )");
                            xmlReporter.writeAttribute(writer, n4, string9, string10);
                        }
                        charSequence = $this$with.getReplacement();
                        n2 = 0;
                        if (charSequence.length() > 0) {
                            String string11 = XmlUtils.toXmlAttributeValue((String)$this$with.getReplacement());
                            Intrinsics.checkExpressionValueIsNotNull((Object)string11, (String)"toXmlAttributeValue(replacement)");
                            this.writeAttribute(this.writer, 4, "insert", string11);
                        }
                        this.writer.write("/>\n");
                    }
                }
            }
        }
        if (haveChildren) {
            this.indent(2);
            this.writer.write("</fix>\n");
        } else {
            this.writer.write("/>\n");
        }
    }

    private final void writeAttribute(Writer writer, int indent, String name, String value) throws IOException {
        writer.write(10);
        this.indent(indent);
        writer.write(name);
        writer.write(61);
        writer.write(34);
        writer.write(XmlUtils.toXmlAttributeValue((String)value));
        writer.write(34);
    }

    /*
     * WARNING - void declaration
     */
    private final void indent(int indent) throws IOException {
        int n = 0;
        int n2 = indent;
        while (n < n2) {
            void level;
            this.writer.write("    ");
            ++level;
        }
    }

    public XmlReporter(@NotNull LintCliClient client, @NotNull File output) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)((Object)client), (String)"client");
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        super(client, output);
        this.writer = new BufferedWriter(Files.newWriter((File)output, (Charset)Charsets.UTF_8));
    }
}

