/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources.deprecated;

import com.android.ide.common.resources.configuration.Configurable;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.deprecated.IdGeneratingResourceFile;
import com.android.ide.common.resources.deprecated.MultiResourceFile;
import com.android.ide.common.resources.deprecated.ResourceDeltaKind;
import com.android.ide.common.resources.deprecated.ResourceFile;
import com.android.ide.common.resources.deprecated.ResourceRepository;
import com.android.ide.common.resources.deprecated.ScanningContext;
import com.android.ide.common.resources.deprecated.SingleResourceFile;
import com.android.io.IAbstractFile;
import com.android.io.IAbstractFolder;
import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.utils.SdkUtils;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Deprecated
public final class ResourceFolder
implements Configurable {
    final ResourceFolderType mType;
    final FolderConfiguration mConfiguration;
    IAbstractFolder mFolder;
    List<ResourceFile> mFiles;
    Map<String, ResourceFile> mNames;
    private final ResourceRepository mRepository;

    protected ResourceFolder(ResourceFolderType type, FolderConfiguration config, IAbstractFolder folder, ResourceRepository repository) {
        this.mType = type;
        this.mConfiguration = config;
        this.mFolder = folder;
        this.mRepository = repository;
    }

    public ResourceFile processFile(IAbstractFile file, ResourceDeltaKind kind, ScanningContext context) {
        ResourceFile resFile = this.getFile(file, context);
        if (resFile == null) {
            if (kind != ResourceDeltaKind.REMOVED) {
                resFile = this.createResourceFile(file);
                resFile.load(context);
                this.addFile(resFile);
            }
        } else if (kind == ResourceDeltaKind.REMOVED) {
            this.removeFile(resFile, context);
        } else {
            resFile.update(context);
        }
        return resFile;
    }

    private ResourceFile createResourceFile(IAbstractFile file) {
        ResourceFile resFile;
        if (this.mType != ResourceFolderType.VALUES) {
            if (FolderTypeRelationship.isIdGeneratingFolderType((ResourceFolderType)this.mType) && SdkUtils.endsWithIgnoreCase((String)file.getName(), (String)".xml")) {
                List types = FolderTypeRelationship.getRelatedResourceTypes((ResourceFolderType)this.mType);
                ResourceType primaryType = (ResourceType)types.get(0);
                resFile = new IdGeneratingResourceFile(file, this, primaryType);
            } else {
                resFile = new SingleResourceFile(file, this);
            }
        } else {
            resFile = new MultiResourceFile(file, this);
        }
        return resFile;
    }

    @VisibleForTesting
    public void addFile(ResourceFile file) {
        if (this.mFiles == null) {
            int initialSize = 16;
            if (this.mRepository.isFrameworkRepository()) {
                String name = this.mFolder.getName();
                switch (this.mType) {
                    case DRAWABLE: {
                        int index = name.indexOf(45);
                        if (index == -1) {
                            initialSize = 230;
                            break;
                        }
                        if ((index = name.indexOf(45, index + 1)) == -1) {
                            initialSize = 1260;
                            break;
                        }
                        initialSize = 30;
                        break;
                    }
                    case LAYOUT: {
                        if (name.indexOf(45) != -1) break;
                        initialSize = 200;
                        break;
                    }
                    case VALUES: {
                        if (name.indexOf(45) == -1) {
                            initialSize = 32;
                            break;
                        }
                        initialSize = 4;
                        break;
                    }
                    case ANIM: {
                        initialSize = 85;
                        break;
                    }
                    case COLOR: {
                        initialSize = 32;
                        break;
                    }
                    case RAW: {
                        initialSize = 4;
                        break;
                    }
                }
            }
            this.mFiles = new ArrayList<ResourceFile>(initialSize);
            this.mNames = new HashMap<String, ResourceFile>(initialSize, 2.0f);
        }
        this.mFiles.add(file);
        this.mNames.put(file.getFile().getName(), file);
    }

    protected void removeFile(ResourceFile file, ScanningContext context) {
        file.dispose(context);
        this.mFiles.remove(file);
        this.mNames.remove(file.getFile().getName());
    }

    protected void dispose(ScanningContext context) {
        if (this.mFiles != null) {
            for (ResourceFile file : this.mFiles) {
                file.dispose(context);
            }
            this.mFiles.clear();
            this.mNames.clear();
        }
    }

    public IAbstractFolder getFolder() {
        return this.mFolder;
    }

    public ResourceFolderType getType() {
        return this.mType;
    }

    public ResourceRepository getRepository() {
        return this.mRepository;
    }

    public Collection<ResourceType> getResourceTypes() {
        ArrayList<ResourceType> list = new ArrayList<ResourceType>();
        if (this.mFiles != null) {
            for (ResourceFile file : this.mFiles) {
                Collection<ResourceType> types = file.getResourceTypes();
                for (ResourceType resType : types) {
                    if (list.indexOf(resType) != -1) continue;
                    list.add(resType);
                }
            }
        }
        return list;
    }

    @Override
    public FolderConfiguration getConfiguration() {
        return this.mConfiguration;
    }

    public boolean hasFile(String name) {
        if (this.mNames != null && this.mNames.containsKey(name)) {
            return true;
        }
        return this.mFolder.hasFile(name);
    }

    private ResourceFile getFile(IAbstractFile file, ScanningContext context) {
        ResourceFile resFile;
        assert (this.mFolder.equals(file.getParentFolder()));
        if (this.mNames != null && (resFile = this.mNames.get(file.getName())) != null) {
            return resFile;
        }
        if (file.exists()) {
            resFile = this.createResourceFile(file);
            resFile.load(context);
            this.addFile(resFile);
            return resFile;
        }
        return null;
    }

    public ResourceFile getFile(String filename) {
        ResourceFile resFile;
        if (this.mNames != null && (resFile = this.mNames.get(filename)) != null) {
            return resFile;
        }
        IAbstractFile file = this.mFolder.getFile(filename);
        if (file != null && file.exists()) {
            ResourceFile resFile2 = this.createResourceFile(file);
            resFile2.load(new ScanningContext());
            this.addFile(resFile2);
            return resFile2;
        }
        return null;
    }

    public boolean hasResources(ResourceType type) {
        List folderTypes = FolderTypeRelationship.getRelatedFolders((ResourceType)type);
        boolean valid = false;
        for (ResourceFolderType rft : folderTypes) {
            if (rft != this.mType) continue;
            valid = true;
            break;
        }
        if (valid && this.mFiles != null) {
            for (ResourceFile f : this.mFiles) {
                if (!f.hasResources(type)) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return this.mFolder.toString();
    }
}

