/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.evaluation;

import proguard.classfile.Clazz;
import proguard.classfile.Member;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.ExceptionInfo;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.ExceptionInfoVisitor;
import proguard.classfile.constant.RefConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.SwitchInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.evaluation.TracedStack;
import proguard.evaluation.value.InstructionOffsetValue;
import proguard.evaluation.value.Value;
import proguard.optimize.evaluation.InstructionUsageMarker;
import proguard.optimize.evaluation.PartialEvaluator;
import proguard.optimize.info.ParameterUsageMarker;

public class EvaluationShrinker
extends SimplifiedVisitor
implements AttributeVisitor,
ExceptionInfoVisitor {
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_RESULTS = false;
    private static final int UNSUPPORTED = -1;
    private static final int NOP = 0;
    private static final int POP = 87;
    private static final int POP2 = 88;
    private static final int DUP = 89;
    private static final int DUP_X1 = 90;
    private static final int DUP_X2 = 91;
    private static final int DUP2 = 92;
    private static final int DUP2_X1 = 93;
    private static final int DUP2_X2 = 94;
    private static final int SWAP = 95;
    private static final int MOV_X2 = 22363;
    private static final int MOV2_X1 = 22621;
    private static final int MOV2_X2 = 22622;
    private static final int POP_X1 = 22367;
    private static final int POP_X2 = 5724253;
    private static final int POP_X3 = -1;
    private static final int POP2_X1 = 5789531;
    private static final int POP2_X2 = 0x58585E;
    private static final int POP3 = 22360;
    private static final int POP4 = 22616;
    private static final int POP_DUP = 22871;
    private static final int POP_SWAP_POP = 0x575F57;
    private static final int POP2_SWAP_POP = 5726040;
    private static final int SWAP_DUP_X1 = 23135;
    private static final int SWAP_DUP_X1_SWAP = 0x5F5A5F;
    private static final int SWAP_POP_DUP = 5855071;
    private static final int SWAP_POP_DUP_X1 = 5920607;
    private static final int DUP_X2_POP2 = 22619;
    private static final int DUP2_X1_POP3 = 5724253;
    private static final int DUP2_X2_POP3 = 5724254;
    private static final int DUP2_X2_SWAP_POP = 5726046;
    private final InstructionUsageMarker instructionUsageMarker;
    private final boolean runInstructionUsageMarker;
    private final InstructionVisitor extraDeletedInstructionVisitor;
    private final InstructionVisitor extraAddedInstructionVisitor;
    private final MyStaticInvocationFixer staticInvocationFixer = new MyStaticInvocationFixer();
    private final MyBackwardBranchFixer backwardBranchFixer = new MyBackwardBranchFixer();
    private final MyNonReturningSubroutineFixer nonReturningSubroutineFixer = new MyNonReturningSubroutineFixer();
    private final MyStackConsistencyFixer stackConsistencyFixer = new MyStackConsistencyFixer();
    private final MyInstructionDeleter instructionDeleter = new MyInstructionDeleter();
    private final CodeAttributeEditor codeAttributeEditor = new CodeAttributeEditor(false, true);

    public EvaluationShrinker() {
        this(new PartialEvaluator(), true, null, null);
    }

    public EvaluationShrinker(PartialEvaluator partialEvaluator, boolean runPartialEvaluator, InstructionVisitor extraDeletedInstructionVisitor, InstructionVisitor extraAddedInstructionVisitor) {
        this(new InstructionUsageMarker(partialEvaluator, runPartialEvaluator), true, extraDeletedInstructionVisitor, extraAddedInstructionVisitor);
    }

    public EvaluationShrinker(InstructionUsageMarker instructionUsageMarker, boolean runInstructionUsageMarker, InstructionVisitor extraDeletedInstructionVisitor, InstructionVisitor extraAddedInstructionVisitor) {
        this.instructionUsageMarker = instructionUsageMarker;
        this.runInstructionUsageMarker = runInstructionUsageMarker;
        this.extraDeletedInstructionVisitor = extraDeletedInstructionVisitor;
        this.extraAddedInstructionVisitor = extraAddedInstructionVisitor;
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        try {
            this.visitCodeAttribute0(clazz, method, codeAttribute);
        }
        catch (RuntimeException ex) {
            System.err.println("Unexpected error while shrinking instructions after partial evaluation:");
            System.err.println("  Class       = [" + clazz.getName() + "]");
            System.err.println("  Method      = [" + method.getName(clazz) + method.getDescriptor(clazz) + "]");
            System.err.println("  Exception   = [" + ex.getClass().getName() + "] (" + ex.getMessage() + ")");
            ex.printStackTrace();
            System.err.println("Not optimizing this method");
        }
    }

    public void visitCodeAttribute0(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        if (this.runInstructionUsageMarker) {
            this.instructionUsageMarker.visitCodeAttribute(clazz, method, codeAttribute);
        }
        int codeLength = codeAttribute.u4codeLength;
        this.codeAttributeEditor.reset(codeLength);
        codeAttribute.instructionsAccept(clazz, method, this.instructionUsageMarker.necessaryInstructionFilter(true, this.staticInvocationFixer));
        codeAttribute.instructionsAccept(clazz, method, this.instructionUsageMarker.tracedInstructionFilter(true, this.instructionUsageMarker.necessaryInstructionFilter(false, this.backwardBranchFixer)));
        codeAttribute.instructionsAccept(clazz, method, this.instructionUsageMarker.necessaryInstructionFilter(true, this.nonReturningSubroutineFixer));
        codeAttribute.instructionsAccept(clazz, method, this.instructionUsageMarker.tracedInstructionFilter(true, this.stackConsistencyFixer));
        codeAttribute.instructionsAccept(clazz, method, this.instructionUsageMarker.necessaryInstructionFilter(false, this.instructionDeleter));
        codeAttribute.exceptionsAccept(clazz, method, this);
        this.codeAttributeEditor.visitCodeAttribute(clazz, method, codeAttribute);
    }

    public void visitExceptionInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, ExceptionInfo exceptionInfo) {
        if (!this.instructionUsageMarker.isTraced(exceptionInfo.u2handlerPC)) {
            exceptionInfo.u2endPC = exceptionInfo.u2startPC;
        }
    }

    private boolean isAnyUnnecessaryInstructionBranchingOver(int instructionOffset1, int instructionOffset2) {
        for (int offset = instructionOffset1; offset < instructionOffset2; ++offset) {
            if (!this.instructionUsageMarker.isTraced(offset) || this.instructionUsageMarker.isInstructionNecessary(offset) || !this.isAnyLargerThan(this.instructionUsageMarker.branchTargets(offset), instructionOffset2)) continue;
            return true;
        }
        return false;
    }

    private boolean isAnyLargerThan(InstructionOffsetValue instructionOffsets, int instructionOffset) {
        int branchCount;
        if (instructionOffsets != null && (branchCount = instructionOffsets.instructionOffsetCount()) > 0) {
            for (int branchIndex = 0; branchIndex < branchCount; ++branchIndex) {
                if (instructionOffsets.instructionOffset(branchIndex) <= instructionOffset) continue;
                return true;
            }
        }
        return false;
    }

    private void insertPushInstructions(int offset, boolean replace, boolean before, int computationalType) {
        SimpleInstruction replacementInstruction = new SimpleInstruction(this.pushOpcode(computationalType));
        this.insertInstruction(offset, replace, before, replacementInstruction);
    }

    private byte pushOpcode(int computationalType) {
        switch (computationalType) {
            case 1: {
                return 3;
            }
            case 2: {
                return 9;
            }
            case 3: {
                return 11;
            }
            case 4: {
                return 14;
            }
            case 5: 
            case 6: {
                return 1;
            }
        }
        throw new IllegalArgumentException("No push opcode for computational type [" + computationalType + "]");
    }

    private void insertPopInstructions(int offset, boolean replace, boolean before, int popCount) {
        switch (popCount) {
            case 1: {
                SimpleInstruction popInstruction = new SimpleInstruction(87);
                this.insertInstruction(offset, replace, before, popInstruction);
                break;
            }
            case 2: {
                SimpleInstruction popInstruction = new SimpleInstruction(88);
                this.insertInstruction(offset, replace, before, popInstruction);
                break;
            }
            default: {
                Instruction[] popInstructions = new Instruction[popCount / 2 + popCount % 2];
                SimpleInstruction popInstruction = new SimpleInstruction(88);
                for (int index = 0; index < popCount / 2; ++index) {
                    popInstructions[index] = popInstruction;
                }
                if (popCount % 2 == 1) {
                    popInstruction = new SimpleInstruction(87);
                    popInstructions[popCount / 2] = popInstruction;
                }
                this.insertInstructions(offset, replace, before, popInstruction, popInstructions);
                break;
            }
        }
    }

    private void insertInstruction(int offset, boolean replace, boolean before, Instruction instruction) {
        if (replace) {
            this.codeAttributeEditor.replaceInstruction(offset, instruction);
            if (this.extraAddedInstructionVisitor != null && !this.instructionUsageMarker.isInstructionNecessary(offset)) {
                instruction.accept(null, null, null, offset, this.extraAddedInstructionVisitor);
            }
        } else {
            if (before) {
                this.codeAttributeEditor.insertBeforeInstruction(offset, instruction);
            } else {
                this.codeAttributeEditor.insertAfterInstruction(offset, instruction);
            }
            if (this.extraAddedInstructionVisitor != null) {
                instruction.accept(null, null, null, offset, this.extraAddedInstructionVisitor);
            }
        }
    }

    private void insertInstructions(int offset, boolean replace, boolean before, Instruction instruction, Instruction[] instructions) {
        block6: {
            block5: {
                if (!replace) break block5;
                this.codeAttributeEditor.replaceInstruction(offset, instructions);
                if (this.extraAddedInstructionVisitor == null) break block6;
                if (!this.instructionUsageMarker.isInstructionNecessary(offset)) {
                    instruction.accept(null, null, null, offset, this.extraAddedInstructionVisitor);
                }
                for (int index = 1; index < instructions.length; ++index) {
                    instructions[index].accept(null, null, null, offset, this.extraAddedInstructionVisitor);
                }
                break block6;
            }
            if (before) {
                this.codeAttributeEditor.insertBeforeInstruction(offset, instructions);
            } else {
                this.codeAttributeEditor.insertAfterInstruction(offset, instructions);
            }
            for (int index = 0; index < instructions.length; ++index) {
                if (this.extraAddedInstructionVisitor == null) continue;
                instructions[index].accept(null, null, null, offset, this.extraAddedInstructionVisitor);
            }
        }
    }

    private void replaceByStaticInvocation(Clazz clazz, int offset, ConstantInstruction constantInstruction) {
        ConstantInstruction replacementInstruction = new ConstantInstruction(-72, constantInstruction.constantIndex);
        this.codeAttributeEditor.replaceInstruction(offset, replacementInstruction);
    }

    private void replaceByInfiniteLoop(Clazz clazz, int offset) {
        BranchInstruction replacementInstruction = new BranchInstruction(-89, 0);
        this.codeAttributeEditor.replaceInstruction(offset, replacementInstruction);
    }

    private class MyInstructionDeleter
    extends SimplifiedVisitor
    implements InstructionVisitor {
        private MyInstructionDeleter() {
        }

        public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
            EvaluationShrinker.this.codeAttributeEditor.deleteInstruction(offset);
            if (EvaluationShrinker.this.extraDeletedInstructionVisitor != null) {
                instruction.accept(clazz, method, codeAttribute, offset, EvaluationShrinker.this.extraDeletedInstructionVisitor);
            }
        }
    }

    private class MyStackConsistencyFixer
    extends SimplifiedVisitor
    implements InstructionVisitor {
        private MyStackConsistencyFixer() {
        }

        public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
            if (EvaluationShrinker.this.instructionUsageMarker.isInstructionNecessary(offset)) {
                int pushCount;
                int stackIndex;
                int popCount = instruction.stackPopCount(clazz);
                if (popCount > 0) {
                    TracedStack tracedStack = EvaluationShrinker.this.instructionUsageMarker.getStackBefore(offset);
                    int stackSize = tracedStack.size();
                    int requiredPopCount = 0;
                    int requiredPushCount = 0;
                    for (stackIndex = stackSize - popCount; stackIndex < stackSize; ++stackIndex) {
                        boolean stackEntryUnwantedBefore = EvaluationShrinker.this.instructionUsageMarker.isStackEntryUnwantedBefore(offset, stackIndex);
                        boolean stackEntryPresentBefore = EvaluationShrinker.this.instructionUsageMarker.isStackEntryPresentBefore(offset, stackIndex);
                        if (stackEntryUnwantedBefore) {
                            if (!stackEntryPresentBefore) continue;
                            ++requiredPopCount;
                            continue;
                        }
                        if (stackEntryPresentBefore) continue;
                        ++requiredPushCount;
                    }
                    if (requiredPopCount > 0) {
                        EvaluationShrinker.this.insertPopInstructions(offset, false, true, popCount);
                    }
                    if (requiredPushCount > 0) {
                        Value value = tracedStack.getTop(0);
                        if (requiredPushCount > (value.isCategory2() ? 2 : 1)) {
                            throw new IllegalArgumentException("Unsupported stack size increment [" + requiredPushCount + "] at [" + offset + "]");
                        }
                        EvaluationShrinker.this.insertPushInstructions(offset, false, true, value.computationalType());
                    }
                }
                if ((pushCount = instruction.stackPushCount(clazz)) > 0) {
                    TracedStack tracedStack = EvaluationShrinker.this.instructionUsageMarker.getStackAfter(offset);
                    int stackSize = tracedStack.size();
                    int requiredPopCount = 0;
                    for (stackIndex = stackSize - pushCount; stackIndex < stackSize; ++stackIndex) {
                        if (EvaluationShrinker.this.instructionUsageMarker.isStackEntryNecessaryAfter(offset, stackIndex)) continue;
                        ++requiredPopCount;
                    }
                    if (requiredPopCount > 0) {
                        EvaluationShrinker.this.insertPopInstructions(offset, false, false, requiredPopCount);
                    }
                }
            } else if (EvaluationShrinker.this.instructionUsageMarker.isExtraPushPopInstructionNecessary(offset)) {
                int pushCount;
                int popCount = instruction.stackPopCount(clazz);
                if (popCount > 0) {
                    TracedStack tracedStack = EvaluationShrinker.this.instructionUsageMarker.getStackBefore(offset);
                    int stackSize = tracedStack.size();
                    int expectedPopCount = 0;
                    for (int stackIndex = stackSize - popCount; stackIndex < stackSize; ++stackIndex) {
                        if (!EvaluationShrinker.this.instructionUsageMarker.isStackEntryPresentBefore(offset, stackIndex)) continue;
                        ++expectedPopCount;
                    }
                    if (expectedPopCount > 0) {
                        EvaluationShrinker.this.insertPopInstructions(offset, true, false, expectedPopCount);
                    }
                }
                if ((pushCount = instruction.stackPushCount(clazz)) > 0) {
                    TracedStack tracedStack = EvaluationShrinker.this.instructionUsageMarker.getStackAfter(offset);
                    int stackSize = tracedStack.size();
                    int expectedPushCount = 0;
                    for (int stackIndex = stackSize - pushCount; stackIndex < stackSize; ++stackIndex) {
                        if (!EvaluationShrinker.this.instructionUsageMarker.isStackEntryNecessaryAfter(offset, stackIndex)) continue;
                        ++expectedPushCount;
                    }
                    if (expectedPushCount > 0) {
                        EvaluationShrinker.this.insertPushInstructions(offset, true, false, tracedStack.getTop(0).computationalType());
                    }
                }
            }
        }

        public void visitSimpleInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, SimpleInstruction simpleInstruction) {
            if (EvaluationShrinker.this.instructionUsageMarker.isInstructionNecessary(offset) && this.isDupOrSwap(simpleInstruction)) {
                int topAfter;
                byte oldOpcode = simpleInstruction.opcode;
                int topBefore = EvaluationShrinker.this.instructionUsageMarker.getStackBefore(offset).size() - 1;
                int newOpcodes = this.fixDupSwap(offset, oldOpcode, topBefore, topAfter = EvaluationShrinker.this.instructionUsageMarker.getStackAfter(offset).size() - 1);
                if (newOpcodes == -1) {
                    throw new UnsupportedOperationException("Can't handle " + simpleInstruction.toString() + " instruction at [" + offset + "]");
                }
                if ((newOpcodes & 0xFFFFFF00) == 0) {
                    byte newOpcode = (byte)newOpcodes;
                    if (newOpcode == 0) {
                        EvaluationShrinker.this.codeAttributeEditor.deleteInstruction(offset);
                        if (EvaluationShrinker.this.extraDeletedInstructionVisitor != null) {
                            EvaluationShrinker.this.extraDeletedInstructionVisitor.visitSimpleInstruction(null, null, null, offset, null);
                        }
                    } else if (newOpcode == oldOpcode) {
                        EvaluationShrinker.this.codeAttributeEditor.undeleteInstruction(offset);
                    } else {
                        SimpleInstruction replacementInstruction = new SimpleInstruction(newOpcode);
                        EvaluationShrinker.this.codeAttributeEditor.replaceInstruction(offset, replacementInstruction);
                    }
                } else {
                    Instruction[] replacementInstructions = new Instruction[4];
                    int count = 0;
                    while (newOpcodes != 0) {
                        SimpleInstruction replacementInstruction = new SimpleInstruction((byte)newOpcodes);
                        replacementInstructions[count++] = replacementInstruction;
                        newOpcodes >>>= 8;
                    }
                    if (count < 4) {
                        Instruction[] newInstructions = new Instruction[count];
                        System.arraycopy(replacementInstructions, 0, newInstructions, 0, count);
                        replacementInstructions = newInstructions;
                    }
                    EvaluationShrinker.this.codeAttributeEditor.replaceInstruction(offset, replacementInstructions);
                }
            } else {
                this.visitAnyInstruction(clazz, method, codeAttribute, offset, simpleInstruction);
            }
        }

        public void visitBranchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, BranchInstruction branchInstruction) {
            if (EvaluationShrinker.this.instructionUsageMarker.isInstructionNecessary(offset)) {
                if (branchInstruction.stackPopCount(clazz) > 0 && !EvaluationShrinker.this.instructionUsageMarker.isStackEntryPresentBefore(offset, EvaluationShrinker.this.instructionUsageMarker.getStackBefore(offset).size() - 1)) {
                    BranchInstruction replacementInstruction = new BranchInstruction(-89, branchInstruction.branchOffset);
                    EvaluationShrinker.this.codeAttributeEditor.replaceInstruction(offset, replacementInstruction);
                }
            } else {
                this.visitAnyInstruction(clazz, method, codeAttribute, offset, branchInstruction);
            }
        }

        public void visitAnySwitchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, SwitchInstruction switchInstruction) {
            if (EvaluationShrinker.this.instructionUsageMarker.isInstructionNecessary(offset)) {
                if (switchInstruction.stackPopCount(clazz) > 0 && !EvaluationShrinker.this.instructionUsageMarker.isStackEntryPresentBefore(offset, EvaluationShrinker.this.instructionUsageMarker.getStackBefore(offset).size() - 1)) {
                    BranchInstruction replacementInstruction = new BranchInstruction(-89, switchInstruction.defaultOffset);
                    EvaluationShrinker.this.codeAttributeEditor.replaceInstruction(offset, replacementInstruction);
                }
            } else {
                this.visitAnyInstruction(clazz, method, codeAttribute, offset, switchInstruction);
            }
        }

        private boolean isDupOrSwap(Instruction instruction) {
            return instruction.opcode >= 89 && instruction.opcode <= 95;
        }

        private int fixDupSwap(int instructionOffset, byte dupSwapOpcode, int topBefore, int topAfter) {
            switch (dupSwapOpcode) {
                case 89: {
                    return this.fixedDup(instructionOffset, topBefore, topAfter);
                }
                case 90: {
                    return this.fixedDup_x1(instructionOffset, topBefore, topAfter);
                }
                case 91: {
                    return this.fixedDup_x2(instructionOffset, topBefore, topAfter);
                }
                case 92: {
                    return this.fixedDup2(instructionOffset, topBefore, topAfter);
                }
                case 93: {
                    return this.fixedDup2_x1(instructionOffset, topBefore, topAfter);
                }
                case 94: {
                    return this.fixedDup2_x2(instructionOffset, topBefore, topAfter);
                }
                case 95: {
                    return this.fixedSwap(instructionOffset, topBefore, topAfter);
                }
            }
            throw new IllegalArgumentException("Not a dup/swap opcode [" + dupSwapOpcode + "]");
        }

        private int fixedDup(int instructionOffset, int topBefore, int topAfter) {
            boolean stackEntryPresent0 = EvaluationShrinker.this.instructionUsageMarker.isStackEntryPresentBefore(instructionOffset, topBefore);
            boolean stackEntryNecessary0 = EvaluationShrinker.this.instructionUsageMarker.isStackEntryNecessaryAfter(instructionOffset, topAfter);
            boolean stackEntryNecessary1 = EvaluationShrinker.this.instructionUsageMarker.isStackEntryNecessaryAfter(instructionOffset, topAfter - 1);
            return stackEntryNecessary0 ? (stackEntryNecessary1 ? 89 : 0) : (stackEntryNecessary1 ? 0 : (stackEntryPresent0 ? 87 : 0));
        }

        private int fixedDup_x1(int instructionOffset, int topBefore, int topAfter) {
            boolean stackEntryPresent0 = EvaluationShrinker.this.instructionUsageMarker.isStackEntryPresentBefore(instructionOffset, topBefore);
            boolean stackEntryPresent1 = EvaluationShrinker.this.instructionUsageMarker.isStackEntryPresentBefore(instructionOffset, topBefore - 1);
            boolean stackEntryNecessary0 = EvaluationShrinker.this.instructionUsageMarker.isStackEntryNecessaryAfter(instructionOffset, topAfter);
            boolean stackEntryNecessary1 = EvaluationShrinker.this.instructionUsageMarker.isStackEntryNecessaryAfter(instructionOffset, topAfter - 1);
            boolean stackEntryNecessary2 = EvaluationShrinker.this.instructionUsageMarker.isStackEntryNecessaryAfter(instructionOffset, topAfter - 2);
            return stackEntryNecessary1 ? (stackEntryNecessary2 ? (stackEntryNecessary0 ? 90 : 95) : (stackEntryNecessary0 ? 0 : (stackEntryPresent0 ? 87 : 0))) : (stackEntryPresent1 ? (stackEntryNecessary2 ? (stackEntryNecessary0 ? 5855071 : 22367) : (stackEntryNecessary0 ? 22367 : (stackEntryPresent0 ? 88 : 87))) : (stackEntryNecessary2 ? (stackEntryNecessary0 ? 89 : 0) : (stackEntryNecessary0 ? 0 : (stackEntryPresent0 ? 87 : 0))));
        }

        private int fixedDup_x2(int instructionOffset, int topBefore, int topAfter) {
            boolean stackEntryPresent0 = EvaluationShrinker.this.instructionUsageMarker.isStackEntryPresentBefore(instructionOffset, topBefore);
            boolean stackEntryPresent1 = EvaluationShrinker.this.instructionUsageMarker.isStackEntryPresentBefore(instructionOffset, topBefore - 1);
            boolean stackEntryPresent2 = EvaluationShrinker.this.instructionUsageMarker.isStackEntryPresentBefore(instructionOffset, topBefore - 2);
            boolean stackEntryNecessary0 = EvaluationShrinker.this.instructionUsageMarker.isStackEntryNecessaryAfter(instructionOffset, topAfter);
            boolean stackEntryNecessary1 = EvaluationShrinker.this.instructionUsageMarker.isStackEntryNecessaryAfter(instructionOffset, topAfter - 1);
            boolean stackEntryNecessary2 = EvaluationShrinker.this.instructionUsageMarker.isStackEntryNecessaryAfter(instructionOffset, topAfter - 2);
            boolean stackEntryNecessary3 = EvaluationShrinker.this.instructionUsageMarker.isStackEntryNecessaryAfter(instructionOffset, topAfter - 3);
            return stackEntryNecessary1 ? (stackEntryNecessary2 ? (stackEntryNecessary3 ? (stackEntryNecessary0 ? 91 : 22363) : (stackEntryNecessary0 ? 0 : (stackEntryPresent0 ? 87 : 0))) : (stackEntryPresent2 ? (stackEntryNecessary3 ? -1 : (stackEntryNecessary0 ? 5724253 : (stackEntryPresent0 ? 0x575F57 : 22367))) : (stackEntryNecessary3 ? (stackEntryNecessary0 ? 90 : 95) : (stackEntryNecessary0 ? 0 : (stackEntryPresent0 ? 87 : 0))))) : (stackEntryPresent1 ? (stackEntryNecessary2 ? (stackEntryNecessary3 ? (stackEntryNecessary0 ? 5920607 : 22619) : (stackEntryNecessary0 ? 22367 : (stackEntryPresent0 ? 88 : 87))) : (stackEntryPresent2 ? (stackEntryNecessary3 ? (stackEntryNecessary0 ? -1 : 5789531) : (stackEntryNecessary0 ? 5789531 : (stackEntryPresent0 ? 22360 : 88))) : (stackEntryNecessary3 ? (stackEntryNecessary0 ? 5855071 : 22367) : (stackEntryNecessary0 ? 22367 : (stackEntryPresent0 ? 88 : 87))))) : (stackEntryNecessary2 ? (stackEntryNecessary3 ? (stackEntryNecessary0 ? 90 : 95) : (stackEntryNecessary0 ? 0 : (stackEntryPresent0 ? 87 : 0))) : (stackEntryPresent2 ? (stackEntryNecessary3 ? (stackEntryNecessary0 ? 5855071 : 22367) : (stackEntryNecessary0 ? 22367 : (stackEntryPresent0 ? 88 : 87))) : (stackEntryNecessary3 ? (stackEntryNecessary0 ? 89 : 0) : (stackEntryNecessary0 ? 0 : (stackEntryPresent0 ? 87 : 0))))));
        }

        private int fixedDup2(int instructionOffset, int topBefore, int topAfter) {
            boolean stackEntryPresent0 = EvaluationShrinker.this.instructionUsageMarker.isStackEntryPresentBefore(instructionOffset, topBefore);
            boolean stackEntryPresent1 = EvaluationShrinker.this.instructionUsageMarker.isStackEntryPresentBefore(instructionOffset, topBefore - 1);
            boolean stackEntryNecessary0 = EvaluationShrinker.this.instructionUsageMarker.isStackEntryNecessaryAfter(instructionOffset, topAfter);
            boolean stackEntryNecessary1 = EvaluationShrinker.this.instructionUsageMarker.isStackEntryNecessaryAfter(instructionOffset, topAfter - 1);
            boolean stackEntryNecessary2 = EvaluationShrinker.this.instructionUsageMarker.isStackEntryNecessaryAfter(instructionOffset, topAfter - 2);
            boolean stackEntryNecessary3 = EvaluationShrinker.this.instructionUsageMarker.isStackEntryNecessaryAfter(instructionOffset, topAfter - 3);
            return stackEntryNecessary3 ? (stackEntryNecessary2 ? (stackEntryNecessary1 ? (stackEntryNecessary0 ? 92 : 23135) : (stackEntryNecessary0 ? 89 : 0)) : (stackEntryNecessary1 ? (stackEntryNecessary0 ? 0x5F5A5F : (stackEntryPresent0 ? 22871 : 89)) : (stackEntryNecessary0 ? 0 : (stackEntryPresent0 ? 87 : 0)))) : (stackEntryNecessary2 ? (stackEntryNecessary1 ? (stackEntryNecessary0 ? 90 : 95) : (stackEntryPresent1 ? (stackEntryNecessary0 ? 5855071 : 22367) : (stackEntryNecessary0 ? 87 : 0))) : (stackEntryNecessary1 ? (stackEntryNecessary0 ? 0 : (stackEntryPresent0 ? 87 : 0)) : (stackEntryPresent1 ? (stackEntryNecessary0 ? 22367 : (stackEntryPresent0 ? 88 : 87)) : (stackEntryNecessary0 ? 0 : (stackEntryPresent0 ? 87 : 0)))));
        }

        private int fixedDup2_x1(int instructionOffset, int topBefore, int topAfter) {
            boolean stackEntriesPresent01 = EvaluationShrinker.this.instructionUsageMarker.isStackEntriesPresentBefore(instructionOffset, topBefore, topBefore - 1);
            boolean stackEntryPresent2 = EvaluationShrinker.this.instructionUsageMarker.isStackEntryPresentBefore(instructionOffset, topBefore - 2);
            boolean stackEntriesNecessary01 = EvaluationShrinker.this.instructionUsageMarker.isStackEntriesNecessaryAfter(instructionOffset, topAfter, topAfter - 1);
            boolean stackEntryNecessary2 = EvaluationShrinker.this.instructionUsageMarker.isStackEntryNecessaryAfter(instructionOffset, topAfter - 2);
            boolean stackEntriesNecessary34 = EvaluationShrinker.this.instructionUsageMarker.isStackEntriesNecessaryAfter(instructionOffset, topAfter - 3, topAfter - 4);
            return stackEntryNecessary2 ? (stackEntriesNecessary34 ? (stackEntriesNecessary01 ? 93 : 22621) : (stackEntriesNecessary01 ? 0 : (stackEntriesPresent01 ? 88 : 0))) : (stackEntryPresent2 ? (stackEntriesNecessary34 ? (stackEntriesNecessary01 ? -1 : 5724253) : (stackEntriesNecessary01 ? 5724253 : (stackEntriesPresent01 ? 22360 : 87))) : (stackEntriesNecessary34 ? (stackEntriesNecessary01 ? 92 : 0) : (stackEntriesNecessary01 ? 0 : (stackEntriesPresent01 ? 88 : 0))));
        }

        private int fixedDup2_x2(int instructionOffset, int topBefore, int topAfter) {
            boolean stackEntriesPresent01 = EvaluationShrinker.this.instructionUsageMarker.isStackEntriesPresentBefore(instructionOffset, topBefore, topBefore - 1);
            boolean stackEntryPresent2 = EvaluationShrinker.this.instructionUsageMarker.isStackEntryPresentBefore(instructionOffset, topBefore - 2);
            boolean stackEntryPresent3 = EvaluationShrinker.this.instructionUsageMarker.isStackEntryPresentBefore(instructionOffset, topBefore - 3);
            boolean stackEntriesNecessary01 = EvaluationShrinker.this.instructionUsageMarker.isStackEntriesNecessaryAfter(instructionOffset, topAfter, topAfter - 1);
            boolean stackEntryNecessary2 = EvaluationShrinker.this.instructionUsageMarker.isStackEntryNecessaryAfter(instructionOffset, topAfter - 2);
            boolean stackEntryNecessary3 = EvaluationShrinker.this.instructionUsageMarker.isStackEntryNecessaryAfter(instructionOffset, topAfter - 3);
            boolean stackEntriesNecessary45 = EvaluationShrinker.this.instructionUsageMarker.isStackEntriesNecessaryAfter(instructionOffset, topAfter - 4, topAfter - 5);
            return stackEntryNecessary2 ? (stackEntryNecessary3 ? (stackEntriesNecessary45 ? (stackEntriesNecessary01 ? 94 : 22622) : (stackEntriesNecessary01 ? 0 : (stackEntriesPresent01 ? 88 : 0))) : (stackEntryPresent3 ? (stackEntriesNecessary45 ? (stackEntriesNecessary01 ? -1 : 5726046) : (stackEntriesNecessary01 ? -1 : (stackEntriesPresent01 ? 5726040 : 22367))) : (stackEntriesNecessary45 ? (stackEntriesNecessary01 ? 93 : 22621) : (stackEntriesNecessary01 ? 0 : (stackEntriesPresent01 ? 88 : 0))))) : (stackEntryPresent2 ? (stackEntryNecessary3 ? (stackEntriesNecessary45 ? (stackEntriesNecessary01 ? -1 : 5724254) : (stackEntriesNecessary01 ? 5724253 : (stackEntriesPresent01 ? 22360 : 87))) : (stackEntryPresent3 ? (stackEntriesNecessary45 ? (stackEntriesNecessary01 ? -1 : 0x58585E) : (stackEntriesNecessary01 ? 0x58585E : (stackEntriesPresent01 ? 22616 : 88))) : (stackEntriesNecessary45 ? (stackEntriesNecessary01 ? -1 : 5724253) : (stackEntriesNecessary01 ? 5724253 : (stackEntriesPresent01 ? 22360 : 87))))) : (stackEntryNecessary3 ? (stackEntriesNecessary45 ? (stackEntriesNecessary01 ? 93 : 22621) : (stackEntriesNecessary01 ? 0 : (stackEntriesPresent01 ? 88 : 0))) : (stackEntryPresent3 ? (stackEntriesNecessary45 ? (stackEntriesNecessary01 ? -1 : 5724253) : (stackEntriesNecessary01 ? 5724253 : (stackEntriesPresent01 ? 22360 : 87))) : (stackEntriesNecessary45 ? (stackEntriesNecessary01 ? 92 : 0) : (stackEntriesNecessary01 ? 0 : (stackEntriesPresent01 ? 88 : 0))))));
        }

        private int fixedSwap(int instructionOffset, int topBefore, int topAfter) {
            boolean stackEntryPresent0 = EvaluationShrinker.this.instructionUsageMarker.isStackEntryPresentBefore(instructionOffset, topBefore);
            boolean stackEntryPresent1 = EvaluationShrinker.this.instructionUsageMarker.isStackEntryPresentBefore(instructionOffset, topBefore - 1);
            boolean stackEntryNecessary0 = EvaluationShrinker.this.instructionUsageMarker.isStackEntryNecessaryAfter(instructionOffset, topAfter);
            boolean stackEntryNecessary1 = EvaluationShrinker.this.instructionUsageMarker.isStackEntryNecessaryAfter(instructionOffset, topAfter - 1);
            return stackEntryNecessary0 ? (stackEntryNecessary1 ? 95 : (stackEntryPresent0 ? 87 : 0)) : (stackEntryPresent1 ? 22367 : 0);
        }
    }

    private class MyNonReturningSubroutineFixer
    extends SimplifiedVisitor
    implements InstructionVisitor {
        private MyNonReturningSubroutineFixer() {
        }

        public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
        }

        public void visitBranchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, BranchInstruction branchInstruction) {
            if (branchInstruction.canonicalOpcode() == -88) {
                int nextOffset = offset + branchInstruction.length(offset);
                if (!EvaluationShrinker.this.instructionUsageMarker.isInstructionNecessary(nextOffset)) {
                    EvaluationShrinker.this.replaceByInfiniteLoop(clazz, nextOffset);
                }
            }
        }
    }

    private class MyBackwardBranchFixer
    extends SimplifiedVisitor
    implements InstructionVisitor {
        private MyBackwardBranchFixer() {
        }

        public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
            if (this.isAllSmallerThanOrEqual(EvaluationShrinker.this.instructionUsageMarker.branchTargets(offset), offset) && !EvaluationShrinker.this.isAnyUnnecessaryInstructionBranchingOver(this.lastNecessaryInstructionOffset(offset), offset)) {
                EvaluationShrinker.this.replaceByInfiniteLoop(clazz, offset);
            }
        }

        private boolean isAllSmallerThanOrEqual(InstructionOffsetValue instructionOffsets, int instructionOffset) {
            int branchCount;
            if (instructionOffsets != null && (branchCount = instructionOffsets.instructionOffsetCount()) > 0) {
                for (int branchIndex = 0; branchIndex < branchCount; ++branchIndex) {
                    if (instructionOffsets.instructionOffset(branchIndex) <= instructionOffset) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        private int lastNecessaryInstructionOffset(int instructionOffset) {
            for (int offset = instructionOffset - 1; offset >= 0; --offset) {
                if (!EvaluationShrinker.this.instructionUsageMarker.isInstructionNecessary(instructionOffset)) continue;
                return offset;
            }
            return 0;
        }
    }

    private class MyStaticInvocationFixer
    extends SimplifiedVisitor
    implements InstructionVisitor,
    ConstantVisitor,
    MemberVisitor {
        private int invocationOffset;
        private ConstantInstruction invocationInstruction;

        private MyStaticInvocationFixer() {
        }

        public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
        }

        public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, ConstantInstruction constantInstruction) {
            switch (constantInstruction.opcode) {
                case -74: 
                case -73: 
                case -71: {
                    this.invocationOffset = offset;
                    this.invocationInstruction = constantInstruction;
                    clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this);
                }
            }
        }

        public void visitAnyRefConstant(Clazz clazz, RefConstant refConstant) {
            refConstant.referencedMemberAccept(this);
        }

        public void visitAnyMember(Clazz clazz, Member member) {
        }

        public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
            if ((programMethod.getAccessFlags() & 8) == 0 && !ParameterUsageMarker.isParameterUsed(programMethod, 0)) {
                EvaluationShrinker.this.replaceByStaticInvocation(programClass, this.invocationOffset, this.invocationInstruction);
            }
        }
    }
}

