/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation.value;

import proguard.evaluation.value.Category1Value;
import proguard.evaluation.value.Value;

public class InstructionOffsetValue
extends Category1Value {
    private static final int[] EMPTY_OFFSETS = new int[0];
    public static final InstructionOffsetValue EMPTY_VALUE = new InstructionOffsetValue(EMPTY_OFFSETS);
    public static final int INSTRUCTION_OFFSET_MASK = 0x1FFFFFF;
    public static final int METHOD_PARAMETER = 0x1000000;
    public static final int METHOD_RETURN_VALUE = 0x2000000;
    public static final int FIELD_VALUE = 0x4000000;
    public static final int NEW_INSTANCE = 0x8000000;
    public static final int CAST = 0x10000000;
    public static final int EXCEPTION_HANDLER = 0x20000000;
    private int[] values;

    public InstructionOffsetValue(int value) {
        this.values = new int[]{value};
    }

    public InstructionOffsetValue(int[] values) {
        this.values = values;
    }

    public int instructionOffsetCount() {
        return this.values.length;
    }

    public int instructionOffset(int index) {
        return this.values[index] & 0x1FFFFFF;
    }

    public boolean contains(int value) {
        for (int index = 0; index < this.values.length; ++index) {
            if (this.values[index] != value) continue;
            return true;
        }
        return false;
    }

    public int minimumValue() {
        int minimumValue = Integer.MAX_VALUE;
        for (int index = 0; index < this.values.length; ++index) {
            int value = this.values[index] & 0x1FFFFFF;
            if (minimumValue <= value) continue;
            minimumValue = value;
        }
        return minimumValue;
    }

    public int maximumValue() {
        int maximumValue = Integer.MIN_VALUE;
        for (int index = 0; index < this.values.length; ++index) {
            int value = this.values[index] & 0x1FFFFFF;
            if (maximumValue >= value) continue;
            maximumValue = value;
        }
        return maximumValue;
    }

    public boolean isMethodParameter(int index) {
        return (this.values[index] & 0x1000000) != 0;
    }

    public int methodParameter(int index) {
        return this.values[index] & 0xFEFFFFFF;
    }

    public boolean isMethodReturnValue(int index) {
        return (this.values[index] & 0x2000000) != 0;
    }

    public boolean isFieldValue(int index) {
        return (this.values[index] & 0x4000000) != 0;
    }

    public boolean isNewinstance(int index) {
        return (this.values[index] & 0x8000000) != 0;
    }

    public boolean isCast(int index) {
        return (this.values[index] & 0x10000000) != 0;
    }

    public boolean isExceptionHandler(int index) {
        return (this.values[index] & 0x20000000) != 0;
    }

    public InstructionOffsetValue add(int value) {
        if (this.contains(value)) {
            return this;
        }
        int[] newValues = new int[this.values.length + 1];
        System.arraycopy(this.values, 0, newValues, 0, this.values.length);
        newValues[this.values.length] = value;
        return new InstructionOffsetValue(newValues);
    }

    public InstructionOffsetValue remove(int value) {
        for (int index = 0; index < this.values.length; ++index) {
            if (this.values[index] != value) continue;
            int[] newValues = new int[this.values.length - 1];
            System.arraycopy(this.values, 0, newValues, 0, index);
            System.arraycopy(this.values, index + 1, newValues, index, this.values.length - index - 1);
            return new InstructionOffsetValue(newValues);
        }
        return this;
    }

    public final InstructionOffsetValue generalize(InstructionOffsetValue other) {
        int[] thisValues = this.values;
        if (thisValues.length == 0) {
            return other;
        }
        int[] otherValues = other.values;
        if (otherValues.length == 0) {
            return this;
        }
        int newLength = thisValues.length;
        for (int index = 0; index < otherValues.length; ++index) {
            if (this.contains(otherValues[index])) continue;
            ++newLength;
        }
        if (newLength == otherValues.length) {
            return other;
        }
        if (newLength == this.values.length && otherValues.length == 1 && thisValues[thisValues.length - 1] == otherValues[0]) {
            return this;
        }
        int newIndex = 0;
        int[] newValues = new int[newLength];
        if (newLength == thisValues.length + otherValues.length) {
            System.arraycopy(thisValues, 0, newValues, 0, thisValues.length);
            newIndex = thisValues.length;
        } else {
            for (int index = 0; index < thisValues.length; ++index) {
                if (other.contains(thisValues[index])) continue;
                newValues[newIndex++] = thisValues[index];
            }
        }
        System.arraycopy(otherValues, 0, newValues, newIndex, otherValues.length);
        return new InstructionOffsetValue(newValues);
    }

    public final InstructionOffsetValue instructionOffsetValue() {
        return this;
    }

    public boolean isSpecific() {
        return true;
    }

    public boolean isParticular() {
        return true;
    }

    public final Value generalize(Value other) {
        return this.generalize(other.instructionOffsetValue());
    }

    public final int computationalType() {
        return 6;
    }

    public final String internalType() {
        return String.valueOf('I');
    }

    public boolean equals(Object object) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        InstructionOffsetValue other = (InstructionOffsetValue)object;
        if (this.values == other.values) {
            return true;
        }
        if (this.values == null || other.values == null || this.values.length != other.values.length) {
            return false;
        }
        for (int index = 0; index < other.values.length; ++index) {
            if (this.contains(other.values[index])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = this.getClass().hashCode();
        if (this.values != null) {
            for (int index = 0; index < this.values.length; ++index) {
                hashCode ^= this.values[index];
            }
        }
        return hashCode;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.values != null) {
            for (int index = 0; index < this.values.length; ++index) {
                if (index > 0) {
                    buffer.append(',');
                }
                if (this.values[index] < 0) {
                    buffer.append(this.values[index]);
                    continue;
                }
                if (this.isMethodParameter(index)) {
                    buffer.append('P');
                }
                if (this.isMethodReturnValue(index)) {
                    buffer.append('M');
                }
                if (this.isFieldValue(index)) {
                    buffer.append('F');
                }
                if (this.isNewinstance(index)) {
                    buffer.append('N');
                }
                if (this.isCast(index)) {
                    buffer.append('C');
                }
                if (this.isExceptionHandler(index)) {
                    buffer.append('E');
                }
                buffer.append(this.values[index] & 0xFFFF);
            }
        }
        return buffer.append(':').toString();
    }
}

