/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.info;

import proguard.classfile.LibraryClass;
import proguard.classfile.ProgramClass;
import proguard.classfile.visitor.ClassVisitor;
import proguard.optimize.info.SideEffectClassMarker;

public class SideEffectClassFilter
implements ClassVisitor {
    private final ClassVisitor classVisitor;

    public SideEffectClassFilter(ClassVisitor classVisitor) {
        this.classVisitor = classVisitor;
    }

    public void visitProgramClass(ProgramClass programClass) {
        if (SideEffectClassMarker.hasSideEffects(programClass)) {
            this.classVisitor.visitProgramClass(programClass);
        }
    }

    public void visitLibraryClass(LibraryClass libraryClass) {
        if (SideEffectClassMarker.hasSideEffects(libraryClass)) {
            this.classVisitor.visitLibraryClass(libraryClass);
        }
    }
}

