/*
 * Decompiled with CFR 0.152.
 */
package androidx.preference;

import android.content.Context;
import android.text.TextUtils;
import androidx.preference.Preference;
import androidx.preference.PreferenceGroup;
import androidx.preference.PreferenceViewHolder;
import androidx.preference.R;
import java.util.ArrayList;
import java.util.List;

final class ExpandButton
extends Preference {
    private long mId;

    ExpandButton(Context context, List<Preference> collapsedPreferences, long parentId) {
        super(context);
        this.initLayout();
        this.setSummary(collapsedPreferences);
        this.mId = parentId + 1000000L;
    }

    private void initLayout() {
        this.setLayoutResource(R.layout.expand_button);
        this.setIcon(R.drawable.ic_arrow_down_24dp);
        this.setTitle(R.string.expand_button_title);
        this.setOrder(999);
    }

    private void setSummary(List<Preference> collapsedPreferences) {
        CharSequence summary = null;
        ArrayList<PreferenceGroup> parents = new ArrayList<PreferenceGroup>();
        for (Preference preference : collapsedPreferences) {
            CharSequence title = preference.getTitle();
            if (preference instanceof PreferenceGroup && !TextUtils.isEmpty((CharSequence)title)) {
                parents.add((PreferenceGroup)preference);
            }
            if (parents.contains(preference.getParent())) {
                if (!(preference instanceof PreferenceGroup)) continue;
                parents.add((PreferenceGroup)preference);
                continue;
            }
            if (TextUtils.isEmpty((CharSequence)title)) continue;
            if (summary == null) {
                summary = title;
                continue;
            }
            summary = this.getContext().getString(R.string.summary_collapsed_preference_list, new Object[]{summary, title});
        }
        this.setSummary(summary);
    }

    @Override
    public void onBindViewHolder(PreferenceViewHolder holder) {
        super.onBindViewHolder(holder);
        holder.setDividerAllowedAbove(false);
    }

    @Override
    long getId() {
        return this.mId;
    }
}

