/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CaptureFailure;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.TotalCaptureResult;
import android.hardware.camera2.params.OutputConfiguration;
import android.os.Handler;
import android.view.Surface;
import java.util.List;
import java.util.concurrent.Executor;

public abstract class CameraCaptureSession
implements AutoCloseable {
    @NonNull
    public abstract CameraDevice getDevice();

    public abstract void prepare(@NonNull Surface var1) throws CameraAccessException;

    public abstract void finalizeOutputConfigurations(List<OutputConfiguration> var1) throws CameraAccessException;

    public abstract int capture(@NonNull CaptureRequest var1, @Nullable CaptureCallback var2, @Nullable Handler var3) throws CameraAccessException;

    public int captureSingleRequest(@NonNull CaptureRequest request, @NonNull Executor executor, @NonNull CaptureCallback listener) throws CameraAccessException {
        throw new RuntimeException("Method captureSingleRequest in android.hardware.camera2.CameraCaptureSession not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    public abstract int captureBurst(@NonNull List<CaptureRequest> var1, @Nullable CaptureCallback var2, @Nullable Handler var3) throws CameraAccessException;

    public int captureBurstRequests(@NonNull List<CaptureRequest> requests, @NonNull Executor executor, @NonNull CaptureCallback listener) throws CameraAccessException {
        throw new RuntimeException("Method captureBurstRequests in android.hardware.camera2.CameraCaptureSession not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    public abstract int setRepeatingRequest(@NonNull CaptureRequest var1, @Nullable CaptureCallback var2, @Nullable Handler var3) throws CameraAccessException;

    public int setSingleRepeatingRequest(@NonNull CaptureRequest request, @NonNull Executor executor, @NonNull CaptureCallback listener) throws CameraAccessException {
        throw new RuntimeException("Method setSingleRepeatingRequest in android.hardware.camera2.CameraCaptureSession not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    public abstract int setRepeatingBurst(@NonNull List<CaptureRequest> var1, @Nullable CaptureCallback var2, @Nullable Handler var3) throws CameraAccessException;

    public int setRepeatingBurstRequests(@NonNull List<CaptureRequest> requests, @NonNull Executor executor, @NonNull CaptureCallback listener) throws CameraAccessException {
        throw new RuntimeException("Method setRepeatingBurstRequests in android.hardware.camera2.CameraCaptureSession not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    public abstract void stopRepeating() throws CameraAccessException;

    public abstract void abortCaptures() throws CameraAccessException;

    public abstract boolean isReprocessable();

    @Nullable
    public abstract Surface getInputSurface();

    public void updateOutputConfiguration(OutputConfiguration config) throws CameraAccessException {
        throw new RuntimeException("Method updateOutputConfiguration in android.hardware.camera2.CameraCaptureSession not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    @Override
    public abstract void close();

    public static abstract class StateCallback {
        public abstract void onConfigured(@NonNull CameraCaptureSession var1);

        public abstract void onConfigureFailed(@NonNull CameraCaptureSession var1);

        public void onReady(@NonNull CameraCaptureSession session) {
            throw new RuntimeException("Method onReady in android.hardware.camera2.CameraCaptureSession$StateCallback not mocked. See http://g.co/androidstudio/not-mocked for details.");
        }

        public void onActive(@NonNull CameraCaptureSession session) {
            throw new RuntimeException("Method onActive in android.hardware.camera2.CameraCaptureSession$StateCallback not mocked. See http://g.co/androidstudio/not-mocked for details.");
        }

        public void onCaptureQueueEmpty(@NonNull CameraCaptureSession session) {
            throw new RuntimeException("Method onCaptureQueueEmpty in android.hardware.camera2.CameraCaptureSession$StateCallback not mocked. See http://g.co/androidstudio/not-mocked for details.");
        }

        public void onClosed(@NonNull CameraCaptureSession session) {
            throw new RuntimeException("Method onClosed in android.hardware.camera2.CameraCaptureSession$StateCallback not mocked. See http://g.co/androidstudio/not-mocked for details.");
        }

        public void onSurfacePrepared(@NonNull CameraCaptureSession session, @NonNull Surface surface) {
            throw new RuntimeException("Method onSurfacePrepared in android.hardware.camera2.CameraCaptureSession$StateCallback not mocked. See http://g.co/androidstudio/not-mocked for details.");
        }
    }

    public static abstract class CaptureCallback {
        public void onCaptureStarted(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, long timestamp, long frameNumber) {
            throw new RuntimeException("Method onCaptureStarted in android.hardware.camera2.CameraCaptureSession$CaptureCallback not mocked. See http://g.co/androidstudio/not-mocked for details.");
        }

        public void onCaptureProgressed(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, @NonNull CaptureResult partialResult) {
            throw new RuntimeException("Method onCaptureProgressed in android.hardware.camera2.CameraCaptureSession$CaptureCallback not mocked. See http://g.co/androidstudio/not-mocked for details.");
        }

        public void onCaptureCompleted(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, @NonNull TotalCaptureResult result) {
            throw new RuntimeException("Method onCaptureCompleted in android.hardware.camera2.CameraCaptureSession$CaptureCallback not mocked. See http://g.co/androidstudio/not-mocked for details.");
        }

        public void onCaptureFailed(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, @NonNull CaptureFailure failure) {
            throw new RuntimeException("Method onCaptureFailed in android.hardware.camera2.CameraCaptureSession$CaptureCallback not mocked. See http://g.co/androidstudio/not-mocked for details.");
        }

        public void onCaptureSequenceCompleted(@NonNull CameraCaptureSession session, int sequenceId, long frameNumber) {
            throw new RuntimeException("Method onCaptureSequenceCompleted in android.hardware.camera2.CameraCaptureSession$CaptureCallback not mocked. See http://g.co/androidstudio/not-mocked for details.");
        }

        public void onCaptureSequenceAborted(@NonNull CameraCaptureSession session, int sequenceId) {
            throw new RuntimeException("Method onCaptureSequenceAborted in android.hardware.camera2.CameraCaptureSession$CaptureCallback not mocked. See http://g.co/androidstudio/not-mocked for details.");
        }

        public void onCaptureBufferLost(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, @NonNull Surface target, long frameNumber) {
            throw new RuntimeException("Method onCaptureBufferLost in android.hardware.camera2.CameraCaptureSession$CaptureCallback not mocked. See http://g.co/androidstudio/not-mocked for details.");
        }
    }
}

