/*
 * Decompiled with CFR 0.152.
 */
package androidx.preference;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.widget.TextView;
import androidx.annotation.RestrictTo;
import androidx.preference.Preference;
import androidx.preference.PreferenceViewHolder;

public abstract class TwoStatePreference
extends Preference {
    protected boolean mChecked;
    private CharSequence mSummaryOn;
    private CharSequence mSummaryOff;
    private boolean mCheckedSet;
    private boolean mDisableDependentsState;

    public TwoStatePreference(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    public TwoStatePreference(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public TwoStatePreference(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public TwoStatePreference(Context context) {
        this(context, null);
    }

    @Override
    protected void onClick() {
        boolean newValue;
        super.onClick();
        boolean bl = newValue = !this.isChecked();
        if (this.callChangeListener(newValue)) {
            this.setChecked(newValue);
        }
    }

    public boolean isChecked() {
        return this.mChecked;
    }

    public void setChecked(boolean checked) {
        boolean changed;
        boolean bl = changed = this.mChecked != checked;
        if (changed || !this.mCheckedSet) {
            this.mChecked = checked;
            this.mCheckedSet = true;
            this.persistBoolean(checked);
            if (changed) {
                this.notifyDependencyChange(this.shouldDisableDependents());
                this.notifyChanged();
            }
        }
    }

    @Override
    public boolean shouldDisableDependents() {
        boolean shouldDisable = this.mDisableDependentsState ? this.mChecked : !this.mChecked;
        return shouldDisable || super.shouldDisableDependents();
    }

    public void setSummaryOn(CharSequence summary) {
        this.mSummaryOn = summary;
        if (this.isChecked()) {
            this.notifyChanged();
        }
    }

    public CharSequence getSummaryOn() {
        return this.mSummaryOn;
    }

    public void setSummaryOn(int summaryResId) {
        this.setSummaryOn(this.getContext().getString(summaryResId));
    }

    public void setSummaryOff(CharSequence summary) {
        this.mSummaryOff = summary;
        if (!this.isChecked()) {
            this.notifyChanged();
        }
    }

    public CharSequence getSummaryOff() {
        return this.mSummaryOff;
    }

    public void setSummaryOff(int summaryResId) {
        this.setSummaryOff(this.getContext().getString(summaryResId));
    }

    public boolean getDisableDependentsState() {
        return this.mDisableDependentsState;
    }

    public void setDisableDependentsState(boolean disableDependentsState) {
        this.mDisableDependentsState = disableDependentsState;
    }

    @Override
    protected Object onGetDefaultValue(TypedArray a, int index) {
        return a.getBoolean(index, false);
    }

    @Override
    protected void onSetInitialValue(Object defaultValue) {
        if (defaultValue == null) {
            defaultValue = false;
        }
        this.setChecked(this.getPersistedBoolean((Boolean)defaultValue));
    }

    protected void syncSummaryView(PreferenceViewHolder holder) {
        View view = holder.findViewById(0x1020010);
        this.syncSummaryView(view);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    protected void syncSummaryView(View view) {
        CharSequence summary;
        if (!(view instanceof TextView)) {
            return;
        }
        TextView summaryView = (TextView)view;
        boolean useDefaultSummary = true;
        if (this.mChecked && !TextUtils.isEmpty((CharSequence)this.mSummaryOn)) {
            summaryView.setText(this.mSummaryOn);
            useDefaultSummary = false;
        } else if (!this.mChecked && !TextUtils.isEmpty((CharSequence)this.mSummaryOff)) {
            summaryView.setText(this.mSummaryOff);
            useDefaultSummary = false;
        }
        if (useDefaultSummary && !TextUtils.isEmpty((CharSequence)(summary = this.getSummary()))) {
            summaryView.setText(summary);
            useDefaultSummary = false;
        }
        int newVisibility = 8;
        if (!useDefaultSummary) {
            newVisibility = 0;
        }
        if (newVisibility != summaryView.getVisibility()) {
            summaryView.setVisibility(newVisibility);
        }
    }

    @Override
    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        if (this.isPersistent()) {
            return superState;
        }
        SavedState myState = new SavedState(superState);
        myState.mChecked = this.isChecked();
        return myState;
    }

    @Override
    protected void onRestoreInstanceState(Parcelable state) {
        if (state == null || !state.getClass().equals(SavedState.class)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState myState = (SavedState)state;
        super.onRestoreInstanceState(myState.getSuperState());
        this.setChecked(myState.mChecked);
    }

    static class SavedState
    extends Preference.BaseSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };
        boolean mChecked;

        SavedState(Parcel source) {
            super(source);
            this.mChecked = source.readInt() == 1;
        }

        SavedState(Parcelable superState) {
            super(superState);
        }

        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.mChecked ? 1 : 0);
        }
    }
}

