/*
 * Decompiled with CFR 0.152.
 */
package androidx.media;

import android.annotation.TargetApi;
import android.media.AudioAttributes;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.media.AudioAttributesCompat;
import androidx.media.AudioAttributesImpl;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

@TargetApi(value=21)
class AudioAttributesImplApi21
implements AudioAttributesImpl {
    private static final String TAG = "AudioAttributesCompat21";
    AudioAttributes mAudioAttributes;
    int mLegacyStreamType = -1;
    static Method sAudioAttributesToLegacyStreamType;

    AudioAttributesImplApi21() {
    }

    AudioAttributesImplApi21(AudioAttributes audioAttributes) {
        this(audioAttributes, -1);
    }

    AudioAttributesImplApi21(AudioAttributes audioAttributes, int explicitLegacyStream) {
        this.mAudioAttributes = audioAttributes;
        this.mLegacyStreamType = explicitLegacyStream;
    }

    static Method getAudioAttributesToLegacyStreamTypeMethod() {
        try {
            if (sAudioAttributesToLegacyStreamType == null) {
                sAudioAttributesToLegacyStreamType = AudioAttributes.class.getMethod("toLegacyStreamType", AudioAttributes.class);
            }
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        return sAudioAttributesToLegacyStreamType;
    }

    @Override
    public Object getAudioAttributes() {
        return this.mAudioAttributes;
    }

    @Override
    public int getVolumeControlStream() {
        if (Build.VERSION.SDK_INT >= 26) {
            return this.mAudioAttributes.getVolumeControlStream();
        }
        return AudioAttributesCompat.toVolumeStreamType(true, this.getFlags(), this.getUsage());
    }

    @Override
    public int getLegacyStreamType() {
        if (this.mLegacyStreamType != -1) {
            return this.mLegacyStreamType;
        }
        Method frameworkMethod = AudioAttributesImplApi21.getAudioAttributesToLegacyStreamTypeMethod();
        if (frameworkMethod == null) {
            Log.w((String)TAG, (String)("No AudioAttributes#toLegacyStreamType() on API: " + Build.VERSION.SDK_INT));
            return -1;
        }
        try {
            Object result = frameworkMethod.invoke(null, this.mAudioAttributes);
            return (Integer)result;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            Log.w((String)TAG, (String)("getLegacyStreamType() failed on API: " + Build.VERSION.SDK_INT), (Throwable)e);
            return -1;
        }
    }

    @Override
    public int getRawLegacyStreamType() {
        return this.mLegacyStreamType;
    }

    @Override
    public int getContentType() {
        return this.mAudioAttributes.getContentType();
    }

    @Override
    public int getUsage() {
        return this.mAudioAttributes.getUsage();
    }

    @Override
    public int getFlags() {
        return this.mAudioAttributes.getFlags();
    }

    @Override
    @NonNull
    public Bundle toBundle() {
        Bundle bundle = new Bundle();
        bundle.putParcelable("androidx.media.audio_attrs.FRAMEWORKS", (Parcelable)this.mAudioAttributes);
        if (this.mLegacyStreamType != -1) {
            bundle.putInt("androidx.media.audio_attrs.LEGACY_STREAM_TYPE", this.mLegacyStreamType);
        }
        return bundle;
    }

    public int hashCode() {
        return this.mAudioAttributes.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof AudioAttributesImplApi21)) {
            return false;
        }
        AudioAttributesImplApi21 that = (AudioAttributesImplApi21)o;
        return this.mAudioAttributes.equals((Object)that.mAudioAttributes);
    }

    public String toString() {
        return "AudioAttributesCompat: audioattributes=" + this.mAudioAttributes;
    }

    public static AudioAttributesImpl fromBundle(Bundle bundle) {
        if (bundle == null) {
            return null;
        }
        AudioAttributes frameworkAttrs = (AudioAttributes)bundle.getParcelable("androidx.media.audio_attrs.FRAMEWORKS");
        if (frameworkAttrs == null) {
            return null;
        }
        int legacyStream = bundle.getInt("androidx.media.audio_attrs.LEGACY_STREAM_TYPE", -1);
        return new AudioAttributesImplApi21(frameworkAttrs, legacyStream);
    }
}

