/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.bottomnavigation;

import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.Dimension;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.StyleRes;
import androidx.appcompat.R;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.appcompat.view.menu.MenuBuilder;
import androidx.appcompat.view.menu.MenuItemImpl;
import androidx.appcompat.view.menu.MenuPresenter;
import androidx.appcompat.view.menu.MenuView;
import androidx.core.util.Pools;
import androidx.core.view.ViewCompat;
import androidx.interpolator.view.animation.FastOutSlowInInterpolator;
import androidx.transition.AutoTransition;
import androidx.transition.Transition;
import androidx.transition.TransitionManager;
import androidx.transition.TransitionSet;
import com.google.android.material.R;
import com.google.android.material.bottomnavigation.BottomNavigationItemView;
import com.google.android.material.bottomnavigation.BottomNavigationPresenter;
import com.google.android.material.internal.TextScale;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class BottomNavigationMenuView
extends ViewGroup
implements MenuView {
    private static final long ACTIVE_ANIMATION_DURATION_MS = 115L;
    private static final int[] CHECKED_STATE_SET = new int[]{0x10100A0};
    private static final int[] DISABLED_STATE_SET = new int[]{-16842910};
    private final TransitionSet set;
    private final int inactiveItemMaxWidth;
    private final int inactiveItemMinWidth;
    private final int activeItemMaxWidth;
    private final int activeItemMinWidth;
    private final int itemHeight;
    private final View.OnClickListener onClickListener;
    private final Pools.Pool<BottomNavigationItemView> itemPool = new Pools.SynchronizedPool(5);
    private boolean itemHorizontalTranslationEnabled;
    private int labelVisibilityMode;
    private BottomNavigationItemView[] buttons;
    private int selectedItemId = 0;
    private int selectedItemPosition = 0;
    private ColorStateList itemIconTint;
    @Dimension
    private int itemIconSize;
    private ColorStateList itemTextColorFromUser;
    private final ColorStateList itemTextColorDefault;
    @StyleRes
    private int itemTextAppearanceInactive;
    @StyleRes
    private int itemTextAppearanceActive;
    private Drawable itemBackground;
    private int itemBackgroundRes;
    private int[] tempChildWidths;
    private BottomNavigationPresenter presenter;
    private MenuBuilder menu;

    public BottomNavigationMenuView(Context context) {
        this(context, null);
    }

    public BottomNavigationMenuView(Context context, AttributeSet attrs) {
        super(context, attrs);
        Resources res = this.getResources();
        this.inactiveItemMaxWidth = res.getDimensionPixelSize(R.dimen.design_bottom_navigation_item_max_width);
        this.inactiveItemMinWidth = res.getDimensionPixelSize(R.dimen.design_bottom_navigation_item_min_width);
        this.activeItemMaxWidth = res.getDimensionPixelSize(R.dimen.design_bottom_navigation_active_item_max_width);
        this.activeItemMinWidth = res.getDimensionPixelSize(R.dimen.design_bottom_navigation_active_item_min_width);
        this.itemHeight = res.getDimensionPixelSize(R.dimen.design_bottom_navigation_height);
        this.itemTextColorDefault = this.createDefaultColorStateList(16842808);
        this.set = new AutoTransition();
        this.set.setOrdering(0);
        this.set.setDuration(115L);
        this.set.setInterpolator((TimeInterpolator)new FastOutSlowInInterpolator());
        this.set.addTransition((Transition)new TextScale());
        this.onClickListener = new View.OnClickListener(){

            public void onClick(View v) {
                BottomNavigationItemView itemView = (BottomNavigationItemView)v;
                MenuItemImpl item = itemView.getItemData();
                if (!BottomNavigationMenuView.this.menu.performItemAction((MenuItem)item, (MenuPresenter)BottomNavigationMenuView.this.presenter, 0)) {
                    item.setChecked(true);
                }
            }
        };
        this.tempChildWidths = new int[5];
    }

    public void initialize(MenuBuilder menu) {
        this.menu = menu;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int visibleCount = this.menu.getVisibleItems().size();
        int totalCount = this.getChildCount();
        int heightSpec = View.MeasureSpec.makeMeasureSpec((int)this.itemHeight, (int)0x40000000);
        if (this.isShifting(this.labelVisibilityMode, visibleCount) && this.itemHorizontalTranslationEnabled) {
            View activeChild = this.getChildAt(this.selectedItemPosition);
            int activeItemWidth = this.activeItemMinWidth;
            if (activeChild.getVisibility() != 8) {
                activeChild.measure(View.MeasureSpec.makeMeasureSpec((int)this.activeItemMaxWidth, (int)Integer.MIN_VALUE), heightSpec);
                activeItemWidth = Math.max(activeItemWidth, activeChild.getMeasuredWidth());
            }
            int inactiveCount = visibleCount - (activeChild.getVisibility() != 8 ? 1 : 0);
            int activeMaxAvailable = width - inactiveCount * this.inactiveItemMinWidth;
            int activeWidth = Math.min(activeMaxAvailable, Math.min(activeItemWidth, this.activeItemMaxWidth));
            int inactiveMaxAvailable = (width - activeWidth) / (inactiveCount == 0 ? 1 : inactiveCount);
            int inactiveWidth = Math.min(inactiveMaxAvailable, this.inactiveItemMaxWidth);
            int extra = width - activeWidth - inactiveWidth * inactiveCount;
            for (int i = 0; i < totalCount; ++i) {
                if (this.getChildAt(i).getVisibility() != 8) {
                    int n = this.tempChildWidths[i] = i == this.selectedItemPosition ? activeWidth : inactiveWidth;
                    if (extra <= 0) continue;
                    int n2 = i;
                    this.tempChildWidths[n2] = this.tempChildWidths[n2] + 1;
                    --extra;
                    continue;
                }
                this.tempChildWidths[i] = 0;
            }
        } else {
            int maxAvailable = width / (visibleCount == 0 ? 1 : visibleCount);
            int childWidth = Math.min(maxAvailable, this.activeItemMaxWidth);
            int extra = width - childWidth * visibleCount;
            for (int i = 0; i < totalCount; ++i) {
                if (this.getChildAt(i).getVisibility() != 8) {
                    this.tempChildWidths[i] = childWidth;
                    if (extra <= 0) continue;
                    int n = i;
                    this.tempChildWidths[n] = this.tempChildWidths[n] + 1;
                    --extra;
                    continue;
                }
                this.tempChildWidths[i] = 0;
            }
        }
        int totalWidth = 0;
        for (int i = 0; i < totalCount; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            child.measure(View.MeasureSpec.makeMeasureSpec((int)this.tempChildWidths[i], (int)0x40000000), heightSpec);
            ViewGroup.LayoutParams params = child.getLayoutParams();
            params.width = child.getMeasuredWidth();
            totalWidth += child.getMeasuredWidth();
        }
        this.setMeasuredDimension(View.resolveSizeAndState((int)totalWidth, (int)View.MeasureSpec.makeMeasureSpec((int)totalWidth, (int)0x40000000), (int)0), View.resolveSizeAndState((int)this.itemHeight, (int)heightSpec, (int)0));
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        int count = this.getChildCount();
        int width = right - left;
        int height = bottom - top;
        int used = 0;
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            if (ViewCompat.getLayoutDirection((View)this) == 1) {
                child.layout(width - used - child.getMeasuredWidth(), 0, width - used, height);
            } else {
                child.layout(used, 0, child.getMeasuredWidth() + used, height);
            }
            used += child.getMeasuredWidth();
        }
    }

    public int getWindowAnimations() {
        return 0;
    }

    public void setIconTintList(ColorStateList tint) {
        this.itemIconTint = tint;
        if (this.buttons != null) {
            for (BottomNavigationItemView item : this.buttons) {
                item.setIconTintList(tint);
            }
        }
    }

    @Nullable
    public ColorStateList getIconTintList() {
        return this.itemIconTint;
    }

    public void setItemIconSize(@Dimension int iconSize) {
        this.itemIconSize = iconSize;
        if (this.buttons != null) {
            for (BottomNavigationItemView item : this.buttons) {
                item.setIconSize(iconSize);
            }
        }
    }

    @Dimension
    public int getItemIconSize() {
        return this.itemIconSize;
    }

    public void setItemTextColor(ColorStateList color) {
        this.itemTextColorFromUser = color;
        if (this.buttons != null) {
            for (BottomNavigationItemView item : this.buttons) {
                item.setTextColor(color);
            }
        }
    }

    public ColorStateList getItemTextColor() {
        return this.itemTextColorFromUser;
    }

    public void setItemTextAppearanceInactive(@StyleRes int textAppearanceRes) {
        this.itemTextAppearanceInactive = textAppearanceRes;
        if (this.buttons != null) {
            for (BottomNavigationItemView item : this.buttons) {
                item.setTextAppearanceInactive(textAppearanceRes);
                if (this.itemTextColorFromUser == null) continue;
                item.setTextColor(this.itemTextColorFromUser);
            }
        }
    }

    @StyleRes
    public int getItemTextAppearanceInactive() {
        return this.itemTextAppearanceInactive;
    }

    public void setItemTextAppearanceActive(@StyleRes int textAppearanceRes) {
        this.itemTextAppearanceActive = textAppearanceRes;
        if (this.buttons != null) {
            for (BottomNavigationItemView item : this.buttons) {
                item.setTextAppearanceActive(textAppearanceRes);
                if (this.itemTextColorFromUser == null) continue;
                item.setTextColor(this.itemTextColorFromUser);
            }
        }
    }

    @StyleRes
    public int getItemTextAppearanceActive() {
        return this.itemTextAppearanceActive;
    }

    public void setItemBackgroundRes(int background) {
        this.itemBackgroundRes = background;
        if (this.buttons != null) {
            for (BottomNavigationItemView item : this.buttons) {
                item.setItemBackground(background);
            }
        }
    }

    @Deprecated
    public int getItemBackgroundRes() {
        return this.itemBackgroundRes;
    }

    public void setItemBackground(@Nullable Drawable background) {
        this.itemBackground = background;
        if (this.buttons != null) {
            for (BottomNavigationItemView item : this.buttons) {
                item.setItemBackground(background);
            }
        }
    }

    @Nullable
    public Drawable getItemBackground() {
        if (this.buttons != null && this.buttons.length > 0) {
            return this.buttons[0].getBackground();
        }
        return this.itemBackground;
    }

    public void setLabelVisibilityMode(int labelVisibilityMode) {
        this.labelVisibilityMode = labelVisibilityMode;
    }

    public int getLabelVisibilityMode() {
        return this.labelVisibilityMode;
    }

    public void setItemHorizontalTranslationEnabled(boolean itemHorizontalTranslationEnabled) {
        this.itemHorizontalTranslationEnabled = itemHorizontalTranslationEnabled;
    }

    public boolean isItemHorizontalTranslationEnabled() {
        return this.itemHorizontalTranslationEnabled;
    }

    public ColorStateList createDefaultColorStateList(int baseColorThemeAttr) {
        TypedValue value = new TypedValue();
        if (!this.getContext().getTheme().resolveAttribute(baseColorThemeAttr, value, true)) {
            return null;
        }
        ColorStateList baseColor = AppCompatResources.getColorStateList((Context)this.getContext(), (int)value.resourceId);
        if (!this.getContext().getTheme().resolveAttribute(R.attr.colorPrimary, value, true)) {
            return null;
        }
        int colorPrimary = value.data;
        int defaultColor = baseColor.getDefaultColor();
        return new ColorStateList((int[][])new int[][]{DISABLED_STATE_SET, CHECKED_STATE_SET, EMPTY_STATE_SET}, new int[]{baseColor.getColorForState(DISABLED_STATE_SET, defaultColor), colorPrimary, defaultColor});
    }

    public void setPresenter(BottomNavigationPresenter presenter) {
        this.presenter = presenter;
    }

    public void buildMenuView() {
        this.removeAllViews();
        if (this.buttons != null) {
            for (BottomNavigationItemView item : this.buttons) {
                if (item == null) continue;
                this.itemPool.release((Object)item);
            }
        }
        if (this.menu.size() == 0) {
            this.selectedItemId = 0;
            this.selectedItemPosition = 0;
            this.buttons = null;
            return;
        }
        this.buttons = new BottomNavigationItemView[this.menu.size()];
        boolean shifting = this.isShifting(this.labelVisibilityMode, this.menu.getVisibleItems().size());
        for (int i = 0; i < this.menu.size(); ++i) {
            BottomNavigationItemView child;
            this.presenter.setUpdateSuspended(true);
            this.menu.getItem(i).setCheckable(true);
            this.presenter.setUpdateSuspended(false);
            this.buttons[i] = child = this.getNewItem();
            child.setIconTintList(this.itemIconTint);
            child.setIconSize(this.itemIconSize);
            child.setTextColor(this.itemTextColorDefault);
            child.setTextAppearanceInactive(this.itemTextAppearanceInactive);
            child.setTextAppearanceActive(this.itemTextAppearanceActive);
            child.setTextColor(this.itemTextColorFromUser);
            if (this.itemBackground != null) {
                child.setItemBackground(this.itemBackground);
            } else {
                child.setItemBackground(this.itemBackgroundRes);
            }
            child.setShifting(shifting);
            child.setLabelVisibilityMode(this.labelVisibilityMode);
            child.initialize((MenuItemImpl)this.menu.getItem(i), 0);
            child.setItemPosition(i);
            child.setOnClickListener(this.onClickListener);
            this.addView((View)child);
        }
        this.selectedItemPosition = Math.min(this.menu.size() - 1, this.selectedItemPosition);
        this.menu.getItem(this.selectedItemPosition).setChecked(true);
    }

    public void updateMenuView() {
        if (this.menu == null || this.buttons == null) {
            return;
        }
        int menuSize = this.menu.size();
        if (menuSize != this.buttons.length) {
            this.buildMenuView();
            return;
        }
        int previousSelectedId = this.selectedItemId;
        for (int i = 0; i < menuSize; ++i) {
            MenuItem item = this.menu.getItem(i);
            if (!item.isChecked()) continue;
            this.selectedItemId = item.getItemId();
            this.selectedItemPosition = i;
        }
        if (previousSelectedId != this.selectedItemId) {
            TransitionManager.beginDelayedTransition((ViewGroup)this, (Transition)this.set);
        }
        boolean shifting = this.isShifting(this.labelVisibilityMode, this.menu.getVisibleItems().size());
        for (int i = 0; i < menuSize; ++i) {
            this.presenter.setUpdateSuspended(true);
            this.buttons[i].setLabelVisibilityMode(this.labelVisibilityMode);
            this.buttons[i].setShifting(shifting);
            this.buttons[i].initialize((MenuItemImpl)this.menu.getItem(i), 0);
            this.presenter.setUpdateSuspended(false);
        }
    }

    private BottomNavigationItemView getNewItem() {
        BottomNavigationItemView item = (BottomNavigationItemView)((Object)this.itemPool.acquire());
        if (item == null) {
            item = new BottomNavigationItemView(this.getContext());
        }
        return item;
    }

    public int getSelectedItemId() {
        return this.selectedItemId;
    }

    private boolean isShifting(int labelVisibilityMode, int childCount) {
        return labelVisibilityMode == -1 ? childCount > 3 : labelVisibilityMode == 0;
    }

    void tryRestoreSelectedItemId(int itemId) {
        int size = this.menu.size();
        for (int i = 0; i < size; ++i) {
            MenuItem item = this.menu.getItem(i);
            if (itemId != item.getItemId()) continue;
            this.selectedItemId = itemId;
            this.selectedItemPosition = i;
            item.setChecked(true);
            break;
        }
    }
}

