/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.circularreveal;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.os.Build;
import android.view.View;
import android.view.ViewAnimationUtils;
import com.google.android.material.circularreveal.CircularRevealWidget;

public final class CircularRevealCompat {
    private CircularRevealCompat() {
    }

    public static Animator createCircularReveal(CircularRevealWidget view, float centerX, float centerY, float endRadius) {
        ObjectAnimator revealInfoAnimator = ObjectAnimator.ofObject((Object)view, CircularRevealWidget.CircularRevealProperty.CIRCULAR_REVEAL, CircularRevealWidget.CircularRevealEvaluator.CIRCULAR_REVEAL, (Object[])new CircularRevealWidget.RevealInfo[]{new CircularRevealWidget.RevealInfo(centerX, centerY, endRadius)});
        if (Build.VERSION.SDK_INT >= 21) {
            CircularRevealWidget.RevealInfo revealInfo = view.getRevealInfo();
            if (revealInfo == null) {
                throw new IllegalStateException("Caller must set a non-null RevealInfo before calling this.");
            }
            float startRadius = revealInfo.radius;
            Animator circularRevealAnimator = ViewAnimationUtils.createCircularReveal((View)((View)view), (int)((int)centerX), (int)((int)centerY), (float)startRadius, (float)endRadius);
            AnimatorSet set = new AnimatorSet();
            set.playTogether(new Animator[]{revealInfoAnimator, circularRevealAnimator});
            return set;
        }
        return revealInfoAnimator;
    }

    public static Animator createCircularReveal(CircularRevealWidget view, float centerX, float centerY, float startRadius, float endRadius) {
        ObjectAnimator revealInfoAnimator = ObjectAnimator.ofObject((Object)view, CircularRevealWidget.CircularRevealProperty.CIRCULAR_REVEAL, CircularRevealWidget.CircularRevealEvaluator.CIRCULAR_REVEAL, (Object[])new CircularRevealWidget.RevealInfo[]{new CircularRevealWidget.RevealInfo(centerX, centerY, startRadius), new CircularRevealWidget.RevealInfo(centerX, centerY, endRadius)});
        if (Build.VERSION.SDK_INT >= 21) {
            Animator circularRevealAnimator = ViewAnimationUtils.createCircularReveal((View)((View)view), (int)((int)centerX), (int)((int)centerY), (float)startRadius, (float)endRadius);
            AnimatorSet set = new AnimatorSet();
            set.playTogether(new Animator[]{revealInfoAnimator, circularRevealAnimator});
            return set;
        }
        return revealInfoAnimator;
    }

    public static Animator.AnimatorListener createCircularRevealListener(final CircularRevealWidget view) {
        return new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                view.buildCircularRevealCache();
            }

            public void onAnimationEnd(Animator animation) {
                view.destroyCircularRevealCache();
            }
        };
    }
}

