/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso;

import androidx.test.espresso.IdlingPolicy;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import java.util.concurrent.TimeUnit;

public final class IdlingPolicies {
    private static volatile IdlingPolicy masterIdlingPolicy = new IdlingPolicy.Builder().withIdlingTimeout(60L).withIdlingTimeoutUnit(TimeUnit.SECONDS).throwAppNotIdleException().build();
    private static volatile IdlingPolicy dynamicIdlingResourceErrorPolicy = new IdlingPolicy.Builder().withIdlingTimeout(26L).withIdlingTimeoutUnit(TimeUnit.SECONDS).throwIdlingResourceTimeoutException().build();
    private static volatile IdlingPolicy dynamicIdlingResourceWarningPolicy = new IdlingPolicy.Builder().withIdlingTimeout(5L).withIdlingTimeoutUnit(TimeUnit.SECONDS).logWarning().build();

    private IdlingPolicies() {
    }

    public static void setMasterPolicyTimeout(long l, TimeUnit timeUnit) {
        Preconditions.checkArgument(l > 0L);
        Preconditions.checkNotNull(timeUnit);
        masterIdlingPolicy = masterIdlingPolicy.toBuilder().withIdlingTimeout(l).withIdlingTimeoutUnit(timeUnit).build();
    }

    public static void setIdlingResourceTimeout(long l, TimeUnit timeUnit) {
        Preconditions.checkArgument(l > 0L);
        Preconditions.checkNotNull(timeUnit);
        dynamicIdlingResourceErrorPolicy = dynamicIdlingResourceErrorPolicy.toBuilder().withIdlingTimeout(l).withIdlingTimeoutUnit(timeUnit).build();
    }

    public static void setMasterPolicyTimeoutWhenDebuggerAttached(boolean bl) {
        masterIdlingPolicy = masterIdlingPolicy.toBuilder().build();
    }

    public static IdlingPolicy getMasterIdlingPolicy() {
        return masterIdlingPolicy;
    }

    public static IdlingPolicy getDynamicIdlingResourceWarningPolicy() {
        return dynamicIdlingResourceWarningPolicy;
    }

    public static IdlingPolicy getDynamicIdlingResourceErrorPolicy() {
        return dynamicIdlingResourceErrorPolicy;
    }
}

