/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.action;

import android.database.Cursor;
import android.os.Build;
import android.util.Log;
import android.view.View;
import android.widget.AbsListView;
import android.widget.Adapter;
import android.widget.AdapterView;
import android.widget.AdapterViewAnimator;
import android.widget.AdapterViewFlipper;
import androidx.test.espresso.action.AdapterViewProtocol;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.collect.Lists;
import androidx.test.espresso.core.internal.deps.guava.collect.Range;
import androidx.test.espresso.matcher.ViewMatchers;
import androidx.test.espresso.util.EspressoOptional;
import java.util.ArrayList;

public final class AdapterViewProtocols {
    private static final int FULLY_RENDERED_PERCENTAGE_CUTOFF = 90;
    private static final AdapterViewProtocol STANDARD_PROTOCOL = new StandardAdapterViewProtocol();

    private AdapterViewProtocols() {
    }

    public static AdapterViewProtocol standardProtocol() {
        return STANDARD_PROTOCOL;
    }

    private static final class StandardAdapterViewProtocol
    implements AdapterViewProtocol {
        private static final String TAG = "StdAdapterViewProtocol";

        @Override
        public Iterable<AdapterViewProtocol.AdaptedData> getDataInAdapterView(AdapterView<? extends Adapter> adapterView) {
            ArrayList<AdapterViewProtocol.AdaptedData> arrayList = Lists.newArrayList();
            int n = 0;
            while (n < adapterView.getCount()) {
                int n2 = n++;
                Object object = adapterView.getItemAtPosition(n2);
                arrayList.add(new AdapterViewProtocol.AdaptedData.Builder().withDataFunction(new StandardDataFunction(object, n2)).withOpaqueToken(n2).build());
            }
            return arrayList;
        }

        @Override
        public EspressoOptional<AdapterViewProtocol.AdaptedData> getDataRenderedByView(AdapterView<? extends Adapter> adapterView, View view) {
            int n;
            if (adapterView == view.getParent() && (n = adapterView.getPositionForView(view)) != -1) {
                return EspressoOptional.of(new AdapterViewProtocol.AdaptedData.Builder().withDataFunction(new StandardDataFunction(adapterView.getItemAtPosition(n), n)).withOpaqueToken(n).build());
            }
            return EspressoOptional.absent();
        }

        @Override
        public void makeDataRenderedWithinAdapterView(AdapterView<? extends Adapter> adapterView, AdapterViewProtocol.AdaptedData adaptedData) {
            Preconditions.checkArgument(adaptedData.opaqueToken instanceof Integer, "Not my data: %s", adaptedData);
            int n = (Integer)adaptedData.opaqueToken;
            boolean bl = false;
            if (Build.VERSION.SDK_INT > 7) {
                if (adapterView instanceof AbsListView) {
                    if (Build.VERSION.SDK_INT > 10) {
                        ((AbsListView)adapterView).smoothScrollToPositionFromTop(n, adapterView.getPaddingTop(), 0);
                    } else {
                        ((AbsListView)adapterView).smoothScrollToPosition(n);
                    }
                    bl = true;
                }
                if (Build.VERSION.SDK_INT > 10 && adapterView instanceof AdapterViewAnimator) {
                    if (adapterView instanceof AdapterViewFlipper) {
                        ((AdapterViewFlipper)adapterView).stopFlipping();
                    }
                    ((AdapterViewAnimator)adapterView).setDisplayedChild(n);
                    bl = true;
                }
            }
            if (!bl) {
                adapterView.setSelection(n);
            }
        }

        @Override
        public boolean isDataRenderedWithinAdapterView(AdapterView<? extends Adapter> adapterView, AdapterViewProtocol.AdaptedData adaptedData) {
            Preconditions.checkArgument(adaptedData.opaqueToken instanceof Integer, "Not my data: %s", adaptedData);
            int n = (Integer)adaptedData.opaqueToken;
            boolean bl = false;
            if (Range.closed(adapterView.getFirstVisiblePosition(), adapterView.getLastVisiblePosition()).contains(n)) {
                bl = adapterView.getFirstVisiblePosition() == adapterView.getLastVisiblePosition() ? true : this.isElementFullyRendered(adapterView, n - adapterView.getFirstVisiblePosition());
            }
            if (bl) {
                adapterView.setSelection(n);
            }
            return bl;
        }

        private boolean isElementFullyRendered(AdapterView<? extends Adapter> adapterView, int n) {
            View view = adapterView.getChildAt(n);
            return ViewMatchers.isDisplayingAtLeast(90).matches((Object)view);
        }

        private static final class StandardDataFunction
        implements AdapterViewProtocol.DataFunction {
            private final Object dataAtPosition;
            private final int position;

            private StandardDataFunction(Object object, int n) {
                Preconditions.checkArgument(n >= 0, "position must be >= 0");
                this.dataAtPosition = object;
                this.position = n;
            }

            @Override
            public Object getData() {
                if (this.dataAtPosition instanceof Cursor && !((Cursor)this.dataAtPosition).moveToPosition(this.position)) {
                    int n = this.position;
                    Log.e((String)StandardAdapterViewProtocol.TAG, (String)new StringBuilder(43).append("Cannot move cursor to position: ").append(n).toString());
                }
                return this.dataAtPosition;
            }
        }
    }
}

