/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.action;

import android.os.Build;
import android.view.KeyEvent;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.remote.annotation.RemoteMsgConstructor;
import androidx.test.espresso.remote.annotation.RemoteMsgField;

public final class EspressoKey {
    @RemoteMsgField(order=0)
    private final int keyCode;
    @RemoteMsgField(order=1)
    private final int metaState;

    private EspressoKey(Builder builder) {
        this(builder.builderKeyCode, builder.getMetaState());
    }

    @RemoteMsgConstructor
    EspressoKey(int n, int n2) {
        this.keyCode = n;
        this.metaState = n2;
    }

    public int getKeyCode() {
        return this.keyCode;
    }

    public int getMetaState() {
        return this.metaState;
    }

    public String toString() {
        return String.format("keyCode: %s, metaState: %s", this.keyCode, this.metaState);
    }

    public static class Builder {
        private int builderKeyCode = -1;
        private boolean isShiftPressed;
        private boolean isAltPressed;
        private boolean isCtrlPressed;

        public Builder withKeyCode(int n) {
            this.builderKeyCode = n;
            return this;
        }

        public Builder withShiftPressed(boolean bl) {
            this.isShiftPressed = bl;
            return this;
        }

        public Builder withCtrlPressed(boolean bl) {
            this.isCtrlPressed = bl;
            return this;
        }

        public Builder withAltPressed(boolean bl) {
            this.isAltPressed = bl;
            return this;
        }

        private int getMetaState() {
            int n = 0;
            if (this.isShiftPressed) {
                n |= 1;
            }
            if (this.isAltPressed) {
                n |= 2;
            }
            if (this.isCtrlPressed && Build.VERSION.SDK_INT >= 11) {
                n |= 0x1000;
            }
            return n;
        }

        public EspressoKey build() {
            Preconditions.checkState(this.builderKeyCode > 0 && this.builderKeyCode < KeyEvent.getMaxKeyCode(), "Invalid key code: %s", this.builderKeyCode);
            return new EspressoKey(this);
        }
    }
}

