/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.action;

import android.net.Uri;
import android.text.Spanned;
import android.text.style.URLSpan;
import android.view.View;
import android.widget.TextView;
import androidx.test.espresso.PerformException;
import androidx.test.espresso.UiController;
import androidx.test.espresso.ViewAction;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.collect.Lists;
import androidx.test.espresso.matcher.ViewMatchers;
import androidx.test.espresso.util.HumanReadables;
import java.util.ArrayList;
import java.util.Arrays;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public final class OpenLinkAction
implements ViewAction {
    private final Matcher<String> linkTextMatcher;
    private final Matcher<Uri> uriMatcher;

    public OpenLinkAction(Matcher<String> matcher, Matcher<Uri> matcher2) {
        this.linkTextMatcher = Preconditions.checkNotNull(matcher);
        this.uriMatcher = Preconditions.checkNotNull(matcher2);
    }

    @Override
    public Matcher<View> getConstraints() {
        return Matchers.allOf(ViewMatchers.isDisplayed(), ViewMatchers.isAssignableFrom(TextView.class), ViewMatchers.hasLinks());
    }

    @Override
    public String getDescription() {
        return String.format("open link with text %s and uri %s", this.linkTextMatcher, this.uriMatcher);
    }

    @Override
    public void perform(UiController uiController, View view) {
        TextView textView = (TextView)view;
        String string = textView.getText().toString();
        URLSpan[] uRLSpanArray = textView.getUrls();
        Spanned spanned = (Spanned)textView.getText();
        ArrayList<String> arrayList = Lists.newArrayList();
        URLSpan[] uRLSpanArray2 = uRLSpanArray;
        int n = uRLSpanArray2.length;
        for (int i = 0; i < n; ++i) {
            URLSpan uRLSpan;
            String string2 = String.valueOf(uRLSpan);
            uRLSpan = uRLSpanArray2[i];
            int n2 = spanned.getSpanStart((Object)uRLSpan);
            Preconditions.checkState(n2 != -1, new StringBuilder(49 + String.valueOf(string2).length()).append("Unable to get start of text associated with url: ").append(string2).toString());
            int n3 = spanned.getSpanEnd((Object)uRLSpan);
            String string3 = String.valueOf(uRLSpan);
            Preconditions.checkState(n3 != -1, new StringBuilder(47 + String.valueOf(string3).length()).append("Unable to get end of text associated with url: ").append(string3).toString());
            string3 = string.substring(n2, n3);
            arrayList.add(string3);
            if (!this.linkTextMatcher.matches((Object)string3) || !this.uriMatcher.matches((Object)Uri.parse((String)uRLSpan.getURL()))) continue;
            uRLSpan.onClick(view);
            return;
        }
        throw new PerformException.Builder().withActionDescription(this.getDescription()).withViewDescription(HumanReadables.describe(view)).withCause(new RuntimeException(String.format("Link with text '%s' and uri '%s' not found. List of links found in this view: %s\nList of uris: %s", this.linkTextMatcher, this.uriMatcher, arrayList, Arrays.asList(uRLSpanArray)))).build();
    }
}

