/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.action;

import android.view.View;
import androidx.test.espresso.PerformException;
import androidx.test.espresso.UiController;
import androidx.test.espresso.ViewAction;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.util.HumanReadables;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;

public final class RepeatActionUntilViewState
implements ViewAction {
    private final ViewAction mAction;
    private final Matcher<View> mDesiredStateMatcher;
    private final int mMaxAttempts;

    protected RepeatActionUntilViewState(ViewAction viewAction, Matcher<View> matcher, int n) {
        Preconditions.checkNotNull(viewAction);
        Preconditions.checkNotNull(matcher);
        Preconditions.checkState(n > 1, "maxAttempts should be greater than 1");
        this.mAction = viewAction;
        this.mDesiredStateMatcher = matcher;
        this.mMaxAttempts = n;
    }

    @Override
    public Matcher<View> getConstraints() {
        return this.mAction.getConstraints();
    }

    @Override
    public String getDescription() {
        StringDescription stringDescription = new StringDescription();
        this.mDesiredStateMatcher.describeTo((Description)stringDescription);
        return String.format("%s until: %s", this.mAction.getDescription(), stringDescription);
    }

    @Override
    public void perform(UiController uiController, View view) {
        int n;
        for (n = 1; !this.mDesiredStateMatcher.matches((Object)view) && n <= this.mMaxAttempts; ++n) {
            this.mAction.perform(uiController, view);
            uiController.loopMainThreadUntilIdle();
        }
        if (n > this.mMaxAttempts) {
            throw new PerformException.Builder().withActionDescription(this.getDescription()).withViewDescription(HumanReadables.describe(view)).withCause(new RuntimeException(String.format("Failed to achieve view state after %d attempts", this.mMaxAttempts))).build();
        }
    }
}

