/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.action;

import android.view.MotionEvent;
import androidx.test.espresso.UiController;
import androidx.test.espresso.action.MotionEvents;
import androidx.test.espresso.action.Swiper;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import java.util.ArrayList;

public enum Swipe implements Swiper
{
    FAST{

        @Override
        public Swiper.Status sendSwipe(UiController uiController, float[] fArray, float[] fArray2, float[] fArray3) {
            return Swipe.sendLinearSwipe(uiController, fArray, fArray2, fArray3, 150);
        }
    }
    ,
    SLOW{

        @Override
        public Swiper.Status sendSwipe(UiController uiController, float[] fArray, float[] fArray2, float[] fArray3) {
            return Swipe.sendLinearSwipe(uiController, fArray, fArray2, fArray3, 1500);
        }
    };

    private static final String TAG;
    private static final int SWIPE_EVENT_COUNT = 10;
    private static final int SWIPE_FAST_DURATION_MS = 150;
    private static final int SWIPE_SLOW_DURATION_MS = 1500;

    private static float[][] interpolate(float[] fArray, float[] fArray2, int n) {
        Preconditions.checkElementIndex(1, fArray.length);
        Preconditions.checkElementIndex(1, fArray2.length);
        float[][] fArray3 = new float[n][2];
        for (int i = 1; i < n + 1; ++i) {
            fArray3[i - 1][0] = fArray[0] + (fArray2[0] - fArray[0]) * (float)i / ((float)n + 2.0f);
            fArray3[i - 1][1] = fArray[1] + (fArray2[1] - fArray[1]) * (float)i / ((float)n + 2.0f);
        }
        return fArray3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Swiper.Status sendLinearSwipe(UiController uiController, float[] fArray, float[] fArray2, float[] fArray3, int n) {
        Preconditions.checkNotNull(uiController);
        Preconditions.checkNotNull(fArray);
        Preconditions.checkNotNull(fArray2);
        Preconditions.checkNotNull(fArray3);
        float[][] fArray4 = Swipe.interpolate(fArray, fArray2, 10);
        ArrayList<MotionEvent> arrayList = new ArrayList<MotionEvent>();
        MotionEvent motionEvent = MotionEvents.obtainDownEvent(fArray, fArray3);
        arrayList.add(motionEvent);
        try {
            long l = n / fArray4.length;
            long l2 = motionEvent.getDownTime();
            for (float[] fArray5 : fArray4) {
                arrayList.add(MotionEvents.obtainMovement(motionEvent.getDownTime(), l2 += l, fArray5));
            }
            arrayList.add(MotionEvent.obtain((long)motionEvent.getDownTime(), (long)(l2 += l), (int)1, (float)fArray2[0], (float)fArray2[1], (int)0));
            uiController.injectMotionEventSequence(arrayList);
        }
        catch (Exception exception) {
            Swiper.Status status = Swiper.Status.FAILURE;
            return status;
        }
        finally {
            for (MotionEvent motionEvent2 : arrayList) {
                motionEvent2.recycle();
            }
        }
        return Swiper.Status.SUCCESS;
    }

    static {
        TAG = Swipe.class.getSimpleName();
    }
}

