/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.action;

import android.net.Uri;
import android.os.Build;
import android.util.Log;
import android.util.Pair;
import android.view.View;
import androidx.test.espresso.UiController;
import androidx.test.espresso.ViewAction;
import androidx.test.espresso.ViewAssertion;
import androidx.test.espresso.action.CloseKeyboardAction;
import androidx.test.espresso.action.EditorAction;
import androidx.test.espresso.action.EspressoKey;
import androidx.test.espresso.action.GeneralClickAction;
import androidx.test.espresso.action.GeneralLocation;
import androidx.test.espresso.action.GeneralSwipeAction;
import androidx.test.espresso.action.KeyEventAction;
import androidx.test.espresso.action.OpenLinkAction;
import androidx.test.espresso.action.Press;
import androidx.test.espresso.action.PressBackAction;
import androidx.test.espresso.action.RepeatActionUntilViewState;
import androidx.test.espresso.action.ReplaceTextAction;
import androidx.test.espresso.action.ScrollToAction;
import androidx.test.espresso.action.Swipe;
import androidx.test.espresso.action.Tap;
import androidx.test.espresso.action.TypeTextAction;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public final class ViewActions {
    private static final float EDGE_FUZZ_FACTOR = 0.083f;
    private static Set<Pair<String, ViewAssertion>> globalAssertions = new CopyOnWriteArraySet<Pair<String, ViewAssertion>>();

    private ViewActions() {
    }

    public static void addGlobalAssertion(String string, ViewAssertion viewAssertion) {
        Preconditions.checkNotNull(string);
        Preconditions.checkNotNull(viewAssertion);
        Pair pair = new Pair((Object)string, (Object)viewAssertion);
        Preconditions.checkArgument(!globalAssertions.contains(pair), "ViewAssertion with name %s is already in the global assertions!", string);
        globalAssertions.add((Pair<String, ViewAssertion>)pair);
    }

    public static void removeGlobalAssertion(ViewAssertion viewAssertion) {
        boolean bl = false;
        for (Pair<String, ViewAssertion> pair : globalAssertions) {
            if (viewAssertion == null || !viewAssertion.equals(pair.second)) continue;
            bl = bl || globalAssertions.remove(pair);
        }
        Preconditions.checkArgument(bl, "ViewAssertion was not in global assertions!");
    }

    public static void clearGlobalAssertions() {
        globalAssertions.clear();
    }

    public static ViewAction actionWithAssertions(final ViewAction viewAction) {
        if (globalAssertions.isEmpty()) {
            return viewAction;
        }
        return new ViewAction(){

            @Override
            public String getDescription() {
                StringBuilder stringBuilder = new StringBuilder("Running view assertions[");
                for (Pair pair : globalAssertions) {
                    stringBuilder.append((String)pair.first);
                    stringBuilder.append(", ");
                }
                stringBuilder.append("] and then running: ");
                stringBuilder.append(viewAction.getDescription());
                return stringBuilder.toString();
            }

            @Override
            public Matcher<View> getConstraints() {
                return viewAction.getConstraints();
            }

            @Override
            public void perform(UiController uiController, View view) {
                for (Pair pair : globalAssertions) {
                    String string = String.valueOf((String)pair.first);
                    Log.i((String)"ViewAssertion", (String)(string.length() != 0 ? "Asserting ".concat(string) : new String("Asserting ")));
                    ((ViewAssertion)pair.second).check(view, null);
                }
                viewAction.perform(uiController, view);
            }
        };
    }

    public static ViewAction clearText() {
        return ViewActions.actionWithAssertions(new ReplaceTextAction(""));
    }

    public static ViewAction click(int n, int n2) {
        if (Build.VERSION.SDK_INT < 14) {
            throw new UnsupportedOperationException();
        }
        return ViewActions.actionWithAssertions(new GeneralClickAction(Tap.SINGLE, GeneralLocation.VISIBLE_CENTER, Press.FINGER, n, n2));
    }

    public static ViewAction click() {
        return ViewActions.actionWithAssertions(new GeneralClickAction(Tap.SINGLE, GeneralLocation.VISIBLE_CENTER, Press.FINGER, 0, 1));
    }

    public static ViewAction click(ViewAction viewAction) {
        Preconditions.checkNotNull(viewAction);
        return ViewActions.actionWithAssertions(new GeneralClickAction(Tap.SINGLE, GeneralLocation.CENTER, Press.FINGER, 0, 1, viewAction));
    }

    public static ViewAction swipeLeft() {
        return ViewActions.actionWithAssertions(new GeneralSwipeAction(Swipe.FAST, GeneralLocation.translate(GeneralLocation.CENTER_RIGHT, -0.083f, 0.0f), GeneralLocation.CENTER_LEFT, Press.FINGER));
    }

    public static ViewAction swipeRight() {
        return ViewActions.actionWithAssertions(new GeneralSwipeAction(Swipe.FAST, GeneralLocation.translate(GeneralLocation.CENTER_LEFT, 0.083f, 0.0f), GeneralLocation.CENTER_RIGHT, Press.FINGER));
    }

    public static ViewAction swipeDown() {
        return ViewActions.actionWithAssertions(new GeneralSwipeAction(Swipe.FAST, GeneralLocation.translate(GeneralLocation.TOP_CENTER, 0.0f, 0.083f), GeneralLocation.BOTTOM_CENTER, Press.FINGER));
    }

    public static ViewAction swipeUp() {
        return ViewActions.actionWithAssertions(new GeneralSwipeAction(Swipe.FAST, GeneralLocation.translate(GeneralLocation.BOTTOM_CENTER, 0.0f, -0.083f), GeneralLocation.TOP_CENTER, Press.FINGER));
    }

    public static ViewAction closeSoftKeyboard() {
        return ViewActions.actionWithAssertions(new CloseKeyboardAction());
    }

    public static ViewAction pressImeActionButton() {
        return ViewActions.actionWithAssertions(new EditorAction());
    }

    public static ViewAction pressBack() {
        return ViewActions.actionWithAssertions(new PressBackAction(true));
    }

    public static ViewAction pressBackUnconditionally() {
        return ViewActions.actionWithAssertions(new PressBackAction(false));
    }

    public static ViewAction pressMenuKey() {
        return ViewActions.pressKey(82);
    }

    public static ViewAction pressKey(int n) {
        return ViewActions.actionWithAssertions(new KeyEventAction(new EspressoKey.Builder().withKeyCode(n).build()));
    }

    public static ViewAction pressKey(EspressoKey espressoKey) {
        return ViewActions.actionWithAssertions(new KeyEventAction(espressoKey));
    }

    public static ViewAction doubleClick() {
        return ViewActions.actionWithAssertions(new GeneralClickAction(Tap.DOUBLE, GeneralLocation.CENTER, Press.FINGER, 0, 1));
    }

    public static ViewAction longClick() {
        return ViewActions.actionWithAssertions(new GeneralClickAction(Tap.LONG, GeneralLocation.CENTER, Press.FINGER, 0, 1));
    }

    public static ViewAction scrollTo() {
        return ViewActions.actionWithAssertions(new ScrollToAction());
    }

    public static ViewAction typeTextIntoFocusedView(String string) {
        return ViewActions.actionWithAssertions(new TypeTextAction(string, false));
    }

    public static ViewAction typeText(String string) {
        return ViewActions.actionWithAssertions(new TypeTextAction(string));
    }

    public static ViewAction replaceText(String string) {
        return ViewActions.actionWithAssertions(new ReplaceTextAction(string));
    }

    public static ViewAction openLinkWithText(String string) {
        return ViewActions.openLinkWithText((Matcher<String>)Matchers.is((Object)string));
    }

    public static ViewAction openLinkWithText(Matcher<String> matcher) {
        return ViewActions.openLink(matcher, (Matcher<Uri>)Matchers.any(Uri.class));
    }

    public static ViewAction openLinkWithUri(String string) {
        return ViewActions.openLinkWithUri((Matcher<Uri>)Matchers.is((Object)Uri.parse((String)string)));
    }

    public static ViewAction openLinkWithUri(Matcher<Uri> matcher) {
        return ViewActions.openLink((Matcher<String>)Matchers.any(String.class), matcher);
    }

    public static ViewAction openLink(Matcher<String> matcher, Matcher<Uri> matcher2) {
        Preconditions.checkNotNull(matcher);
        Preconditions.checkNotNull(matcher2);
        return ViewActions.actionWithAssertions(new OpenLinkAction(matcher, matcher2));
    }

    public static ViewAction repeatedlyUntil(ViewAction viewAction, Matcher<View> matcher, int n) {
        Preconditions.checkNotNull(viewAction);
        Preconditions.checkNotNull(matcher);
        return ViewActions.actionWithAssertions(new RepeatActionUntilViewState(viewAction, matcher, n));
    }
}

