/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.base;

import android.os.Build;
import android.os.SystemClock;
import android.view.KeyEvent;
import android.view.MotionEvent;
import androidx.test.espresso.InjectEventSecurityException;
import androidx.test.espresso.base.EventInjectionStrategy;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;

final class EventInjector {
    private static final String TAG = EventInjector.class.getSimpleName();
    private final EventInjectionStrategy injectionStrategy;

    EventInjector(EventInjectionStrategy eventInjectionStrategy) {
        this.injectionStrategy = Preconditions.checkNotNull(eventInjectionStrategy);
    }

    boolean injectKeyEvent(KeyEvent keyEvent) throws InjectEventSecurityException {
        KeyEvent keyEvent2;
        long l = keyEvent.getDownTime();
        long l2 = keyEvent.getEventTime();
        int n = keyEvent.getAction();
        int n2 = keyEvent.getKeyCode();
        int n3 = keyEvent.getRepeatCount();
        int n4 = keyEvent.getMetaState();
        int n5 = keyEvent.getDeviceId();
        int n6 = keyEvent.getScanCode();
        int n7 = keyEvent.getFlags();
        if (l2 == 0L) {
            l2 = SystemClock.uptimeMillis();
        }
        if (l == 0L) {
            l = l2;
        }
        if (Build.VERSION.SDK_INT < 9) {
            keyEvent2 = new KeyEvent(l, l2, n, n2, n3, n4, n5, n6, n7 | 8);
        } else {
            int n8 = keyEvent.getSource();
            keyEvent2 = new KeyEvent(l, l2, n, n2, n3, n4, n5, n6, n7 | 8, n8);
        }
        return this.injectionStrategy.injectKeyEvent(keyEvent2);
    }

    boolean injectMotionEvent(MotionEvent motionEvent) throws InjectEventSecurityException {
        return this.injectionStrategy.injectMotionEvent(motionEvent, true);
    }

    boolean injectMotionEventAsync(MotionEvent motionEvent) throws InjectEventSecurityException {
        return this.injectionStrategy.injectMotionEvent(motionEvent, false);
    }
}

