/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.core.internal.deps.guava.collect;

import androidx.test.espresso.core.internal.deps.guava.collect.Platform;
import java.lang.reflect.Array;

public final class ObjectArrays {
    public static <T> T[] newArray(Class<T> clazz, int n) {
        return (Object[])Array.newInstance(clazz, n);
    }

    public static <T> T[] newArray(T[] TArray, int n) {
        return Platform.newArray(TArray, n);
    }

    static Object[] checkElementsNotNull(Object ... objectArray) {
        return ObjectArrays.checkElementsNotNull(objectArray, objectArray.length);
    }

    static Object[] checkElementsNotNull(Object[] objectArray, int n) {
        for (int i = 0; i < n; ++i) {
            ObjectArrays.checkElementNotNull(objectArray[i], i);
        }
        return objectArray;
    }

    static Object checkElementNotNull(Object object, int n) {
        if (object == null) {
            throw new NullPointerException(new StringBuilder(20).append("at index ").append(n).toString());
        }
        return object;
    }
}

