/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.remote;

import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.cache.Cache;
import androidx.test.espresso.core.internal.deps.guava.cache.CacheBuilder;
import androidx.test.espresso.remote.RemoteProtocolException;
import androidx.test.internal.util.LogUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;

public final class ConstructorInvocation {
    private static final String TAG = "ConstructorInvocation";
    private static final Cache<ConstructorKey, Constructor<?>> constructorCache = CacheBuilder.newBuilder().maximumSize(256L).build();
    private final Class<?> clazz;
    private final Class<? extends Annotation> annotationClass;
    private final Class<?>[] parameterTypes;

    public ConstructorInvocation(Class<?> clazz, Class<? extends Annotation> clazz2, Class<?> ... classArray) {
        this.clazz = Preconditions.checkNotNull(clazz, "clazz cannot be null!");
        this.annotationClass = clazz2;
        this.parameterTypes = classArray;
    }

    static void invalidateCache() {
        constructorCache.invalidateAll();
    }

    public Object invokeConstructor(Object ... objectArray) {
        return this.invokeConstructorExplosively(objectArray);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object invokeConstructorExplosively(Object ... objectArray) {
        Object var2_2 = null;
        Constructor<?> constructor = null;
        ConstructorKey constructorKey = new ConstructorKey(this.clazz, this.parameterTypes);
        try {
            constructor = constructorCache.getIfPresent(constructorKey);
            if (null == constructor) {
                LogUtil.logDebug((String)TAG, (String)"Cache miss for constructor: %s(%s). Loading into cache.", (Object[])new Object[]{this.clazz.getSimpleName(), Arrays.toString(objectArray)});
                if (this.annotationClass != null) {
                    for (Constructor<?> constructor2 : this.clazz.getDeclaredConstructors()) {
                        if (!constructor2.isAnnotationPresent(this.annotationClass)) continue;
                        constructor = constructor2;
                        break;
                    }
                }
                if (null == constructor) {
                    constructor = this.clazz.getConstructor(this.parameterTypes);
                }
                Preconditions.checkState(constructor != null, "No constructor found for annotation: %s, or parameter types: %s", this.annotationClass, Arrays.asList(this.parameterTypes));
                constructorCache.put(constructorKey, constructor);
            } else {
                LogUtil.logDebug((String)TAG, (String)"Cache hit for constructor: %s(%s).", (Object[])new Object[]{this.clazz.getSimpleName(), Arrays.toString(objectArray)});
            }
            constructor.setAccessible(true);
            var2_2 = constructor.newInstance(objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            try {
                throw new RemoteProtocolException(String.format("Cannot invoke constructor %s with constructorParams [%s] on clazz %s", constructor, Arrays.toString(objectArray), this.clazz.getName()), invocationTargetException);
                catch (IllegalAccessException illegalAccessException) {
                    throw new RemoteProtocolException(String.format("Cannot create instance of %s", this.clazz.getName()), illegalAccessException);
                }
                catch (InstantiationException instantiationException) {
                    throw new RemoteProtocolException(String.format("Cannot create instance of %s", this.clazz.getName()), instantiationException);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new RemoteProtocolException(String.format("No constructor found for clazz: %s. Available constructors: %s", this.clazz.getName(), Arrays.asList(this.clazz.getConstructors())), noSuchMethodException);
                }
                catch (SecurityException securityException) {
                    throw new RemoteProtocolException(String.format("Constructor not accessible: %s", constructor.getName()), securityException);
                }
            }
            catch (Throwable throwable) {
                LogUtil.logDebug((String)TAG, (String)"%s(%s)", (Object[])new Object[]{this.clazz.getSimpleName(), Arrays.toString(objectArray)});
                throw throwable;
            }
        }
        LogUtil.logDebug((String)TAG, (String)"%s(%s)", (Object[])new Object[]{this.clazz.getSimpleName(), Arrays.toString(objectArray)});
        return var2_2;
    }

    private static class ConstructorKey {
        private final Class<?> type;
        private final Class<?>[] parameterTypes;

        public ConstructorKey(Class<?> clazz, Class<?>[] classArray) {
            this.type = clazz;
            this.parameterTypes = classArray;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            ConstructorKey constructorKey = (ConstructorKey)object;
            if (!this.type.equals(constructorKey.type)) {
                return false;
            }
            return Arrays.equals(this.parameterTypes, constructorKey.parameterTypes);
        }

        public int hashCode() {
            int n = this.type.hashCode();
            n = 31 * n + Arrays.hashCode(this.parameterTypes);
            return n;
        }
    }
}

