/*
 * Decompiled with CFR 0.152.
 */
package androidx.fragment.app;

import androidx.annotation.NonNull;
import androidx.collection.SimpleArrayMap;
import androidx.fragment.app.Fragment;
import java.lang.reflect.InvocationTargetException;

public class FragmentFactory {
    private static final SimpleArrayMap<String, Class<?>> sClassMap = new SimpleArrayMap();

    @NonNull
    private static Class<?> loadClass(@NonNull ClassLoader classLoader, @NonNull String className) throws ClassNotFoundException {
        Class<?> clazz = (Class<?>)sClassMap.get((Object)className);
        if (clazz == null) {
            clazz = Class.forName(className, false, classLoader);
            sClassMap.put((Object)className, clazz);
        }
        return clazz;
    }

    static boolean isFragmentClass(@NonNull ClassLoader classLoader, @NonNull String className) {
        try {
            Class<?> clazz = FragmentFactory.loadClass(classLoader, className);
            return Fragment.class.isAssignableFrom(clazz);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    @NonNull
    public static Class<? extends Fragment> loadFragmentClass(@NonNull ClassLoader classLoader, @NonNull String className) {
        try {
            Class<?> clazz = FragmentFactory.loadClass(classLoader, className);
            return clazz;
        }
        catch (ClassNotFoundException e) {
            throw new Fragment.InstantiationException("Unable to instantiate fragment " + className + ": make sure class name exists", e);
        }
        catch (ClassCastException e) {
            throw new Fragment.InstantiationException("Unable to instantiate fragment " + className + ": make sure class is a valid subclass of Fragment", e);
        }
    }

    @NonNull
    public Fragment instantiate(@NonNull ClassLoader classLoader, @NonNull String className) {
        try {
            Class<? extends Fragment> cls = FragmentFactory.loadFragmentClass(classLoader, className);
            return cls.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (InstantiationException e) {
            throw new Fragment.InstantiationException("Unable to instantiate fragment " + className + ": make sure class name exists, is public, and has an empty constructor that is public", e);
        }
        catch (IllegalAccessException e) {
            throw new Fragment.InstantiationException("Unable to instantiate fragment " + className + ": make sure class name exists, is public, and has an empty constructor that is public", e);
        }
        catch (NoSuchMethodException e) {
            throw new Fragment.InstantiationException("Unable to instantiate fragment " + className + ": could not find Fragment constructor", e);
        }
        catch (InvocationTargetException e) {
            throw new Fragment.InstantiationException("Unable to instantiate fragment " + className + ": calling Fragment constructor caused an exception", e);
        }
    }
}

