/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.action;

import android.graphics.Rect;
import android.view.View;
import androidx.test.espresso.action.CoordinatesProvider;
import androidx.test.espresso.action.TranslatedCoordinatesProvider;

public enum GeneralLocation implements CoordinatesProvider
{
    TOP_LEFT{

        @Override
        public float[] calculateCoordinates(View view) {
            return GeneralLocation.getCoordinates(view, Position.BEGIN, Position.BEGIN);
        }
    }
    ,
    TOP_CENTER{

        @Override
        public float[] calculateCoordinates(View view) {
            return GeneralLocation.getCoordinates(view, Position.BEGIN, Position.MIDDLE);
        }
    }
    ,
    TOP_RIGHT{

        @Override
        public float[] calculateCoordinates(View view) {
            return GeneralLocation.getCoordinates(view, Position.BEGIN, Position.END);
        }
    }
    ,
    CENTER_LEFT{

        @Override
        public float[] calculateCoordinates(View view) {
            return GeneralLocation.getCoordinates(view, Position.MIDDLE, Position.BEGIN);
        }
    }
    ,
    CENTER{

        @Override
        public float[] calculateCoordinates(View view) {
            return GeneralLocation.getCoordinates(view, Position.MIDDLE, Position.MIDDLE);
        }
    }
    ,
    CENTER_RIGHT{

        @Override
        public float[] calculateCoordinates(View view) {
            return GeneralLocation.getCoordinates(view, Position.MIDDLE, Position.END);
        }
    }
    ,
    BOTTOM_LEFT{

        @Override
        public float[] calculateCoordinates(View view) {
            return GeneralLocation.getCoordinates(view, Position.END, Position.BEGIN);
        }
    }
    ,
    BOTTOM_CENTER{

        @Override
        public float[] calculateCoordinates(View view) {
            return GeneralLocation.getCoordinates(view, Position.END, Position.MIDDLE);
        }
    }
    ,
    BOTTOM_RIGHT{

        @Override
        public float[] calculateCoordinates(View view) {
            return GeneralLocation.getCoordinates(view, Position.END, Position.END);
        }
    }
    ,
    VISIBLE_CENTER{

        @Override
        public float[] calculateCoordinates(View view) {
            return GeneralLocation.getCoordinatesOfVisiblePart(view, Position.MIDDLE, Position.MIDDLE);
        }
    };


    static CoordinatesProvider translate(CoordinatesProvider coordinatesProvider, float f, float f2) {
        return new TranslatedCoordinatesProvider(coordinatesProvider, f, f2);
    }

    private static float[] getCoordinates(View view, Position position, Position position2) {
        int[] nArray = new int[2];
        view.getLocationOnScreen(nArray);
        float f = position2.getPosition(nArray[0], view.getWidth());
        float f2 = position.getPosition(nArray[1], view.getHeight());
        float[] fArray = new float[]{f, f2};
        return fArray;
    }

    private static float[] getCoordinatesOfVisiblePart(View view, Position position, Position position2) {
        int[] nArray = new int[2];
        view.getLocationOnScreen(nArray);
        Rect rect = new Rect();
        view.getGlobalVisibleRect(rect);
        float f = position2.getPosition(nArray[0], rect.width());
        float f2 = position.getPosition(nArray[1], rect.height());
        float[] fArray = new float[]{f, f2};
        return fArray;
    }

    private static enum Position {
        BEGIN{

            @Override
            public float getPosition(int n, int n2) {
                return n;
            }
        }
        ,
        MIDDLE{

            @Override
            public float getPosition(int n, int n2) {
                return (float)n + (float)(n2 - 1) / 2.0f;
            }
        }
        ,
        END{

            @Override
            public float getPosition(int n, int n2) {
                return n + n2 - 1;
            }
        };


        abstract float getPosition(int var1, int var2);
    }
}

