/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.assertion;

import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import androidx.test.espresso.AmbiguousViewMatcherException;
import androidx.test.espresso.NoMatchingViewException;
import androidx.test.espresso.ViewAssertion;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.base.Predicate;
import androidx.test.espresso.core.internal.deps.guava.collect.Iterables;
import androidx.test.espresso.core.internal.deps.guava.collect.Iterators;
import androidx.test.espresso.matcher.ViewMatchers;
import androidx.test.espresso.util.HumanReadables;
import androidx.test.espresso.util.TreeIterables;
import java.util.Iterator;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.StringDescription;

public final class PositionAssertions {
    private static final String TAG = "PositionAssertions";

    private PositionAssertions() {
    }

    public static ViewAssertion isCompletelyLeftOf(Matcher<View> matcher) {
        return PositionAssertions.relativePositionOf(matcher, Position.COMPLETELY_LEFT_OF);
    }

    public static ViewAssertion isCompletelyRightOf(Matcher<View> matcher) {
        return PositionAssertions.relativePositionOf(matcher, Position.COMPLETELY_RIGHT_OF);
    }

    @Deprecated
    public static ViewAssertion isLeftOf(Matcher<View> matcher) {
        return PositionAssertions.isCompletelyLeftOf(matcher);
    }

    @Deprecated
    public static ViewAssertion isRightOf(Matcher<View> matcher) {
        return PositionAssertions.isCompletelyRightOf(matcher);
    }

    public static ViewAssertion isPartiallyLeftOf(Matcher<View> matcher) {
        return PositionAssertions.relativePositionOf(matcher, Position.PARTIALLY_LEFT_OF);
    }

    public static ViewAssertion isPartiallyRightOf(Matcher<View> matcher) {
        return PositionAssertions.relativePositionOf(matcher, Position.PARTIALLY_RIGHT_OF);
    }

    public static ViewAssertion isLeftAlignedWith(Matcher<View> matcher) {
        return PositionAssertions.relativePositionOf(matcher, Position.LEFT_ALIGNED);
    }

    public static ViewAssertion isRightAlignedWith(Matcher<View> matcher) {
        return PositionAssertions.relativePositionOf(matcher, Position.RIGHT_ALIGNED);
    }

    public static ViewAssertion isCompletelyAbove(Matcher<View> matcher) {
        return PositionAssertions.relativePositionOf(matcher, Position.COMPLETELY_ABOVE);
    }

    public static ViewAssertion isCompletelyBelow(Matcher<View> matcher) {
        return PositionAssertions.relativePositionOf(matcher, Position.COMPLETELY_BELOW);
    }

    public static ViewAssertion isPartiallyAbove(Matcher<View> matcher) {
        return PositionAssertions.relativePositionOf(matcher, Position.PARTIALLY_ABOVE);
    }

    public static ViewAssertion isPartiallyBelow(Matcher<View> matcher) {
        return PositionAssertions.relativePositionOf(matcher, Position.PARTIALLY_BELOW);
    }

    @Deprecated
    public static ViewAssertion isAbove(Matcher<View> matcher) {
        return PositionAssertions.isCompletelyAbove(matcher);
    }

    @Deprecated
    public static ViewAssertion isBelow(Matcher<View> matcher) {
        return PositionAssertions.isCompletelyBelow(matcher);
    }

    public static ViewAssertion isBottomAlignedWith(Matcher<View> matcher) {
        return PositionAssertions.relativePositionOf(matcher, Position.BOTTOM_ALIGNED);
    }

    public static ViewAssertion isTopAlignedWith(Matcher<View> matcher) {
        return PositionAssertions.relativePositionOf(matcher, Position.TOP_ALIGNED);
    }

    static ViewAssertion relativePositionOf(final Matcher<View> matcher, final Position position) {
        Preconditions.checkNotNull(matcher);
        return new ViewAssertion(){

            @Override
            public void check(View view, NoMatchingViewException noMatchingViewException) {
                StringDescription stringDescription = new StringDescription();
                if (noMatchingViewException != null) {
                    stringDescription.appendText(String.format("' check could not be performed because view '%s' was not found.\n", noMatchingViewException.getViewMatcherDescription()));
                    Log.e((String)PositionAssertions.TAG, (String)stringDescription.toString());
                    throw noMatchingViewException;
                }
                stringDescription.appendText("View:").appendText(HumanReadables.describe(view)).appendText(" is not ").appendText(position.toString()).appendText(" view ").appendText(matcher.toString());
                ViewMatchers.assertThat(stringDescription.toString(), PositionAssertions.isRelativePosition(view, PositionAssertions.findView((Matcher<View>)matcher, (View)PositionAssertions.getTopViewGroup(view)), position), Matchers.is((Object)true));
            }
        };
    }

    static View findView(final Matcher<View> matcher, View view) {
        Preconditions.checkNotNull(matcher);
        Preconditions.checkNotNull(view);
        Predicate<View> predicate = new Predicate<View>(){

            @Override
            public boolean apply(View view) {
                return matcher.matches((Object)view);
            }
        };
        Iterator<View> iterator = Iterables.filter(TreeIterables.breadthFirstViewTraversal(view), predicate).iterator();
        View view2 = null;
        while (iterator.hasNext()) {
            if (view2 != null) {
                throw new AmbiguousViewMatcherException.Builder().withRootView(view).withViewMatcher(matcher).withView1(view2).withView2(iterator.next()).withOtherAmbiguousViews(Iterators.toArray(iterator, View.class)).build();
            }
            view2 = iterator.next();
        }
        if (view2 == null) {
            throw new NoMatchingViewException.Builder().withViewMatcher(matcher).withRootView(view).build();
        }
        return view2;
    }

    private static ViewGroup getTopViewGroup(View view) {
        ViewGroup viewGroup = null;
        for (ViewParent viewParent = view.getParent(); viewParent != null; viewParent = viewParent.getParent()) {
            if (!(viewParent instanceof ViewGroup)) continue;
            viewGroup = (ViewGroup)viewParent;
        }
        return viewGroup;
    }

    static boolean isRelativePosition(View view, View view2, Position position) {
        int[] nArray = new int[2];
        int[] nArray2 = new int[2];
        view.getLocationOnScreen(nArray);
        view2.getLocationOnScreen(nArray2);
        switch (position) {
            case COMPLETELY_LEFT_OF: {
                return nArray[0] + view.getWidth() <= nArray2[0];
            }
            case COMPLETELY_RIGHT_OF: {
                return nArray2[0] + view2.getWidth() <= nArray[0];
            }
            case COMPLETELY_ABOVE: {
                return nArray[1] + view.getHeight() <= nArray2[1];
            }
            case COMPLETELY_BELOW: {
                return nArray2[1] + view2.getHeight() <= nArray[1];
            }
            case PARTIALLY_LEFT_OF: {
                return nArray[0] < nArray2[0] && nArray2[0] < nArray[0] + view.getWidth();
            }
            case PARTIALLY_RIGHT_OF: {
                return nArray2[0] < nArray[0] && nArray[0] < nArray2[0] + view2.getWidth();
            }
            case PARTIALLY_ABOVE: {
                return nArray[1] < nArray2[1] && nArray2[1] < nArray[1] + view.getHeight();
            }
            case PARTIALLY_BELOW: {
                return nArray2[1] < nArray[1] && nArray[1] < nArray2[1] + view2.getHeight();
            }
            case LEFT_ALIGNED: {
                return nArray[0] == nArray2[0];
            }
            case RIGHT_ALIGNED: {
                return nArray[0] + view.getWidth() == nArray2[0] + view2.getWidth();
            }
            case TOP_ALIGNED: {
                return nArray[1] == nArray2[1];
            }
            case BOTTOM_ALIGNED: {
                return nArray[1] + view.getHeight() == nArray2[1] + view2.getHeight();
            }
        }
        return false;
    }

    static enum Position {
        COMPLETELY_LEFT_OF("completely left of"),
        COMPLETELY_RIGHT_OF("completely right of"),
        COMPLETELY_ABOVE("completely above"),
        COMPLETELY_BELOW("completely below"),
        PARTIALLY_LEFT_OF("partially left of"),
        PARTIALLY_RIGHT_OF("partially right of"),
        PARTIALLY_ABOVE("partially above"),
        PARTIALLY_BELOW("partially below"),
        LEFT_ALIGNED("aligned left with"),
        RIGHT_ALIGNED("aligned right with"),
        TOP_ALIGNED("aligned top with"),
        BOTTOM_ALIGNED("aligned bottom with");

        private final String positionValue;

        private Position(String string2) {
            this.positionValue = string2;
        }

        public String toString() {
            return this.positionValue;
        }
    }
}

