/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.core.internal.deps.guava.base;

import androidx.test.espresso.core.internal.deps.guava.base.Strings;

public final class Preconditions {
    public static void checkArgument(boolean bl) {
        if (!bl) {
            throw new IllegalArgumentException();
        }
    }

    public static void checkArgument(boolean bl, Object object) {
        if (!bl) {
            throw new IllegalArgumentException(String.valueOf(object));
        }
    }

    public static void checkArgument(boolean bl, String string, int n) {
        if (!bl) {
            throw new IllegalArgumentException(Strings.lenientFormat(string, n));
        }
    }

    public static void checkArgument(boolean bl, String string, Object object) {
        if (!bl) {
            throw new IllegalArgumentException(Strings.lenientFormat(string, object));
        }
    }

    public static void checkArgument(boolean bl, String string, long l, Object object) {
        if (!bl) {
            throw new IllegalArgumentException(Strings.lenientFormat(string, l, object));
        }
    }

    public static void checkState(boolean bl) {
        if (!bl) {
            throw new IllegalStateException();
        }
    }

    public static void checkState(boolean bl, Object object) {
        if (!bl) {
            throw new IllegalStateException(String.valueOf(object));
        }
    }

    public static void checkState(boolean bl, String string, int n) {
        if (!bl) {
            throw new IllegalStateException(Strings.lenientFormat(string, n));
        }
    }

    public static void checkState(boolean bl, String string, long l) {
        if (!bl) {
            throw new IllegalStateException(Strings.lenientFormat(string, l));
        }
    }

    public static void checkState(boolean bl, String string, Object object) {
        if (!bl) {
            throw new IllegalStateException(Strings.lenientFormat(string, object));
        }
    }

    public static void checkState(boolean bl, String string, Object object, Object object2) {
        if (!bl) {
            throw new IllegalStateException(Strings.lenientFormat(string, object, object2));
        }
    }

    public static <T> T checkNotNull(T t) {
        if (t == null) {
            throw new NullPointerException();
        }
        return t;
    }

    public static <T> T checkNotNull(T t, Object object) {
        if (t == null) {
            throw new NullPointerException(String.valueOf(object));
        }
        return t;
    }

    public static <T> T checkNotNull(T t, String string, Object object) {
        if (t == null) {
            throw new NullPointerException(Strings.lenientFormat(string, object));
        }
        return t;
    }

    public static int checkElementIndex(int n, int n2) {
        return Preconditions.checkElementIndex(n, n2, "index");
    }

    public static int checkElementIndex(int n, int n2, String string) {
        if (n < 0 || n >= n2) {
            throw new IndexOutOfBoundsException(Preconditions.badElementIndex(n, n2, string));
        }
        return n;
    }

    private static String badElementIndex(int n, int n2, String string) {
        if (n < 0) {
            return Strings.lenientFormat("%s (%s) must not be negative", string, n);
        }
        if (n2 < 0) {
            throw new IllegalArgumentException(new StringBuilder(26).append("negative size: ").append(n2).toString());
        }
        return Strings.lenientFormat("%s (%s) must be less than size (%s)", string, n, n2);
    }

    public static int checkPositionIndex(int n, int n2) {
        return Preconditions.checkPositionIndex(n, n2, "index");
    }

    public static int checkPositionIndex(int n, int n2, String string) {
        if (n < 0 || n > n2) {
            throw new IndexOutOfBoundsException(Preconditions.badPositionIndex(n, n2, string));
        }
        return n;
    }

    private static String badPositionIndex(int n, int n2, String string) {
        if (n < 0) {
            return Strings.lenientFormat("%s (%s) must not be negative", string, n);
        }
        if (n2 < 0) {
            throw new IllegalArgumentException(new StringBuilder(26).append("negative size: ").append(n2).toString());
        }
        return Strings.lenientFormat("%s (%s) must not be greater than size (%s)", string, n, n2);
    }

    public static void checkPositionIndexes(int n, int n2, int n3) {
        if (n < 0 || n2 < n || n2 > n3) {
            throw new IndexOutOfBoundsException(Preconditions.badPositionIndexes(n, n2, n3));
        }
    }

    private static String badPositionIndexes(int n, int n2, int n3) {
        if (n < 0 || n > n3) {
            return Preconditions.badPositionIndex(n, n3, "start index");
        }
        if (n2 < 0 || n2 > n3) {
            return Preconditions.badPositionIndex(n2, n3, "end index");
        }
        return Strings.lenientFormat("end index (%s) must not be less than start index (%s)", n2, n);
    }
}

