/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.matcher;

import android.text.Layout;
import android.view.View;
import android.widget.TextView;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public final class LayoutMatchers {
    private LayoutMatchers() {
    }

    public static Matcher<View> hasEllipsizedText() {
        return new TypeSafeMatcher<View>(TextView.class){

            public void describeTo(Description description) {
                description.appendText("has ellipsized text");
            }

            public boolean matchesSafely(View view) {
                Layout layout = ((TextView)view).getLayout();
                if (layout != null) {
                    int n = layout.getLineCount();
                    return n > 0 && layout.getEllipsisCount(n - 1) > 0;
                }
                return false;
            }
        };
    }

    public static Matcher<View> hasMultilineText() {
        return new TypeSafeMatcher<View>(TextView.class){

            public void describeTo(Description description) {
                description.appendText("has more than one line of text");
            }

            public boolean matchesSafely(View view) {
                return ((TextView)view).getLineCount() > 1;
            }
        };
    }
}

