/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.shape;

import android.graphics.Matrix;
import android.graphics.Path;
import android.graphics.RectF;
import com.google.android.material.internal.Experimental;
import java.util.ArrayList;
import java.util.List;

@Experimental(value="The shapes API is currently experimental and subject to change")
public class ShapePath {
    public float startX;
    public float startY;
    public float endX;
    public float endY;
    private final List<PathOperation> operations = new ArrayList<PathOperation>();

    public ShapePath() {
        this.reset(0.0f, 0.0f);
    }

    public ShapePath(float startX, float startY) {
        this.reset(startX, startY);
    }

    public void reset(float startX, float startY) {
        this.startX = startX;
        this.startY = startY;
        this.endX = startX;
        this.endY = startY;
        this.operations.clear();
    }

    public void lineTo(float x, float y) {
        PathLineOperation operation = new PathLineOperation();
        operation.x = x;
        operation.y = y;
        this.operations.add(operation);
        this.endX = x;
        this.endY = y;
    }

    public void quadToPoint(float controlX, float controlY, float toX, float toY) {
        PathQuadOperation operation = new PathQuadOperation();
        operation.controlX = controlX;
        operation.controlY = controlY;
        operation.endX = toX;
        operation.endY = toY;
        this.operations.add(operation);
        this.endX = toX;
        this.endY = toY;
    }

    public void addArc(float left, float top, float right, float bottom, float startAngle, float sweepAngle) {
        PathArcOperation operation = new PathArcOperation(left, top, right, bottom);
        operation.startAngle = startAngle;
        operation.sweepAngle = sweepAngle;
        this.operations.add(operation);
        this.endX = (left + right) * 0.5f + (right - left) / 2.0f * (float)Math.cos(Math.toRadians(startAngle + sweepAngle));
        this.endY = (top + bottom) * 0.5f + (bottom - top) / 2.0f * (float)Math.sin(Math.toRadians(startAngle + sweepAngle));
    }

    public void applyToPath(Matrix transform, Path path) {
        int size = this.operations.size();
        for (int i = 0; i < size; ++i) {
            PathOperation operation = this.operations.get(i);
            operation.applyToPath(transform, path);
        }
    }

    public static class PathArcOperation
    extends PathOperation {
        private static final RectF rectF = new RectF();
        public float left;
        public float top;
        public float right;
        public float bottom;
        public float startAngle;
        public float sweepAngle;

        public PathArcOperation(float left, float top, float right, float bottom) {
            this.left = left;
            this.top = top;
            this.right = right;
            this.bottom = bottom;
        }

        @Override
        public void applyToPath(Matrix transform, Path path) {
            Matrix inverse = this.matrix;
            transform.invert(inverse);
            path.transform(inverse);
            rectF.set(this.left, this.top, this.right, this.bottom);
            path.arcTo(rectF, this.startAngle, this.sweepAngle, false);
            path.transform(transform);
        }
    }

    public static class PathQuadOperation
    extends PathOperation {
        public float controlX;
        public float controlY;
        public float endX;
        public float endY;

        @Override
        public void applyToPath(Matrix transform, Path path) {
            Matrix inverse = this.matrix;
            transform.invert(inverse);
            path.transform(inverse);
            path.quadTo(this.controlX, this.controlY, this.endX, this.endY);
            path.transform(transform);
        }
    }

    public static class PathLineOperation
    extends PathOperation {
        private float x;
        private float y;

        @Override
        public void applyToPath(Matrix transform, Path path) {
            Matrix inverse = this.matrix;
            transform.invert(inverse);
            path.transform(inverse);
            path.lineTo(this.x, this.y);
            path.transform(transform);
        }
    }

    public static abstract class PathOperation {
        protected final Matrix matrix = new Matrix();

        public abstract void applyToPath(Matrix var1, Path var2);
    }
}

