/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.widget;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseIntArray;
import android.util.Xml;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.constraintlayout.widget.Barrier;
import androidx.constraintlayout.widget.ConstraintHelper;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.constraintlayout.widget.Constraints;
import androidx.constraintlayout.widget.Guideline;
import androidx.constraintlayout.widget.R;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class ConstraintSet {
    private static final String TAG = "ConstraintSet";
    public static final int UNSET = -1;
    public static final int MATCH_CONSTRAINT = 0;
    public static final int WRAP_CONTENT = -2;
    public static final int MATCH_CONSTRAINT_WRAP = 1;
    public static final int MATCH_CONSTRAINT_SPREAD = 0;
    public static final int PARENT_ID = 0;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final int HORIZONTAL_GUIDELINE = 0;
    public static final int VERTICAL_GUIDELINE = 1;
    public static final int VISIBLE = 0;
    public static final int INVISIBLE = 4;
    public static final int GONE = 8;
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    public static final int TOP = 3;
    public static final int BOTTOM = 4;
    public static final int BASELINE = 5;
    public static final int START = 6;
    public static final int END = 7;
    public static final int CHAIN_SPREAD = 0;
    public static final int CHAIN_SPREAD_INSIDE = 1;
    public static final int CHAIN_PACKED = 2;
    private static final boolean DEBUG = false;
    private static final int[] VISIBILITY_FLAGS = new int[]{0, 4, 8};
    private static final int BARRIER_TYPE = 1;
    private HashMap<Integer, Constraint> mConstraints = new HashMap();
    private static SparseIntArray mapToConstant = new SparseIntArray();
    private static final int BASELINE_TO_BASELINE = 1;
    private static final int BOTTOM_MARGIN = 2;
    private static final int BOTTOM_TO_BOTTOM = 3;
    private static final int BOTTOM_TO_TOP = 4;
    private static final int DIMENSION_RATIO = 5;
    private static final int EDITOR_ABSOLUTE_X = 6;
    private static final int EDITOR_ABSOLUTE_Y = 7;
    private static final int END_MARGIN = 8;
    private static final int END_TO_END = 9;
    private static final int END_TO_START = 10;
    private static final int GONE_BOTTOM_MARGIN = 11;
    private static final int GONE_END_MARGIN = 12;
    private static final int GONE_LEFT_MARGIN = 13;
    private static final int GONE_RIGHT_MARGIN = 14;
    private static final int GONE_START_MARGIN = 15;
    private static final int GONE_TOP_MARGIN = 16;
    private static final int GUIDE_BEGIN = 17;
    private static final int GUIDE_END = 18;
    private static final int GUIDE_PERCENT = 19;
    private static final int HORIZONTAL_BIAS = 20;
    private static final int LAYOUT_HEIGHT = 21;
    private static final int LAYOUT_VISIBILITY = 22;
    private static final int LAYOUT_WIDTH = 23;
    private static final int LEFT_MARGIN = 24;
    private static final int LEFT_TO_LEFT = 25;
    private static final int LEFT_TO_RIGHT = 26;
    private static final int ORIENTATION = 27;
    private static final int RIGHT_MARGIN = 28;
    private static final int RIGHT_TO_LEFT = 29;
    private static final int RIGHT_TO_RIGHT = 30;
    private static final int START_MARGIN = 31;
    private static final int START_TO_END = 32;
    private static final int START_TO_START = 33;
    private static final int TOP_MARGIN = 34;
    private static final int TOP_TO_BOTTOM = 35;
    private static final int TOP_TO_TOP = 36;
    private static final int VERTICAL_BIAS = 37;
    private static final int VIEW_ID = 38;
    private static final int HORIZONTAL_WEIGHT = 39;
    private static final int VERTICAL_WEIGHT = 40;
    private static final int HORIZONTAL_STYLE = 41;
    private static final int VERTICAL_STYLE = 42;
    private static final int ALPHA = 43;
    private static final int ELEVATION = 44;
    private static final int ROTATION_X = 45;
    private static final int ROTATION_Y = 46;
    private static final int SCALE_X = 47;
    private static final int SCALE_Y = 48;
    private static final int TRANSFORM_PIVOT_X = 49;
    private static final int TRANSFORM_PIVOT_Y = 50;
    private static final int TRANSLATION_X = 51;
    private static final int TRANSLATION_Y = 52;
    private static final int TRANSLATION_Z = 53;
    private static final int WIDTH_DEFAULT = 54;
    private static final int HEIGHT_DEFAULT = 55;
    private static final int WIDTH_MAX = 56;
    private static final int HEIGHT_MAX = 57;
    private static final int WIDTH_MIN = 58;
    private static final int HEIGHT_MIN = 59;
    private static final int ROTATION = 60;
    private static final int CIRCLE = 61;
    private static final int CIRCLE_RADIUS = 62;
    private static final int CIRCLE_ANGLE = 63;
    private static final int WIDTH_PERCENT = 69;
    private static final int HEIGHT_PERCENT = 70;
    private static final int CHAIN_USE_RTL = 71;
    private static final int BARRIER_DIRECTION = 72;
    private static final int CONSTRAINT_REFERENCED_IDS = 73;
    private static final int BARRIER_ALLOWS_GONE_WIDGETS = 74;
    private static final int UNUSED = 75;

    public Constraint getParameters(int mId) {
        return this.get(mId);
    }

    public void clone(Context context, int constraintLayoutId) {
        this.clone((ConstraintLayout)LayoutInflater.from((Context)context).inflate(constraintLayoutId, null));
    }

    public void clone(ConstraintSet set) {
        this.mConstraints.clear();
        for (Integer key : set.mConstraints.keySet()) {
            this.mConstraints.put(key, set.mConstraints.get(key).clone());
        }
    }

    public void clone(ConstraintLayout constraintLayout) {
        int count = constraintLayout.getChildCount();
        this.mConstraints.clear();
        for (int i = 0; i < count; ++i) {
            View view = constraintLayout.getChildAt(i);
            ConstraintLayout.LayoutParams param = (ConstraintLayout.LayoutParams)view.getLayoutParams();
            int id2 = view.getId();
            if (id2 == -1) {
                throw new RuntimeException("All children of ConstraintLayout must have ids to use ConstraintSet");
            }
            if (!this.mConstraints.containsKey(id2)) {
                this.mConstraints.put(id2, new Constraint());
            }
            Constraint constraint = this.mConstraints.get(id2);
            constraint.fillFrom(id2, param);
            constraint.visibility = view.getVisibility();
            if (Build.VERSION.SDK_INT >= 17) {
                constraint.alpha = view.getAlpha();
                constraint.rotation = view.getRotation();
                constraint.rotationX = view.getRotationX();
                constraint.rotationY = view.getRotationY();
                constraint.scaleX = view.getScaleX();
                constraint.scaleY = view.getScaleY();
                float pivotX = view.getPivotX();
                float pivotY = view.getPivotY();
                if ((double)pivotX != 0.0 || (double)pivotY != 0.0) {
                    constraint.transformPivotX = pivotX;
                    constraint.transformPivotY = pivotY;
                }
                constraint.translationX = view.getTranslationX();
                constraint.translationY = view.getTranslationY();
                if (Build.VERSION.SDK_INT >= 21) {
                    constraint.translationZ = view.getTranslationZ();
                    if (constraint.applyElevation) {
                        constraint.elevation = view.getElevation();
                    }
                }
            }
            if (!(view instanceof Barrier)) continue;
            Barrier barrier = (Barrier)view;
            constraint.mBarrierAllowsGoneWidgets = barrier.allowsGoneWidget();
            constraint.mReferenceIds = barrier.getReferencedIds();
            constraint.mBarrierDirection = barrier.getType();
        }
    }

    public void clone(Constraints constraints) {
        int count = constraints.getChildCount();
        this.mConstraints.clear();
        for (int i = 0; i < count; ++i) {
            View view = constraints.getChildAt(i);
            Constraints.LayoutParams param = (Constraints.LayoutParams)view.getLayoutParams();
            int id2 = view.getId();
            if (id2 == -1) {
                throw new RuntimeException("All children of ConstraintLayout must have ids to use ConstraintSet");
            }
            if (!this.mConstraints.containsKey(id2)) {
                this.mConstraints.put(id2, new Constraint());
            }
            Constraint constraint = this.mConstraints.get(id2);
            if (view instanceof ConstraintHelper) {
                ConstraintHelper helper = (ConstraintHelper)view;
                constraint.fillFromConstraints(helper, id2, param);
            }
            constraint.fillFromConstraints(id2, param);
        }
    }

    public void applyTo(ConstraintLayout constraintLayout) {
        this.applyToInternal(constraintLayout);
        constraintLayout.setConstraintSet(null);
    }

    void applyToInternal(ConstraintLayout constraintLayout) {
        ConstraintLayout.LayoutParams param;
        int count = constraintLayout.getChildCount();
        HashSet<Integer> used = new HashSet<Integer>(this.mConstraints.keySet());
        for (int i = 0; i < count; ++i) {
            View view = constraintLayout.getChildAt(i);
            int id2 = view.getId();
            if (id2 == -1) {
                throw new RuntimeException("All children of ConstraintLayout must have ids to use ConstraintSet");
            }
            if (!this.mConstraints.containsKey(id2)) continue;
            used.remove(id2);
            Constraint constraint = this.mConstraints.get(id2);
            if (view instanceof Barrier) {
                constraint.mHelperType = 1;
            }
            if (constraint.mHelperType != -1) {
                switch (constraint.mHelperType) {
                    case 1: {
                        Barrier barrier = (Barrier)view;
                        barrier.setId(id2);
                        barrier.setType(constraint.mBarrierDirection);
                        barrier.setAllowsGoneWidget(constraint.mBarrierAllowsGoneWidgets);
                        if (constraint.mReferenceIds != null) {
                            barrier.setReferencedIds(constraint.mReferenceIds);
                            break;
                        }
                        if (constraint.mReferenceIdString == null) break;
                        constraint.mReferenceIds = this.convertReferenceString(barrier, constraint.mReferenceIdString);
                        barrier.setReferencedIds(constraint.mReferenceIds);
                    }
                }
            }
            param = (ConstraintLayout.LayoutParams)view.getLayoutParams();
            constraint.applyTo(param);
            view.setLayoutParams((ViewGroup.LayoutParams)param);
            view.setVisibility(constraint.visibility);
            if (Build.VERSION.SDK_INT < 17) continue;
            view.setAlpha(constraint.alpha);
            view.setRotation(constraint.rotation);
            view.setRotationX(constraint.rotationX);
            view.setRotationY(constraint.rotationY);
            view.setScaleX(constraint.scaleX);
            view.setScaleY(constraint.scaleY);
            if (!Float.isNaN(constraint.transformPivotX)) {
                view.setPivotX(constraint.transformPivotX);
            }
            if (!Float.isNaN(constraint.transformPivotY)) {
                view.setPivotY(constraint.transformPivotY);
            }
            view.setTranslationX(constraint.translationX);
            view.setTranslationY(constraint.translationY);
            if (Build.VERSION.SDK_INT < 21) continue;
            view.setTranslationZ(constraint.translationZ);
            if (!constraint.applyElevation) continue;
            view.setElevation(constraint.elevation);
        }
        for (Integer id3 : used) {
            Constraint constraint = this.mConstraints.get(id3);
            if (constraint.mHelperType != -1) {
                switch (constraint.mHelperType) {
                    case 1: {
                        Barrier barrier = new Barrier(constraintLayout.getContext());
                        barrier.setId(id3);
                        if (constraint.mReferenceIds != null) {
                            barrier.setReferencedIds(constraint.mReferenceIds);
                        } else if (constraint.mReferenceIdString != null) {
                            constraint.mReferenceIds = this.convertReferenceString(barrier, constraint.mReferenceIdString);
                            barrier.setReferencedIds(constraint.mReferenceIds);
                        }
                        barrier.setType(constraint.mBarrierDirection);
                        param = constraintLayout.generateDefaultLayoutParams();
                        barrier.validateParams();
                        constraint.applyTo(param);
                        constraintLayout.addView(barrier, (ViewGroup.LayoutParams)param);
                    }
                }
            }
            if (!constraint.mIsGuideline) continue;
            Guideline g = new Guideline(constraintLayout.getContext());
            g.setId(id3);
            param = constraintLayout.generateDefaultLayoutParams();
            constraint.applyTo(param);
            constraintLayout.addView(g, (ViewGroup.LayoutParams)param);
        }
    }

    public void center(int centerID, int firstID, int firstSide, int firstMargin, int secondId, int secondSide, int secondMargin, float bias) {
        if (firstMargin < 0) {
            throw new IllegalArgumentException("margin must be > 0");
        }
        if (secondMargin < 0) {
            throw new IllegalArgumentException("margin must be > 0");
        }
        if (bias <= 0.0f || bias > 1.0f) {
            throw new IllegalArgumentException("bias must be between 0 and 1 inclusive");
        }
        if (firstSide == 1 || firstSide == 2) {
            this.connect(centerID, 1, firstID, firstSide, firstMargin);
            this.connect(centerID, 2, secondId, secondSide, secondMargin);
            Constraint constraint = this.mConstraints.get(centerID);
            constraint.horizontalBias = bias;
        } else if (firstSide == 6 || firstSide == 7) {
            this.connect(centerID, 6, firstID, firstSide, firstMargin);
            this.connect(centerID, 7, secondId, secondSide, secondMargin);
            Constraint constraint = this.mConstraints.get(centerID);
            constraint.horizontalBias = bias;
        } else {
            this.connect(centerID, 3, firstID, firstSide, firstMargin);
            this.connect(centerID, 4, secondId, secondSide, secondMargin);
            Constraint constraint = this.mConstraints.get(centerID);
            constraint.verticalBias = bias;
        }
    }

    public void centerHorizontally(int centerID, int leftId, int leftSide, int leftMargin, int rightId, int rightSide, int rightMargin, float bias) {
        this.connect(centerID, 1, leftId, leftSide, leftMargin);
        this.connect(centerID, 2, rightId, rightSide, rightMargin);
        Constraint constraint = this.mConstraints.get(centerID);
        constraint.horizontalBias = bias;
    }

    public void centerHorizontallyRtl(int centerID, int startId, int startSide, int startMargin, int endId, int endSide, int endMargin, float bias) {
        this.connect(centerID, 6, startId, startSide, startMargin);
        this.connect(centerID, 7, endId, endSide, endMargin);
        Constraint constraint = this.mConstraints.get(centerID);
        constraint.horizontalBias = bias;
    }

    public void centerVertically(int centerID, int topId, int topSide, int topMargin, int bottomId, int bottomSide, int bottomMargin, float bias) {
        this.connect(centerID, 3, topId, topSide, topMargin);
        this.connect(centerID, 4, bottomId, bottomSide, bottomMargin);
        Constraint constraint = this.mConstraints.get(centerID);
        constraint.verticalBias = bias;
    }

    public void createVerticalChain(int topId, int topSide, int bottomId, int bottomSide, int[] chainIds, float[] weights, int style) {
        if (chainIds.length < 2) {
            throw new IllegalArgumentException("must have 2 or more widgets in a chain");
        }
        if (weights != null && weights.length != chainIds.length) {
            throw new IllegalArgumentException("must have 2 or more widgets in a chain");
        }
        if (weights != null) {
            this.get((int)chainIds[0]).verticalWeight = weights[0];
        }
        this.get((int)chainIds[0]).verticalChainStyle = style;
        this.connect(chainIds[0], 3, topId, topSide, 0);
        for (int i = 1; i < chainIds.length; ++i) {
            int chainId = chainIds[i];
            this.connect(chainIds[i], 3, chainIds[i - 1], 4, 0);
            this.connect(chainIds[i - 1], 4, chainIds[i], 3, 0);
            if (weights == null) continue;
            this.get((int)chainIds[i]).verticalWeight = weights[i];
        }
        this.connect(chainIds[chainIds.length - 1], 4, bottomId, bottomSide, 0);
    }

    public void createHorizontalChain(int leftId, int leftSide, int rightId, int rightSide, int[] chainIds, float[] weights, int style) {
        this.createHorizontalChain(leftId, leftSide, rightId, rightSide, chainIds, weights, style, 1, 2);
    }

    public void createHorizontalChainRtl(int startId, int startSide, int endId, int endSide, int[] chainIds, float[] weights, int style) {
        this.createHorizontalChain(startId, startSide, endId, endSide, chainIds, weights, style, 6, 7);
    }

    private void createHorizontalChain(int leftId, int leftSide, int rightId, int rightSide, int[] chainIds, float[] weights, int style, int left, int right) {
        if (chainIds.length < 2) {
            throw new IllegalArgumentException("must have 2 or more widgets in a chain");
        }
        if (weights != null && weights.length != chainIds.length) {
            throw new IllegalArgumentException("must have 2 or more widgets in a chain");
        }
        if (weights != null) {
            this.get((int)chainIds[0]).horizontalWeight = weights[0];
        }
        this.get((int)chainIds[0]).horizontalChainStyle = style;
        this.connect(chainIds[0], left, leftId, leftSide, -1);
        for (int i = 1; i < chainIds.length; ++i) {
            int chainId = chainIds[i];
            this.connect(chainIds[i], left, chainIds[i - 1], right, -1);
            this.connect(chainIds[i - 1], right, chainIds[i], left, -1);
            if (weights == null) continue;
            this.get((int)chainIds[i]).horizontalWeight = weights[i];
        }
        this.connect(chainIds[chainIds.length - 1], right, rightId, rightSide, -1);
    }

    public void connect(int startID, int startSide, int endID, int endSide, int margin) {
        if (!this.mConstraints.containsKey(startID)) {
            this.mConstraints.put(startID, new Constraint());
        }
        Constraint constraint = this.mConstraints.get(startID);
        switch (startSide) {
            case 1: {
                if (endSide == 1) {
                    constraint.leftToLeft = endID;
                    constraint.leftToRight = -1;
                } else if (endSide == 2) {
                    constraint.leftToRight = endID;
                    constraint.leftToLeft = -1;
                } else {
                    throw new IllegalArgumentException("Left to " + this.sideToString(endSide) + " undefined");
                }
                constraint.leftMargin = margin;
                break;
            }
            case 2: {
                if (endSide == 1) {
                    constraint.rightToLeft = endID;
                    constraint.rightToRight = -1;
                } else if (endSide == 2) {
                    constraint.rightToRight = endID;
                    constraint.rightToLeft = -1;
                } else {
                    throw new IllegalArgumentException("right to " + this.sideToString(endSide) + " undefined");
                }
                constraint.rightMargin = margin;
                break;
            }
            case 3: {
                if (endSide == 3) {
                    constraint.topToTop = endID;
                    constraint.topToBottom = -1;
                    constraint.baselineToBaseline = -1;
                } else if (endSide == 4) {
                    constraint.topToBottom = endID;
                    constraint.topToTop = -1;
                    constraint.baselineToBaseline = -1;
                } else {
                    throw new IllegalArgumentException("right to " + this.sideToString(endSide) + " undefined");
                }
                constraint.topMargin = margin;
                break;
            }
            case 4: {
                if (endSide == 4) {
                    constraint.bottomToBottom = endID;
                    constraint.bottomToTop = -1;
                    constraint.baselineToBaseline = -1;
                } else if (endSide == 3) {
                    constraint.bottomToTop = endID;
                    constraint.bottomToBottom = -1;
                    constraint.baselineToBaseline = -1;
                } else {
                    throw new IllegalArgumentException("right to " + this.sideToString(endSide) + " undefined");
                }
                constraint.bottomMargin = margin;
                break;
            }
            case 5: {
                if (endSide == 5) {
                    constraint.baselineToBaseline = endID;
                    constraint.bottomToBottom = -1;
                    constraint.bottomToTop = -1;
                    constraint.topToTop = -1;
                    constraint.topToBottom = -1;
                    break;
                }
                throw new IllegalArgumentException("right to " + this.sideToString(endSide) + " undefined");
            }
            case 6: {
                if (endSide == 6) {
                    constraint.startToStart = endID;
                    constraint.startToEnd = -1;
                } else if (endSide == 7) {
                    constraint.startToEnd = endID;
                    constraint.startToStart = -1;
                } else {
                    throw new IllegalArgumentException("right to " + this.sideToString(endSide) + " undefined");
                }
                constraint.startMargin = margin;
                break;
            }
            case 7: {
                if (endSide == 7) {
                    constraint.endToEnd = endID;
                    constraint.endToStart = -1;
                } else if (endSide == 6) {
                    constraint.endToStart = endID;
                    constraint.endToEnd = -1;
                } else {
                    throw new IllegalArgumentException("right to " + this.sideToString(endSide) + " undefined");
                }
                constraint.endMargin = margin;
                break;
            }
            default: {
                throw new IllegalArgumentException(this.sideToString(startSide) + " to " + this.sideToString(endSide) + " unknown");
            }
        }
    }

    public void connect(int startID, int startSide, int endID, int endSide) {
        if (!this.mConstraints.containsKey(startID)) {
            this.mConstraints.put(startID, new Constraint());
        }
        Constraint constraint = this.mConstraints.get(startID);
        switch (startSide) {
            case 1: {
                if (endSide == 1) {
                    constraint.leftToLeft = endID;
                    constraint.leftToRight = -1;
                    break;
                }
                if (endSide == 2) {
                    constraint.leftToRight = endID;
                    constraint.leftToLeft = -1;
                    break;
                }
                throw new IllegalArgumentException("left to " + this.sideToString(endSide) + " undefined");
            }
            case 2: {
                if (endSide == 1) {
                    constraint.rightToLeft = endID;
                    constraint.rightToRight = -1;
                    break;
                }
                if (endSide == 2) {
                    constraint.rightToRight = endID;
                    constraint.rightToLeft = -1;
                    break;
                }
                throw new IllegalArgumentException("right to " + this.sideToString(endSide) + " undefined");
            }
            case 3: {
                if (endSide == 3) {
                    constraint.topToTop = endID;
                    constraint.topToBottom = -1;
                    constraint.baselineToBaseline = -1;
                    break;
                }
                if (endSide == 4) {
                    constraint.topToBottom = endID;
                    constraint.topToTop = -1;
                    constraint.baselineToBaseline = -1;
                    break;
                }
                throw new IllegalArgumentException("right to " + this.sideToString(endSide) + " undefined");
            }
            case 4: {
                if (endSide == 4) {
                    constraint.bottomToBottom = endID;
                    constraint.bottomToTop = -1;
                    constraint.baselineToBaseline = -1;
                    break;
                }
                if (endSide == 3) {
                    constraint.bottomToTop = endID;
                    constraint.bottomToBottom = -1;
                    constraint.baselineToBaseline = -1;
                    break;
                }
                throw new IllegalArgumentException("right to " + this.sideToString(endSide) + " undefined");
            }
            case 5: {
                if (endSide == 5) {
                    constraint.baselineToBaseline = endID;
                    constraint.bottomToBottom = -1;
                    constraint.bottomToTop = -1;
                    constraint.topToTop = -1;
                    constraint.topToBottom = -1;
                    break;
                }
                throw new IllegalArgumentException("right to " + this.sideToString(endSide) + " undefined");
            }
            case 6: {
                if (endSide == 6) {
                    constraint.startToStart = endID;
                    constraint.startToEnd = -1;
                    break;
                }
                if (endSide == 7) {
                    constraint.startToEnd = endID;
                    constraint.startToStart = -1;
                    break;
                }
                throw new IllegalArgumentException("right to " + this.sideToString(endSide) + " undefined");
            }
            case 7: {
                if (endSide == 7) {
                    constraint.endToEnd = endID;
                    constraint.endToStart = -1;
                    break;
                }
                if (endSide == 6) {
                    constraint.endToStart = endID;
                    constraint.endToEnd = -1;
                    break;
                }
                throw new IllegalArgumentException("right to " + this.sideToString(endSide) + " undefined");
            }
            default: {
                throw new IllegalArgumentException(this.sideToString(startSide) + " to " + this.sideToString(endSide) + " unknown");
            }
        }
    }

    public void centerHorizontally(int viewId, int toView) {
        if (toView == 0) {
            this.center(viewId, 0, 1, 0, 0, 2, 0, 0.5f);
        } else {
            this.center(viewId, toView, 2, 0, toView, 1, 0, 0.5f);
        }
    }

    public void centerHorizontallyRtl(int viewId, int toView) {
        if (toView == 0) {
            this.center(viewId, 0, 6, 0, 0, 7, 0, 0.5f);
        } else {
            this.center(viewId, toView, 7, 0, toView, 6, 0, 0.5f);
        }
    }

    public void centerVertically(int viewId, int toView) {
        if (toView == 0) {
            this.center(viewId, 0, 3, 0, 0, 4, 0, 0.5f);
        } else {
            this.center(viewId, toView, 4, 0, toView, 3, 0, 0.5f);
        }
    }

    public void clear(int viewId) {
        this.mConstraints.remove(viewId);
    }

    public void clear(int viewId, int anchor) {
        if (this.mConstraints.containsKey(viewId)) {
            Constraint constraint = this.mConstraints.get(viewId);
            switch (anchor) {
                case 1: {
                    constraint.leftToRight = -1;
                    constraint.leftToLeft = -1;
                    constraint.leftMargin = -1;
                    constraint.goneLeftMargin = -1;
                    break;
                }
                case 2: {
                    constraint.rightToRight = -1;
                    constraint.rightToLeft = -1;
                    constraint.rightMargin = -1;
                    constraint.goneRightMargin = -1;
                    break;
                }
                case 3: {
                    constraint.topToBottom = -1;
                    constraint.topToTop = -1;
                    constraint.topMargin = -1;
                    constraint.goneTopMargin = -1;
                    break;
                }
                case 4: {
                    constraint.bottomToTop = -1;
                    constraint.bottomToBottom = -1;
                    constraint.bottomMargin = -1;
                    constraint.goneBottomMargin = -1;
                    break;
                }
                case 5: {
                    constraint.baselineToBaseline = -1;
                    break;
                }
                case 6: {
                    constraint.startToEnd = -1;
                    constraint.startToStart = -1;
                    constraint.startMargin = -1;
                    constraint.goneStartMargin = -1;
                    break;
                }
                case 7: {
                    constraint.endToStart = -1;
                    constraint.endToEnd = -1;
                    constraint.endMargin = -1;
                    constraint.goneEndMargin = -1;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown constraint");
                }
            }
        }
    }

    public void setMargin(int viewId, int anchor, int value) {
        Constraint constraint = this.get(viewId);
        switch (anchor) {
            case 1: {
                constraint.leftMargin = value;
                break;
            }
            case 2: {
                constraint.rightMargin = value;
                break;
            }
            case 3: {
                constraint.topMargin = value;
                break;
            }
            case 4: {
                constraint.bottomMargin = value;
                break;
            }
            case 5: {
                throw new IllegalArgumentException("baseline does not support margins");
            }
            case 6: {
                constraint.startMargin = value;
                break;
            }
            case 7: {
                constraint.endMargin = value;
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown constraint");
            }
        }
    }

    public void setGoneMargin(int viewId, int anchor, int value) {
        Constraint constraint = this.get(viewId);
        switch (anchor) {
            case 1: {
                constraint.goneLeftMargin = value;
                break;
            }
            case 2: {
                constraint.goneRightMargin = value;
                break;
            }
            case 3: {
                constraint.goneTopMargin = value;
                break;
            }
            case 4: {
                constraint.goneBottomMargin = value;
                break;
            }
            case 5: {
                throw new IllegalArgumentException("baseline does not support margins");
            }
            case 6: {
                constraint.goneStartMargin = value;
                break;
            }
            case 7: {
                constraint.goneEndMargin = value;
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown constraint");
            }
        }
    }

    public void setHorizontalBias(int viewId, float bias) {
        this.get((int)viewId).horizontalBias = bias;
    }

    public void setVerticalBias(int viewId, float bias) {
        this.get((int)viewId).verticalBias = bias;
    }

    public void setDimensionRatio(int viewId, String ratio) {
        this.get((int)viewId).dimensionRatio = ratio;
    }

    public void setVisibility(int viewId, int visibility) {
        this.get((int)viewId).visibility = visibility;
    }

    public void setAlpha(int viewId, float alpha) {
        this.get((int)viewId).alpha = alpha;
    }

    public boolean getApplyElevation(int viewId) {
        return this.get((int)viewId).applyElevation;
    }

    public void setApplyElevation(int viewId, boolean apply) {
        this.get((int)viewId).applyElevation = apply;
    }

    public void setElevation(int viewId, float elevation) {
        this.get((int)viewId).elevation = elevation;
        this.get((int)viewId).applyElevation = true;
    }

    public void setRotation(int viewId, float rotation) {
        this.get((int)viewId).rotation = rotation;
    }

    public void setRotationX(int viewId, float rotationX) {
        this.get((int)viewId).rotationX = rotationX;
    }

    public void setRotationY(int viewId, float rotationY) {
        this.get((int)viewId).rotationY = rotationY;
    }

    public void setScaleX(int viewId, float scaleX) {
        this.get((int)viewId).scaleX = scaleX;
    }

    public void setScaleY(int viewId, float scaleY) {
        this.get((int)viewId).scaleY = scaleY;
    }

    public void setTransformPivotX(int viewId, float transformPivotX) {
        this.get((int)viewId).transformPivotX = transformPivotX;
    }

    public void setTransformPivotY(int viewId, float transformPivotY) {
        this.get((int)viewId).transformPivotY = transformPivotY;
    }

    public void setTransformPivot(int viewId, float transformPivotX, float transformPivotY) {
        Constraint constraint = this.get(viewId);
        constraint.transformPivotY = transformPivotY;
        constraint.transformPivotX = transformPivotX;
    }

    public void setTranslationX(int viewId, float translationX) {
        this.get((int)viewId).translationX = translationX;
    }

    public void setTranslationY(int viewId, float translationY) {
        this.get((int)viewId).translationY = translationY;
    }

    public void setTranslation(int viewId, float translationX, float translationY) {
        Constraint constraint = this.get(viewId);
        constraint.translationX = translationX;
        constraint.translationY = translationY;
    }

    public void setTranslationZ(int viewId, float translationZ) {
        this.get((int)viewId).translationZ = translationZ;
    }

    public void constrainHeight(int viewId, int height) {
        this.get((int)viewId).mHeight = height;
    }

    public void constrainWidth(int viewId, int width) {
        this.get((int)viewId).mWidth = width;
    }

    public void constrainCircle(int viewId, int id2, int radius, float angle) {
        Constraint constraint = this.get(viewId);
        constraint.circleConstraint = id2;
        constraint.circleRadius = radius;
        constraint.circleAngle = angle;
    }

    public void constrainMaxHeight(int viewId, int height) {
        this.get((int)viewId).heightMax = height;
    }

    public void constrainMaxWidth(int viewId, int width) {
        this.get((int)viewId).widthMax = width;
    }

    public void constrainMinHeight(int viewId, int height) {
        this.get((int)viewId).heightMin = height;
    }

    public void constrainMinWidth(int viewId, int width) {
        this.get((int)viewId).widthMin = width;
    }

    public void constrainPercentWidth(int viewId, float percent) {
        this.get((int)viewId).widthPercent = percent;
    }

    public void constrainPercentHeight(int viewId, float percent) {
        this.get((int)viewId).heightPercent = percent;
    }

    public void constrainDefaultHeight(int viewId, int height) {
        this.get((int)viewId).heightDefault = height;
    }

    public void constrainDefaultWidth(int viewId, int width) {
        this.get((int)viewId).widthDefault = width;
    }

    public void setHorizontalWeight(int viewId, float weight) {
        this.get((int)viewId).horizontalWeight = weight;
    }

    public void setVerticalWeight(int viewId, float weight) {
        this.get((int)viewId).verticalWeight = weight;
    }

    public void setHorizontalChainStyle(int viewId, int chainStyle) {
        this.get((int)viewId).horizontalChainStyle = chainStyle;
    }

    public void setVerticalChainStyle(int viewId, int chainStyle) {
        this.get((int)viewId).verticalChainStyle = chainStyle;
    }

    public void addToHorizontalChain(int viewId, int leftId, int rightId) {
        this.connect(viewId, 1, leftId, leftId == 0 ? 1 : 2, 0);
        this.connect(viewId, 2, rightId, rightId == 0 ? 2 : 1, 0);
        if (leftId != 0) {
            this.connect(leftId, 2, viewId, 1, 0);
        }
        if (rightId != 0) {
            this.connect(rightId, 1, viewId, 2, 0);
        }
    }

    public void addToHorizontalChainRTL(int viewId, int leftId, int rightId) {
        this.connect(viewId, 6, leftId, leftId == 0 ? 6 : 7, 0);
        this.connect(viewId, 7, rightId, rightId == 0 ? 7 : 6, 0);
        if (leftId != 0) {
            this.connect(leftId, 7, viewId, 6, 0);
        }
        if (rightId != 0) {
            this.connect(rightId, 6, viewId, 7, 0);
        }
    }

    public void addToVerticalChain(int viewId, int topId, int bottomId) {
        this.connect(viewId, 3, topId, topId == 0 ? 3 : 4, 0);
        this.connect(viewId, 4, bottomId, bottomId == 0 ? 4 : 3, 0);
        if (topId != 0) {
            this.connect(topId, 4, viewId, 3, 0);
        }
        if (topId != 0) {
            this.connect(bottomId, 3, viewId, 4, 0);
        }
    }

    public void removeFromVerticalChain(int viewId) {
        if (this.mConstraints.containsKey(viewId)) {
            Constraint constraint = this.mConstraints.get(viewId);
            int topId = constraint.topToBottom;
            int bottomId = constraint.bottomToTop;
            if (topId != -1 || bottomId != -1) {
                if (topId != -1 && bottomId != -1) {
                    this.connect(topId, 4, bottomId, 3, 0);
                    this.connect(bottomId, 3, topId, 4, 0);
                } else if (topId != -1 || bottomId != -1) {
                    if (constraint.bottomToBottom != -1) {
                        this.connect(topId, 4, constraint.bottomToBottom, 4, 0);
                    } else if (constraint.topToTop != -1) {
                        this.connect(bottomId, 3, constraint.topToTop, 3, 0);
                    }
                }
            }
        }
        this.clear(viewId, 3);
        this.clear(viewId, 4);
    }

    public void removeFromHorizontalChain(int viewId) {
        if (this.mConstraints.containsKey(viewId)) {
            Constraint constraint = this.mConstraints.get(viewId);
            int leftId = constraint.leftToRight;
            int rightId = constraint.rightToLeft;
            if (leftId != -1 || rightId != -1) {
                if (leftId != -1 && rightId != -1) {
                    this.connect(leftId, 2, rightId, 1, 0);
                    this.connect(rightId, 1, leftId, 2, 0);
                } else if (leftId != -1 || rightId != -1) {
                    if (constraint.rightToRight != -1) {
                        this.connect(leftId, 2, constraint.rightToRight, 2, 0);
                    } else if (constraint.leftToLeft != -1) {
                        this.connect(rightId, 1, constraint.leftToLeft, 1, 0);
                    }
                }
                this.clear(viewId, 1);
                this.clear(viewId, 2);
            } else {
                int startId = constraint.startToEnd;
                int endId = constraint.endToStart;
                if (startId != -1 || endId != -1) {
                    if (startId != -1 && endId != -1) {
                        this.connect(startId, 7, endId, 6, 0);
                        this.connect(endId, 6, leftId, 7, 0);
                    } else if (leftId != -1 || endId != -1) {
                        if (constraint.rightToRight != -1) {
                            this.connect(leftId, 7, constraint.rightToRight, 7, 0);
                        } else if (constraint.leftToLeft != -1) {
                            this.connect(endId, 6, constraint.leftToLeft, 6, 0);
                        }
                    }
                }
                this.clear(viewId, 6);
                this.clear(viewId, 7);
            }
        }
    }

    public void create(int guidelineID, int orientation) {
        Constraint constraint = this.get(guidelineID);
        constraint.mIsGuideline = true;
        constraint.orientation = orientation;
    }

    public void createBarrier(int id2, int direction, int ... referenced) {
        Constraint constraint = this.get(id2);
        constraint.mHelperType = 1;
        constraint.mBarrierDirection = direction;
        constraint.mIsGuideline = false;
        constraint.mReferenceIds = referenced;
    }

    public void setGuidelineBegin(int guidelineID, int margin) {
        this.get((int)guidelineID).guideBegin = margin;
        this.get((int)guidelineID).guideEnd = -1;
        this.get((int)guidelineID).guidePercent = -1.0f;
    }

    public void setGuidelineEnd(int guidelineID, int margin) {
        this.get((int)guidelineID).guideEnd = margin;
        this.get((int)guidelineID).guideBegin = -1;
        this.get((int)guidelineID).guidePercent = -1.0f;
    }

    public void setGuidelinePercent(int guidelineID, float ratio) {
        this.get((int)guidelineID).guidePercent = ratio;
        this.get((int)guidelineID).guideEnd = -1;
        this.get((int)guidelineID).guideBegin = -1;
    }

    public void setBarrierType(int id2, int type) {
    }

    private Constraint get(int id2) {
        if (!this.mConstraints.containsKey(id2)) {
            this.mConstraints.put(id2, new Constraint());
        }
        return this.mConstraints.get(id2);
    }

    private String sideToString(int side) {
        switch (side) {
            case 1: {
                return "left";
            }
            case 2: {
                return "right";
            }
            case 3: {
                return "top";
            }
            case 4: {
                return "bottom";
            }
            case 5: {
                return "baseline";
            }
            case 6: {
                return "start";
            }
            case 7: {
                return "end";
            }
        }
        return "undefined";
    }

    public void load(Context context, int resourceId) {
        Resources res = context.getResources();
        XmlResourceParser parser = res.getXml(resourceId);
        String document = null;
        String tagName = null;
        try {
            int eventType = parser.getEventType();
            while (eventType != 1) {
                switch (eventType) {
                    case 0: {
                        document = parser.getName();
                        break;
                    }
                    case 2: {
                        tagName = parser.getName();
                        Constraint constraint = this.fillFromAttributeList(context, Xml.asAttributeSet((XmlPullParser)parser));
                        if (tagName.equalsIgnoreCase("Guideline")) {
                            constraint.mIsGuideline = true;
                        }
                        this.mConstraints.put(constraint.mViewId, constraint);
                        break;
                    }
                    case 3: {
                        tagName = null;
                        break;
                    }
                }
                eventType = parser.next();
            }
        }
        catch (XmlPullParserException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static int lookupID(TypedArray a, int index, int def) {
        int ret = a.getResourceId(index, def);
        if (ret == -1) {
            ret = a.getInt(index, -1);
        }
        return ret;
    }

    private Constraint fillFromAttributeList(Context context, AttributeSet attrs) {
        Constraint c = new Constraint();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ConstraintSet);
        this.populateConstraint(c, a);
        a.recycle();
        return c;
    }

    private void populateConstraint(Constraint c, TypedArray a) {
        int N = a.getIndexCount();
        block66: for (int i = 0; i < N; ++i) {
            int attr = a.getIndex(i);
            switch (mapToConstant.get(attr)) {
                case 25: {
                    c.leftToLeft = ConstraintSet.lookupID(a, attr, c.leftToLeft);
                    continue block66;
                }
                case 26: {
                    c.leftToRight = ConstraintSet.lookupID(a, attr, c.leftToRight);
                    continue block66;
                }
                case 29: {
                    c.rightToLeft = ConstraintSet.lookupID(a, attr, c.rightToLeft);
                    continue block66;
                }
                case 30: {
                    c.rightToRight = ConstraintSet.lookupID(a, attr, c.rightToRight);
                    continue block66;
                }
                case 36: {
                    c.topToTop = ConstraintSet.lookupID(a, attr, c.topToTop);
                    continue block66;
                }
                case 35: {
                    c.topToBottom = ConstraintSet.lookupID(a, attr, c.topToBottom);
                    continue block66;
                }
                case 4: {
                    c.bottomToTop = ConstraintSet.lookupID(a, attr, c.bottomToTop);
                    continue block66;
                }
                case 3: {
                    c.bottomToBottom = ConstraintSet.lookupID(a, attr, c.bottomToBottom);
                    continue block66;
                }
                case 1: {
                    c.baselineToBaseline = ConstraintSet.lookupID(a, attr, c.baselineToBaseline);
                    continue block66;
                }
                case 6: {
                    c.editorAbsoluteX = a.getDimensionPixelOffset(attr, c.editorAbsoluteX);
                    continue block66;
                }
                case 7: {
                    c.editorAbsoluteY = a.getDimensionPixelOffset(attr, c.editorAbsoluteY);
                    continue block66;
                }
                case 17: {
                    c.guideBegin = a.getDimensionPixelOffset(attr, c.guideBegin);
                    continue block66;
                }
                case 18: {
                    c.guideEnd = a.getDimensionPixelOffset(attr, c.guideEnd);
                    continue block66;
                }
                case 19: {
                    c.guidePercent = a.getFloat(attr, c.guidePercent);
                    continue block66;
                }
                case 27: {
                    c.orientation = a.getInt(attr, c.orientation);
                    continue block66;
                }
                case 32: {
                    c.startToEnd = ConstraintSet.lookupID(a, attr, c.startToEnd);
                    continue block66;
                }
                case 33: {
                    c.startToStart = ConstraintSet.lookupID(a, attr, c.startToStart);
                    continue block66;
                }
                case 10: {
                    c.endToStart = ConstraintSet.lookupID(a, attr, c.endToStart);
                    continue block66;
                }
                case 9: {
                    c.endToEnd = ConstraintSet.lookupID(a, attr, c.endToEnd);
                    continue block66;
                }
                case 61: {
                    c.circleConstraint = ConstraintSet.lookupID(a, attr, c.circleConstraint);
                    continue block66;
                }
                case 62: {
                    c.circleRadius = a.getDimensionPixelSize(attr, c.circleRadius);
                    continue block66;
                }
                case 63: {
                    c.circleAngle = a.getFloat(attr, c.circleAngle);
                    continue block66;
                }
                case 13: {
                    c.goneLeftMargin = a.getDimensionPixelSize(attr, c.goneLeftMargin);
                    continue block66;
                }
                case 16: {
                    c.goneTopMargin = a.getDimensionPixelSize(attr, c.goneTopMargin);
                    continue block66;
                }
                case 14: {
                    c.goneRightMargin = a.getDimensionPixelSize(attr, c.goneRightMargin);
                    continue block66;
                }
                case 11: {
                    c.goneBottomMargin = a.getDimensionPixelSize(attr, c.goneBottomMargin);
                    continue block66;
                }
                case 15: {
                    c.goneStartMargin = a.getDimensionPixelSize(attr, c.goneStartMargin);
                    continue block66;
                }
                case 12: {
                    c.goneEndMargin = a.getDimensionPixelSize(attr, c.goneEndMargin);
                    continue block66;
                }
                case 20: {
                    c.horizontalBias = a.getFloat(attr, c.horizontalBias);
                    continue block66;
                }
                case 37: {
                    c.verticalBias = a.getFloat(attr, c.verticalBias);
                    continue block66;
                }
                case 24: {
                    c.leftMargin = a.getDimensionPixelSize(attr, c.leftMargin);
                    continue block66;
                }
                case 28: {
                    c.rightMargin = a.getDimensionPixelSize(attr, c.rightMargin);
                    continue block66;
                }
                case 31: {
                    c.startMargin = a.getDimensionPixelSize(attr, c.startMargin);
                    continue block66;
                }
                case 8: {
                    c.endMargin = a.getDimensionPixelSize(attr, c.endMargin);
                    continue block66;
                }
                case 34: {
                    c.topMargin = a.getDimensionPixelSize(attr, c.topMargin);
                    continue block66;
                }
                case 2: {
                    c.bottomMargin = a.getDimensionPixelSize(attr, c.bottomMargin);
                    continue block66;
                }
                case 23: {
                    c.mWidth = a.getLayoutDimension(attr, c.mWidth);
                    continue block66;
                }
                case 21: {
                    c.mHeight = a.getLayoutDimension(attr, c.mHeight);
                    continue block66;
                }
                case 22: {
                    c.visibility = a.getInt(attr, c.visibility);
                    c.visibility = VISIBILITY_FLAGS[c.visibility];
                    continue block66;
                }
                case 43: {
                    c.alpha = a.getFloat(attr, c.alpha);
                    continue block66;
                }
                case 44: {
                    c.applyElevation = true;
                    c.elevation = a.getDimension(attr, c.elevation);
                    continue block66;
                }
                case 60: {
                    c.rotation = a.getFloat(attr, c.rotation);
                    continue block66;
                }
                case 45: {
                    c.rotationX = a.getFloat(attr, c.rotationX);
                    continue block66;
                }
                case 46: {
                    c.rotationY = a.getFloat(attr, c.rotationY);
                    continue block66;
                }
                case 47: {
                    c.scaleX = a.getFloat(attr, c.scaleX);
                    continue block66;
                }
                case 48: {
                    c.scaleY = a.getFloat(attr, c.scaleY);
                    continue block66;
                }
                case 49: {
                    c.transformPivotX = a.getFloat(attr, c.transformPivotX);
                    continue block66;
                }
                case 50: {
                    c.transformPivotY = a.getFloat(attr, c.transformPivotY);
                    continue block66;
                }
                case 51: {
                    c.translationX = a.getDimension(attr, c.translationX);
                    continue block66;
                }
                case 52: {
                    c.translationY = a.getDimension(attr, c.translationY);
                    continue block66;
                }
                case 53: {
                    c.translationZ = a.getDimension(attr, c.translationZ);
                    continue block66;
                }
                case 40: {
                    c.verticalWeight = a.getFloat(attr, c.verticalWeight);
                    continue block66;
                }
                case 39: {
                    c.horizontalWeight = a.getFloat(attr, c.horizontalWeight);
                    continue block66;
                }
                case 42: {
                    c.verticalChainStyle = a.getInt(attr, c.verticalChainStyle);
                    continue block66;
                }
                case 41: {
                    c.horizontalChainStyle = a.getInt(attr, c.horizontalChainStyle);
                    continue block66;
                }
                case 38: {
                    c.mViewId = a.getResourceId(attr, c.mViewId);
                    continue block66;
                }
                case 5: {
                    c.dimensionRatio = a.getString(attr);
                    continue block66;
                }
                case 69: {
                    c.widthPercent = a.getFloat(attr, 1.0f);
                    continue block66;
                }
                case 70: {
                    c.heightPercent = a.getFloat(attr, 1.0f);
                    continue block66;
                }
                case 71: {
                    Log.e((String)TAG, (String)"CURRENTLY UNSUPPORTED");
                    continue block66;
                }
                case 72: {
                    c.mBarrierDirection = a.getInt(attr, c.mBarrierDirection);
                    continue block66;
                }
                case 73: {
                    c.mReferenceIdString = a.getString(attr);
                    continue block66;
                }
                case 74: {
                    c.mBarrierAllowsGoneWidgets = a.getBoolean(attr, c.mBarrierAllowsGoneWidgets);
                    continue block66;
                }
                case 75: {
                    Log.w((String)TAG, (String)("unused attribute 0x" + Integer.toHexString(attr) + "   " + mapToConstant.get(attr)));
                    continue block66;
                }
                default: {
                    Log.w((String)TAG, (String)("Unknown attribute 0x" + Integer.toHexString(attr) + "   " + mapToConstant.get(attr)));
                }
            }
        }
    }

    private int[] convertReferenceString(View view, String referenceIdString) {
        String[] split = referenceIdString.split(",");
        Context context = view.getContext();
        int[] tags = new int[split.length];
        int count = 0;
        for (int i = 0; i < split.length; ++i) {
            ConstraintLayout constraintLayout;
            Object value;
            String idString = split[i];
            idString = idString.trim();
            int tag = 0;
            try {
                Class<R.id> res = R.id.class;
                Field field = res.getField(idString);
                tag = field.getInt(null);
            }
            catch (Exception res) {
                // empty catch block
            }
            if (tag == 0) {
                tag = context.getResources().getIdentifier(idString, "id", context.getPackageName());
            }
            if (tag == 0 && view.isInEditMode() && view.getParent() instanceof ConstraintLayout && (value = (constraintLayout = (ConstraintLayout)view.getParent()).getDesignInformation(0, idString)) != null && value instanceof Integer) {
                tag = (Integer)value;
            }
            tags[count++] = tag;
        }
        if (count != split.length) {
            tags = Arrays.copyOf(tags, count);
        }
        return tags;
    }

    static {
        mapToConstant.append(R.styleable.ConstraintSet_layout_constraintLeft_toLeftOf, 25);
        mapToConstant.append(R.styleable.ConstraintSet_layout_constraintLeft_toRightOf, 26);
        mapToConstant.append(R.styleable.ConstraintSet_layout_constraintRight_toLeftOf, 29);
        mapToConstant.append(R.styleable.ConstraintSet_layout_constraintRight_toRightOf, 30);
        mapToConstant.append(R.styleable.ConstraintSet_layout_constraintTop_toTopOf, 36);
        mapToConstant.append(R.styleable.ConstraintSet_layout_constraintTop_toBottomOf, 35);
        mapToConstant.append(R.styleable.ConstraintSet_layout_constraintBottom_toTopOf, 4);
        mapToConstant.append(R.styleable.ConstraintSet_layout_constraintBottom_toBottomOf, 3);
        mapToConstant.append(R.styleable.ConstraintSet_layout_constraintBaseline_toBaselineOf, 1);
        mapToConstant.append(R.styleable.ConstraintSet_layout_editor_absoluteX, 6);
        mapToConstant.append(R.styleable.ConstraintSet_layout_editor_absoluteY, 7);
        mapToConstant.append(R.styleable.ConstraintSet_layout_constraintGuide_begin, 17);
        mapToConstant.append(R.styleable.ConstraintSet_layout_constraintGuide_end, 18);
        mapToConstant.append(R.styleable.ConstraintSet_layout_constraintGuide_percent, 19);
        mapToConstant.append(R.styleable.ConstraintSet_android_orientation, 27);
        mapToConstant.append(R.styleable.ConstraintSet_layout_constraintStart_toEndOf, 32);
        mapToConstant.append(R.styleable.ConstraintSet_layout_constraintStart_toStartOf, 33);
        mapToConstant.append(R.styleable.ConstraintSet_layout_constraintEnd_toStartOf, 10);
        mapToConstant.append(R.styleable.ConstraintSet_layout_constraintEnd_toEndOf, 9);
        mapToConstant.append(R.styleable.ConstraintSet_layout_goneMarginLeft, 13);
        mapToConstant.append(R.styleable.ConstraintSet_layout_goneMarginTop, 16);
        mapToConstant.append(R.styleable.ConstraintSet_layout_goneMarginRight, 14);
        mapToConstant.append(R.styleable.ConstraintSet_layout_goneMarginBottom, 11);
        mapToConstant.append(R.styleable.ConstraintSet_layout_goneMarginStart, 15);
        mapToConstant.append(R.styleable.ConstraintSet_layout_goneMarginEnd, 12);
        mapToConstant.append(R.styleable.ConstraintSet_layout_constraintVertical_weight, 40);
        mapToConstant.append(R.styleable.ConstraintSet_layout_constraintHorizontal_weight, 39);
        mapToConstant.append(R.styleable.ConstraintSet_layout_constraintHorizontal_chainStyle, 41);
        mapToConstant.append(R.styleable.ConstraintSet_layout_constraintVertical_chainStyle, 42);
        mapToConstant.append(R.styleable.ConstraintSet_layout_constraintHorizontal_bias, 20);
        mapToConstant.append(R.styleable.ConstraintSet_layout_constraintVertical_bias, 37);
        mapToConstant.append(R.styleable.ConstraintSet_layout_constraintDimensionRatio, 5);
        mapToConstant.append(R.styleable.ConstraintSet_layout_constraintLeft_creator, 75);
        mapToConstant.append(R.styleable.ConstraintSet_layout_constraintTop_creator, 75);
        mapToConstant.append(R.styleable.ConstraintSet_layout_constraintRight_creator, 75);
        mapToConstant.append(R.styleable.ConstraintSet_layout_constraintBottom_creator, 75);
        mapToConstant.append(R.styleable.ConstraintSet_layout_constraintBaseline_creator, 75);
        mapToConstant.append(R.styleable.ConstraintSet_android_layout_marginLeft, 24);
        mapToConstant.append(R.styleable.ConstraintSet_android_layout_marginRight, 28);
        mapToConstant.append(R.styleable.ConstraintSet_android_layout_marginStart, 31);
        mapToConstant.append(R.styleable.ConstraintSet_android_layout_marginEnd, 8);
        mapToConstant.append(R.styleable.ConstraintSet_android_layout_marginTop, 34);
        mapToConstant.append(R.styleable.ConstraintSet_android_layout_marginBottom, 2);
        mapToConstant.append(R.styleable.ConstraintSet_android_layout_width, 23);
        mapToConstant.append(R.styleable.ConstraintSet_android_layout_height, 21);
        mapToConstant.append(R.styleable.ConstraintSet_android_visibility, 22);
        mapToConstant.append(R.styleable.ConstraintSet_android_alpha, 43);
        mapToConstant.append(R.styleable.ConstraintSet_android_elevation, 44);
        mapToConstant.append(R.styleable.ConstraintSet_android_rotationX, 45);
        mapToConstant.append(R.styleable.ConstraintSet_android_rotationY, 46);
        mapToConstant.append(R.styleable.ConstraintSet_android_rotation, 60);
        mapToConstant.append(R.styleable.ConstraintSet_android_scaleX, 47);
        mapToConstant.append(R.styleable.ConstraintSet_android_scaleY, 48);
        mapToConstant.append(R.styleable.ConstraintSet_android_transformPivotX, 49);
        mapToConstant.append(R.styleable.ConstraintSet_android_transformPivotY, 50);
        mapToConstant.append(R.styleable.ConstraintSet_android_translationX, 51);
        mapToConstant.append(R.styleable.ConstraintSet_android_translationY, 52);
        mapToConstant.append(R.styleable.ConstraintSet_android_translationZ, 53);
        mapToConstant.append(R.styleable.ConstraintSet_layout_constraintWidth_default, 54);
        mapToConstant.append(R.styleable.ConstraintSet_layout_constraintHeight_default, 55);
        mapToConstant.append(R.styleable.ConstraintSet_layout_constraintWidth_max, 56);
        mapToConstant.append(R.styleable.ConstraintSet_layout_constraintHeight_max, 57);
        mapToConstant.append(R.styleable.ConstraintSet_layout_constraintWidth_min, 58);
        mapToConstant.append(R.styleable.ConstraintSet_layout_constraintHeight_min, 59);
        mapToConstant.append(R.styleable.ConstraintSet_layout_constraintCircle, 61);
        mapToConstant.append(R.styleable.ConstraintSet_layout_constraintCircleRadius, 62);
        mapToConstant.append(R.styleable.ConstraintSet_layout_constraintCircleAngle, 63);
        mapToConstant.append(R.styleable.ConstraintSet_android_id, 38);
        mapToConstant.append(R.styleable.ConstraintSet_layout_constraintWidth_percent, 69);
        mapToConstant.append(R.styleable.ConstraintSet_layout_constraintHeight_percent, 70);
        mapToConstant.append(R.styleable.ConstraintSet_chainUseRtl, 71);
        mapToConstant.append(R.styleable.ConstraintSet_barrierDirection, 72);
        mapToConstant.append(R.styleable.ConstraintSet_constraint_referenced_ids, 73);
        mapToConstant.append(R.styleable.ConstraintSet_barrierAllowsGoneWidgets, 74);
    }

    private static class Constraint {
        boolean mIsGuideline = false;
        public int mWidth;
        public int mHeight;
        int mViewId;
        static final int UNSET = -1;
        public int guideBegin = -1;
        public int guideEnd = -1;
        public float guidePercent = -1.0f;
        public int leftToLeft = -1;
        public int leftToRight = -1;
        public int rightToLeft = -1;
        public int rightToRight = -1;
        public int topToTop = -1;
        public int topToBottom = -1;
        public int bottomToTop = -1;
        public int bottomToBottom = -1;
        public int baselineToBaseline = -1;
        public int startToEnd = -1;
        public int startToStart = -1;
        public int endToStart = -1;
        public int endToEnd = -1;
        public float horizontalBias = 0.5f;
        public float verticalBias = 0.5f;
        public String dimensionRatio = null;
        public int circleConstraint = -1;
        public int circleRadius = 0;
        public float circleAngle = 0.0f;
        public int editorAbsoluteX = -1;
        public int editorAbsoluteY = -1;
        public int orientation = -1;
        public int leftMargin = -1;
        public int rightMargin = -1;
        public int topMargin = -1;
        public int bottomMargin = -1;
        public int endMargin = -1;
        public int startMargin = -1;
        public int visibility = 0;
        public int goneLeftMargin = -1;
        public int goneTopMargin = -1;
        public int goneRightMargin = -1;
        public int goneBottomMargin = -1;
        public int goneEndMargin = -1;
        public int goneStartMargin = -1;
        public float verticalWeight = 0.0f;
        public float horizontalWeight = 0.0f;
        public int horizontalChainStyle = 0;
        public int verticalChainStyle = 0;
        public float alpha = 1.0f;
        public boolean applyElevation = false;
        public float elevation = 0.0f;
        public float rotation = 0.0f;
        public float rotationX = 0.0f;
        public float rotationY = 0.0f;
        public float scaleX = 1.0f;
        public float scaleY = 1.0f;
        public float transformPivotX = Float.NaN;
        public float transformPivotY = Float.NaN;
        public float translationX = 0.0f;
        public float translationY = 0.0f;
        public float translationZ = 0.0f;
        public boolean constrainedWidth = false;
        public boolean constrainedHeight = false;
        public int widthDefault = 0;
        public int heightDefault = 0;
        public int widthMax = -1;
        public int heightMax = -1;
        public int widthMin = -1;
        public int heightMin = -1;
        public float widthPercent = 1.0f;
        public float heightPercent = 1.0f;
        public boolean mBarrierAllowsGoneWidgets = false;
        public int mBarrierDirection = -1;
        public int mHelperType = -1;
        public int[] mReferenceIds;
        public String mReferenceIdString;

        private Constraint() {
        }

        public Constraint clone() {
            Constraint clone = new Constraint();
            clone.mIsGuideline = this.mIsGuideline;
            clone.mWidth = this.mWidth;
            clone.mHeight = this.mHeight;
            clone.guideBegin = this.guideBegin;
            clone.guideEnd = this.guideEnd;
            clone.guidePercent = this.guidePercent;
            clone.leftToLeft = this.leftToLeft;
            clone.leftToRight = this.leftToRight;
            clone.rightToLeft = this.rightToLeft;
            clone.rightToRight = this.rightToRight;
            clone.topToTop = this.topToTop;
            clone.topToBottom = this.topToBottom;
            clone.bottomToTop = this.bottomToTop;
            clone.bottomToBottom = this.bottomToBottom;
            clone.baselineToBaseline = this.baselineToBaseline;
            clone.startToEnd = this.startToEnd;
            clone.startToStart = this.startToStart;
            clone.endToStart = this.endToStart;
            clone.endToEnd = this.endToEnd;
            clone.horizontalBias = this.horizontalBias;
            clone.verticalBias = this.verticalBias;
            clone.dimensionRatio = this.dimensionRatio;
            clone.editorAbsoluteX = this.editorAbsoluteX;
            clone.editorAbsoluteY = this.editorAbsoluteY;
            clone.horizontalBias = this.horizontalBias;
            clone.horizontalBias = this.horizontalBias;
            clone.horizontalBias = this.horizontalBias;
            clone.horizontalBias = this.horizontalBias;
            clone.horizontalBias = this.horizontalBias;
            clone.orientation = this.orientation;
            clone.leftMargin = this.leftMargin;
            clone.rightMargin = this.rightMargin;
            clone.topMargin = this.topMargin;
            clone.bottomMargin = this.bottomMargin;
            clone.endMargin = this.endMargin;
            clone.startMargin = this.startMargin;
            clone.visibility = this.visibility;
            clone.goneLeftMargin = this.goneLeftMargin;
            clone.goneTopMargin = this.goneTopMargin;
            clone.goneRightMargin = this.goneRightMargin;
            clone.goneBottomMargin = this.goneBottomMargin;
            clone.goneEndMargin = this.goneEndMargin;
            clone.goneStartMargin = this.goneStartMargin;
            clone.verticalWeight = this.verticalWeight;
            clone.horizontalWeight = this.horizontalWeight;
            clone.horizontalChainStyle = this.horizontalChainStyle;
            clone.verticalChainStyle = this.verticalChainStyle;
            clone.alpha = this.alpha;
            clone.applyElevation = this.applyElevation;
            clone.elevation = this.elevation;
            clone.rotation = this.rotation;
            clone.rotationX = this.rotationX;
            clone.rotationY = this.rotationY;
            clone.scaleX = this.scaleX;
            clone.scaleY = this.scaleY;
            clone.transformPivotX = this.transformPivotX;
            clone.transformPivotY = this.transformPivotY;
            clone.translationX = this.translationX;
            clone.translationY = this.translationY;
            clone.translationZ = this.translationZ;
            clone.constrainedWidth = this.constrainedWidth;
            clone.constrainedHeight = this.constrainedHeight;
            clone.widthDefault = this.widthDefault;
            clone.heightDefault = this.heightDefault;
            clone.widthMax = this.widthMax;
            clone.heightMax = this.heightMax;
            clone.widthMin = this.widthMin;
            clone.heightMin = this.heightMin;
            clone.widthPercent = this.widthPercent;
            clone.heightPercent = this.heightPercent;
            clone.mBarrierDirection = this.mBarrierDirection;
            clone.mHelperType = this.mHelperType;
            if (this.mReferenceIds != null) {
                clone.mReferenceIds = Arrays.copyOf(this.mReferenceIds, this.mReferenceIds.length);
            }
            clone.circleConstraint = this.circleConstraint;
            clone.circleRadius = this.circleRadius;
            clone.circleAngle = this.circleAngle;
            clone.mBarrierAllowsGoneWidgets = this.mBarrierAllowsGoneWidgets;
            return clone;
        }

        private void fillFromConstraints(ConstraintHelper helper, int viewId, Constraints.LayoutParams param) {
            this.fillFromConstraints(viewId, param);
            if (helper instanceof Barrier) {
                this.mHelperType = 1;
                Barrier barrier = (Barrier)helper;
                this.mBarrierDirection = barrier.getType();
                this.mReferenceIds = barrier.getReferencedIds();
            }
        }

        private void fillFromConstraints(int viewId, Constraints.LayoutParams param) {
            this.fillFrom(viewId, param);
            this.alpha = param.alpha;
            this.rotation = param.rotation;
            this.rotationX = param.rotationX;
            this.rotationY = param.rotationY;
            this.scaleX = param.scaleX;
            this.scaleY = param.scaleY;
            this.transformPivotX = param.transformPivotX;
            this.transformPivotY = param.transformPivotY;
            this.translationX = param.translationX;
            this.translationY = param.translationY;
            this.translationZ = param.translationZ;
            this.elevation = param.elevation;
            this.applyElevation = param.applyElevation;
        }

        private void fillFrom(int viewId, ConstraintLayout.LayoutParams param) {
            this.mViewId = viewId;
            this.leftToLeft = param.leftToLeft;
            this.leftToRight = param.leftToRight;
            this.rightToLeft = param.rightToLeft;
            this.rightToRight = param.rightToRight;
            this.topToTop = param.topToTop;
            this.topToBottom = param.topToBottom;
            this.bottomToTop = param.bottomToTop;
            this.bottomToBottom = param.bottomToBottom;
            this.baselineToBaseline = param.baselineToBaseline;
            this.startToEnd = param.startToEnd;
            this.startToStart = param.startToStart;
            this.endToStart = param.endToStart;
            this.endToEnd = param.endToEnd;
            this.horizontalBias = param.horizontalBias;
            this.verticalBias = param.verticalBias;
            this.dimensionRatio = param.dimensionRatio;
            this.circleConstraint = param.circleConstraint;
            this.circleRadius = param.circleRadius;
            this.circleAngle = param.circleAngle;
            this.editorAbsoluteX = param.editorAbsoluteX;
            this.editorAbsoluteY = param.editorAbsoluteY;
            this.orientation = param.orientation;
            this.guidePercent = param.guidePercent;
            this.guideBegin = param.guideBegin;
            this.guideEnd = param.guideEnd;
            this.mWidth = param.width;
            this.mHeight = param.height;
            this.leftMargin = param.leftMargin;
            this.rightMargin = param.rightMargin;
            this.topMargin = param.topMargin;
            this.bottomMargin = param.bottomMargin;
            this.verticalWeight = param.verticalWeight;
            this.horizontalWeight = param.horizontalWeight;
            this.verticalChainStyle = param.verticalChainStyle;
            this.horizontalChainStyle = param.horizontalChainStyle;
            this.constrainedWidth = param.constrainedWidth;
            this.constrainedHeight = param.constrainedHeight;
            this.widthDefault = param.matchConstraintDefaultWidth;
            this.heightDefault = param.matchConstraintDefaultHeight;
            this.constrainedWidth = param.constrainedWidth;
            this.widthMax = param.matchConstraintMaxWidth;
            this.heightMax = param.matchConstraintMaxHeight;
            this.widthMin = param.matchConstraintMinWidth;
            this.heightMin = param.matchConstraintMinHeight;
            this.widthPercent = param.matchConstraintPercentWidth;
            this.heightPercent = param.matchConstraintPercentHeight;
            int currentapiVersion = Build.VERSION.SDK_INT;
            if (currentapiVersion >= 17) {
                this.endMargin = param.getMarginEnd();
                this.startMargin = param.getMarginStart();
            }
        }

        public void applyTo(ConstraintLayout.LayoutParams param) {
            param.leftToLeft = this.leftToLeft;
            param.leftToRight = this.leftToRight;
            param.rightToLeft = this.rightToLeft;
            param.rightToRight = this.rightToRight;
            param.topToTop = this.topToTop;
            param.topToBottom = this.topToBottom;
            param.bottomToTop = this.bottomToTop;
            param.bottomToBottom = this.bottomToBottom;
            param.baselineToBaseline = this.baselineToBaseline;
            param.startToEnd = this.startToEnd;
            param.startToStart = this.startToStart;
            param.endToStart = this.endToStart;
            param.endToEnd = this.endToEnd;
            param.leftMargin = this.leftMargin;
            param.rightMargin = this.rightMargin;
            param.topMargin = this.topMargin;
            param.bottomMargin = this.bottomMargin;
            param.goneStartMargin = this.goneStartMargin;
            param.goneEndMargin = this.goneEndMargin;
            param.horizontalBias = this.horizontalBias;
            param.verticalBias = this.verticalBias;
            param.circleConstraint = this.circleConstraint;
            param.circleRadius = this.circleRadius;
            param.circleAngle = this.circleAngle;
            param.dimensionRatio = this.dimensionRatio;
            param.editorAbsoluteX = this.editorAbsoluteX;
            param.editorAbsoluteY = this.editorAbsoluteY;
            param.verticalWeight = this.verticalWeight;
            param.horizontalWeight = this.horizontalWeight;
            param.verticalChainStyle = this.verticalChainStyle;
            param.horizontalChainStyle = this.horizontalChainStyle;
            param.constrainedWidth = this.constrainedWidth;
            param.constrainedHeight = this.constrainedHeight;
            param.matchConstraintDefaultWidth = this.widthDefault;
            param.matchConstraintDefaultHeight = this.heightDefault;
            param.matchConstraintMaxWidth = this.widthMax;
            param.matchConstraintMaxHeight = this.heightMax;
            param.matchConstraintMinWidth = this.widthMin;
            param.matchConstraintMinHeight = this.heightMin;
            param.matchConstraintPercentWidth = this.widthPercent;
            param.matchConstraintPercentHeight = this.heightPercent;
            param.orientation = this.orientation;
            param.guidePercent = this.guidePercent;
            param.guideBegin = this.guideBegin;
            param.guideEnd = this.guideEnd;
            param.width = this.mWidth;
            param.height = this.mHeight;
            if (Build.VERSION.SDK_INT >= 17) {
                param.setMarginStart(this.startMargin);
                param.setMarginEnd(this.endMargin);
            }
            param.validate();
        }
    }
}

