/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.runner.intercepting;

import android.app.Activity;
import android.content.Intent;
import androidx.test.internal.util.Checks;
import androidx.test.runner.intercepting.InterceptingActivityFactory;

public abstract class SingleActivityFactory<T extends Activity>
implements InterceptingActivityFactory {
    private final Class<T> activityClassToIntercept;

    public SingleActivityFactory(Class<T> activityClassToIntercept) {
        Checks.checkNotNull(activityClassToIntercept);
        this.activityClassToIntercept = (Class)Checks.checkNotNull(activityClassToIntercept);
    }

    public final boolean shouldIntercept(ClassLoader classLoader, String className, Intent intent) {
        return this.activityClassToIntercept.getName().equals(className);
    }

    public final Activity create(ClassLoader classLoader, String className, Intent intent) {
        if (!this.shouldIntercept(classLoader, className, intent)) {
            throw new UnsupportedOperationException(String.format("Can't create instance of %s", className));
        }
        return this.create(intent);
    }

    public final Class<T> getActivityClassToIntercept() {
        return this.activityClassToIntercept;
    }

    protected abstract T create(Intent var1);
}

