/*
 * Decompiled with CFR 0.152.
 */
package androidx.recyclerview.widget;

import android.graphics.Canvas;
import android.os.Build;
import android.view.View;
import androidx.core.view.ViewCompat;
import androidx.recyclerview.R;
import androidx.recyclerview.widget.ItemTouchUIUtil;
import androidx.recyclerview.widget.RecyclerView;

class ItemTouchUIUtilImpl
implements ItemTouchUIUtil {
    static final ItemTouchUIUtil INSTANCE = new ItemTouchUIUtilImpl();

    ItemTouchUIUtilImpl() {
    }

    @Override
    public void onDraw(Canvas c, RecyclerView recyclerView, View view, float dX, float dY, int actionState, boolean isCurrentlyActive) {
        Object originalElevation;
        if (Build.VERSION.SDK_INT >= 21 && isCurrentlyActive && (originalElevation = view.getTag(R.id.item_touch_helper_previous_elevation)) == null) {
            originalElevation = Float.valueOf(ViewCompat.getElevation((View)view));
            float newElevation = 1.0f + ItemTouchUIUtilImpl.findMaxElevation(recyclerView, view);
            ViewCompat.setElevation((View)view, (float)newElevation);
            view.setTag(R.id.item_touch_helper_previous_elevation, originalElevation);
        }
        view.setTranslationX(dX);
        view.setTranslationY(dY);
    }

    private static float findMaxElevation(RecyclerView recyclerView, View itemView) {
        int childCount = recyclerView.getChildCount();
        float max = 0.0f;
        for (int i = 0; i < childCount; ++i) {
            float elevation;
            View child = recyclerView.getChildAt(i);
            if (child == itemView || !((elevation = ViewCompat.getElevation((View)child)) > max)) continue;
            max = elevation;
        }
        return max;
    }

    @Override
    public void onDrawOver(Canvas c, RecyclerView recyclerView, View view, float dX, float dY, int actionState, boolean isCurrentlyActive) {
    }

    @Override
    public void clearView(View view) {
        if (Build.VERSION.SDK_INT >= 21) {
            Object tag = view.getTag(R.id.item_touch_helper_previous_elevation);
            if (tag != null && tag instanceof Float) {
                ViewCompat.setElevation((View)view, (float)((Float)tag).floatValue());
            }
            view.setTag(R.id.item_touch_helper_previous_elevation, null);
        }
        view.setTranslationX(0.0f);
        view.setTranslationY(0.0f);
    }

    @Override
    public void onSelected(View view) {
    }
}

